/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.imagegallery.DuplicateImageNameException;
import com.liferay.portlet.imagegallery.ImageNameException;
import com.liferay.portlet.imagegallery.ImageSizeException;
import com.liferay.portlet.imagegallery.NoSuchFolderException;
import com.liferay.portlet.imagegallery.NoSuchImageException;
import com.liferay.portlet.imagegallery.action.ActionUtil;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGImageServiceUtil;
import com.liferay.portlet.tags.TagsEntryException;
import java.io.File;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditImageAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateImage(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteImage(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchImageException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.image_gallery.error");
            }
            if (e instanceof DuplicateImageNameException || e instanceof ImageNameException || e instanceof ImageSizeException || e instanceof NoSuchFolderException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            if (e instanceof TagsEntryException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getImage(renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchImageException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.image_gallery.error");
            }
            throw e;
        }
        String forward = "portlet.image_gallery.edit_image";
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, forward));
    }

    protected void deleteImage(ActionRequest actionRequest) throws Exception {
        long imageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"imageId");
        IGImageServiceUtil.deleteImage((long)imageId);
    }

    protected String getContentType(UploadPortletRequest uploadRequest, File file) {
        String ext;
        String contentType = GetterUtil.getString((String)uploadRequest.getContentType("file"));
        if (contentType.equals("application/octet-stream") && Validator.isNotNull((String)(ext = GetterUtil.getString((String)FileUtil.getExtension((String)file.getName())).toLowerCase()))) {
            contentType = MimeTypesUtil.getContentType((String)ext);
        }
        return contentType;
    }

    protected void updateImage(ActionRequest actionRequest) throws Exception {
        String ext;
        UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest((ActionRequest)actionRequest);
        long imageId = ParamUtil.getLong((HttpServletRequest)uploadRequest, (String)"imageId");
        long folderId = ParamUtil.getLong((HttpServletRequest)uploadRequest, (String)"folderId");
        String name = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"name");
        String fileName = uploadRequest.getFileName("file");
        String description = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"description", (String)fileName);
        File file = uploadRequest.getFile("file");
        String contentType = this.getContentType(uploadRequest, file);
        if (contentType.equals("application/octet-stream") && Validator.isNotNull((String)(ext = GetterUtil.getString((String)FileUtil.getExtension((String)file.getName())).toLowerCase()))) {
            contentType = MimeTypesUtil.getContentType((String)ext);
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)IGImage.class.getName(), (PortletRequest)actionRequest);
        if (imageId <= 0L) {
            if (Validator.isNull((String)name)) {
                name = fileName;
            }
            IGImage image = IGImageServiceUtil.addImage((long)folderId, (String)name, (String)description, (File)file, (String)contentType, (ServiceContext)serviceContext);
            AssetPublisherUtil.addAndStoreSelection(actionRequest, IGImage.class.getName(), image.getImageId(), -1);
        } else {
            if (Validator.isNull((String)fileName)) {
                file = null;
            }
            IGImageServiceUtil.updateImage((long)imageId, (long)folderId, (String)name, (String)description, (File)file, (String)contentType, (ServiceContext)serviceContext);
        }
        AssetPublisherUtil.addRecentFolderId((PortletRequest)actionRequest, IGImage.class.getName(), folderId);
    }
}

