/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.lar;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.BasePortletDataHandler;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataException;
import com.liferay.portal.lar.PortletDataHandlerBoolean;
import com.liferay.portal.lar.PortletDataHandlerControl;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.ImageUtil;
import com.liferay.portlet.imagegallery.NoSuchFolderException;
import com.liferay.portlet.imagegallery.NoSuchImageException;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGFolderLocalServiceUtil;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import com.liferay.portlet.imagegallery.service.persistence.IGFolderUtil;
import com.liferay.portlet.imagegallery.service.persistence.IGImageUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "image_gallery";
    private static final PortletDataHandlerBoolean _foldersAndImages = new PortletDataHandlerBoolean("image_gallery", "folders-and-images", true, true);
    private static final PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("image_gallery", "tags");
    private static Log _log = LogFactoryUtil.getLog(IGPortletDataHandlerImpl.class);

    public static void exportImage(PortletDataContext context, Element foldersEl, Element imagesEl, IGImage image) throws PortalException, SystemException {
        if (!context.isWithinDateRange(image.getModifiedDate())) {
            return;
        }
        IGPortletDataHandlerImpl.exportParentFolder(context, foldersEl, image.getFolderId());
        String path = IGPortletDataHandlerImpl.getImagePath(context, image);
        if (context.isPathNotProcessed(path)) {
            Element imageEl = imagesEl.addElement("image");
            imageEl.addAttribute("path", path);
            imageEl.addAttribute("bin-path", IGPortletDataHandlerImpl.getImageBinPath(context, image));
            if (context.getBooleanParameter(_NAMESPACE, "tags")) {
                context.addTagsEntries(IGImage.class, image.getImageId());
            }
            image.setUserUuid(image.getUserUuid());
            Image largeImage = ImageUtil.findByPrimaryKey((long)image.getLargeImageId());
            image.setImageType(largeImage.getType());
            context.addZipEntry(IGPortletDataHandlerImpl.getImageBinPath(context, image), largeImage.getTextObj());
            context.addZipEntry(path, (Object)image);
        }
    }

    public static void importFolder(PortletDataContext context, Map<Long, Long> folderPKs, IGFolder folder) throws Exception {
        long userId = context.getUserId(folder.getUserUuid());
        long parentFolderId = MapUtil.getLong(folderPKs, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(context.getGroupId());
        if (parentFolderId != 0L && parentFolderId == folder.getParentFolderId()) {
            String path = IGPortletDataHandlerImpl.getImportFolderPath(context, parentFolderId);
            IGFolder parentFolder = (IGFolder)context.getZipEntryAsObject(path);
            IGPortletDataHandlerImpl.importFolder(context, folderPKs, parentFolder);
            parentFolderId = MapUtil.getLong(folderPKs, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        }
        IGFolder existingFolder = null;
        try {
            String name;
            if (parentFolderId != 0L) {
                IGFolderUtil.findByPrimaryKey((long)parentFolderId);
            }
            if (context.getDataStrategy().equals("DATA_STRATEGY_MIRROR")) {
                existingFolder = IGFolderUtil.fetchByUUID_G((String)folder.getUuid(), (long)context.getGroupId());
                if (existingFolder == null) {
                    name = IGPortletDataHandlerImpl.getFolderName(context.getCompanyId(), context.getGroupId(), parentFolderId, folder.getName(), 2);
                    existingFolder = IGFolderLocalServiceUtil.addFolder((String)folder.getUuid(), (long)userId, (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
                } else {
                    existingFolder = IGFolderLocalServiceUtil.updateFolder((long)existingFolder.getFolderId(), (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (boolean)false, (ServiceContext)serviceContext);
                }
            } else {
                name = IGPortletDataHandlerImpl.getFolderName(context.getCompanyId(), context.getGroupId(), parentFolderId, folder.getName(), 2);
                existingFolder = IGFolderLocalServiceUtil.addFolder((long)userId, (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
            }
            folderPKs.put(folder.getFolderId(), existingFolder.getFolderId());
        }
        catch (NoSuchFolderException nsfe) {
            _log.error((Object)("Could not find the parent folder for folder " + folder.getFolderId()));
        }
    }

    public static void importImage(PortletDataContext context, Map<Long, Long> folderPKs, IGImage image, String binPath) throws Exception {
        long userId = context.getUserId(image.getUserUuid());
        long folderId = MapUtil.getLong(folderPKs, (long)image.getFolderId(), (long)image.getFolderId());
        File imageFile = null;
        byte[] bytes = context.getZipEntryAsByteArray(binPath);
        if (bytes == null) {
            _log.error((Object)("Could not find image file for image " + image.getImageId()));
            return;
        }
        imageFile = File.createTempFile(String.valueOf(image.getPrimaryKey()), "." + image.getImageType());
        FileUtil.write((File)imageFile, (byte[])bytes);
        String[] tagsEntries = null;
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            tagsEntries = context.getTagsEntries(IGImage.class, image.getImageId());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setTagsEntries(tagsEntries);
        if (folderId != 0L && folderId == image.getFolderId()) {
            String path = IGPortletDataHandlerImpl.getImportFolderPath(context, folderId);
            IGFolder folder = (IGFolder)context.getZipEntryAsObject(path);
            IGPortletDataHandlerImpl.importFolder(context, folderPKs, folder);
            folderId = MapUtil.getLong(folderPKs, (long)image.getFolderId(), (long)image.getFolderId());
        }
        IGImage existingImage = null;
        try {
            IGFolderUtil.findByPrimaryKey((long)folderId);
            if (context.getDataStrategy().equals("DATA_STRATEGY_MIRROR")) {
                try {
                    existingImage = IGImageUtil.findByUUID_G((String)image.getUuid(), (long)context.getGroupId());
                    IGImageLocalServiceUtil.updateImage((long)userId, (long)existingImage.getImageId(), (long)folderId, (String)image.getName(), (String)image.getDescription(), (File)imageFile, (String)image.getImageType(), (ServiceContext)serviceContext);
                }
                catch (NoSuchImageException nsie) {
                    IGImageLocalServiceUtil.addImage((String)image.getUuid(), (long)userId, (long)folderId, (String)image.getName(), (String)image.getDescription(), (File)imageFile, (String)image.getImageType(), (ServiceContext)serviceContext);
                }
            } else {
                IGImageLocalServiceUtil.addImage((long)userId, (long)folderId, (String)image.getName(), (String)image.getDescription(), (File)imageFile, (String)image.getImageType(), (ServiceContext)serviceContext);
            }
        }
        catch (NoSuchFolderException nsfe) {
            _log.error((Object)("Could not find the parent folder for image " + image.getImageId()));
        }
    }

    public PortletPreferences deleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            if (!context.addPrimaryKey(IGPortletDataHandlerImpl.class, "deleteData")) {
                IGFolderLocalServiceUtil.deleteFolders((long)context.getGroupId());
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public String exportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("image-gallery");
            root.addAttribute("group-id", String.valueOf(context.getGroupId()));
            Element foldersEl = root.addElement("folders");
            Element imagesEl = root.addElement("images");
            List folders = IGFolderUtil.findByGroupId((long)context.getGroupId());
            for (IGFolder folder : folders) {
                IGPortletDataHandlerImpl.exportFolder(context, foldersEl, imagesEl, folder);
            }
            return doc.formattedString();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_foldersAndImages, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_foldersAndImages, _tags};
    }

    public PortletPreferences importData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.read((String)data);
            Element root = doc.getRootElement();
            List folderEls = root.element("folders").elements("folder");
            Map folderPKs = context.getNewPrimaryKeysMap(IGFolder.class);
            for (Element folderEl : folderEls) {
                String path = folderEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                IGFolder folder = (IGFolder)context.getZipEntryAsObject(path);
                IGPortletDataHandlerImpl.importFolder(context, folderPKs, folder);
            }
            List imageEls = root.element("images").elements("image");
            for (Element imageEl : imageEls) {
                String path = imageEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                IGImage image = (IGImage)context.getZipEntryAsObject(path);
                String binPath = imageEl.attributeValue("bin-path");
                IGPortletDataHandlerImpl.importImage(context, folderPKs, image, binPath);
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    protected static void exportFolder(PortletDataContext context, Element foldersEl, Element imagesEl, IGFolder folder) throws PortalException, SystemException {
        if (context.isWithinDateRange(folder.getModifiedDate())) {
            IGPortletDataHandlerImpl.exportParentFolder(context, foldersEl, folder.getParentFolderId());
            String path = IGPortletDataHandlerImpl.getFolderPath(context, folder.getFolderId());
            if (context.isPathNotProcessed(path)) {
                Element folderEl = foldersEl.addElement("folder");
                folderEl.addAttribute("path", path);
                folder.setUserUuid(folder.getUserUuid());
                context.addZipEntry(path, (Object)folder);
            }
        }
        List images = IGImageUtil.findByFolderId((long)folder.getFolderId());
        for (IGImage image : images) {
            IGPortletDataHandlerImpl.exportImage(context, foldersEl, imagesEl, image);
        }
    }

    protected static void exportParentFolder(PortletDataContext context, Element foldersEl, long folderId) throws PortalException, SystemException {
        if (folderId == 0L) {
            return;
        }
        IGFolder folder = IGFolderUtil.findByPrimaryKey((long)folderId);
        IGPortletDataHandlerImpl.exportParentFolder(context, foldersEl, folder.getParentFolderId());
        String path = IGPortletDataHandlerImpl.getFolderPath(context, folder.getFolderId());
        if (context.isPathNotProcessed(path)) {
            Element folderEl = foldersEl.addElement("folder");
            folderEl.addAttribute("path", path);
            folder.setUserUuid(folder.getUserUuid());
            context.addZipEntry(path, (Object)folder);
        }
    }

    protected static String getFolderName(long companyId, long groupId, long parentFolderId, String name, int count) throws SystemException {
        IGFolder folder = IGFolderUtil.fetchByG_P_N((long)groupId, (long)parentFolderId, (String)name);
        if (folder == null) {
            return name;
        }
        if (Pattern.matches(".* \\(\\d+\\)", name)) {
            int pos = name.lastIndexOf(" (");
            name = name.substring(0, pos);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(" ");
        sb.append("(");
        sb.append(count);
        sb.append(")");
        name = sb.toString();
        return IGPortletDataHandlerImpl.getFolderName(companyId, groupId, parentFolderId, name, ++count);
    }

    protected static String getFolderPath(PortletDataContext context, long folderId) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("31"));
        sb.append("/folders/");
        sb.append(folderId);
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getImageBinPath(PortletDataContext context, IGImage image) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("31"));
        sb.append("/bin/");
        sb.append(image.getImageId());
        sb.append(".");
        sb.append(image.getImageType());
        return sb.toString();
    }

    protected static String getImagePath(PortletDataContext context, IGImage image) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("31"));
        sb.append("/images/");
        sb.append(image.getImageId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getImportFolderPath(PortletDataContext context, long folderId) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getSourcePortletPath("31"));
        sb.append("/folders/");
        sb.append(folderId);
        sb.append(".xml");
        return sb.toString();
    }
}

