/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.service.http;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portlet.imagegallery.model.IGImage;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGImageJSONSerializer {
    public static JSONObject toJSONObject(IGImage model) {
        JSONObject jsonObj = JSONFactoryUtil.createJSONObject();
        jsonObj.put("uuid", model.getUuid());
        jsonObj.put("imageId", model.getImageId());
        jsonObj.put("groupId", model.getGroupId());
        jsonObj.put("companyId", model.getCompanyId());
        jsonObj.put("userId", model.getUserId());
        Date createDate = model.getCreateDate();
        String createDateJSON = "";
        if (createDate != null) {
            createDateJSON = String.valueOf(createDate.getTime());
        }
        jsonObj.put("createDate", createDateJSON);
        Date modifiedDate = model.getModifiedDate();
        String modifiedDateJSON = "";
        if (modifiedDate != null) {
            modifiedDateJSON = String.valueOf(modifiedDate.getTime());
        }
        jsonObj.put("modifiedDate", modifiedDateJSON);
        jsonObj.put("folderId", model.getFolderId());
        jsonObj.put("name", model.getName());
        jsonObj.put("description", model.getDescription());
        jsonObj.put("smallImageId", model.getSmallImageId());
        jsonObj.put("largeImageId", model.getLargeImageId());
        jsonObj.put("custom1ImageId", model.getCustom1ImageId());
        jsonObj.put("custom2ImageId", model.getCustom2ImageId());
        return jsonObj;
    }

    public static JSONArray toJSONArray(IGImage[] models) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (IGImage model : models) {
            jsonArray.put(IGImageJSONSerializer.toJSONObject(model));
        }
        return jsonArray;
    }

    public static JSONArray toJSONArray(IGImage[][] models) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (IGImage[] model : models) {
            jsonArray.put(IGImageJSONSerializer.toJSONArray(model));
        }
        return jsonArray;
    }

    public static JSONArray toJSONArray(List<IGImage> models) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (IGImage model : models) {
            jsonArray.put(IGImageJSONSerializer.toJSONObject(model));
        }
        return jsonArray;
    }
}

