/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermQueryFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.imagegallery.DuplicateFolderNameException;
import com.liferay.portlet.imagegallery.FolderNameException;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.base.IGFolderLocalServiceBaseImpl;
import com.liferay.portlet.tags.util.TagsUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGFolderLocalServiceImpl
extends IGFolderLocalServiceBaseImpl {
    public IGFolder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addFolder(null, userId, parentFolderId, name, description, serviceContext);
    }

    public IGFolder addFolder(String uuid, long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        parentFolderId = this.getParentFolderId(groupId, parentFolderId);
        Date now = new Date();
        this.validate(groupId, parentFolderId, name);
        long folderId = this.counterLocalService.increment();
        IGFolder folder = this.igFolderPersistence.create(folderId);
        folder.setUuid(uuid);
        folder.setGroupId(groupId);
        folder.setCompanyId(user.getCompanyId());
        folder.setUserId(user.getUserId());
        folder.setCreateDate(now);
        folder.setModifiedDate(now);
        folder.setParentFolderId(parentFolderId);
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.igFolderPersistence.update((BaseModel)folder, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addFolderResources(folder, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addFolderResources(folder, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        return folder;
    }

    public void addFolderResources(IGFolder folder, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(folder.getCompanyId(), folder.getGroupId(), folder.getUserId(), IGFolder.class.getName(), folder.getFolderId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addFolderResources(IGFolder folder, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(folder.getCompanyId(), folder.getGroupId(), folder.getUserId(), IGFolder.class.getName(), folder.getFolderId(), communityPermissions, guestPermissions);
    }

    public void addFolderResources(long folderId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        IGFolder folder = this.igFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(folder, addCommunityPermissions, addGuestPermissions);
    }

    public void addFolderResources(long folderId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        IGFolder folder = this.igFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(folder, communityPermissions, guestPermissions);
    }

    public void deleteFolder(IGFolder folder) throws PortalException, SystemException {
        this.igFolderPersistence.remove((BaseModel)folder);
        this.resourceLocalService.deleteResource(folder.getCompanyId(), IGFolder.class.getName(), 4, folder.getFolderId());
        List folders = this.igFolderPersistence.findByG_P(folder.getGroupId(), folder.getFolderId());
        for (IGFolder curFolder : folders) {
            this.deleteFolder(curFolder);
        }
        this.igImageLocalService.deleteImages(folder.getFolderId());
        this.expandoValueLocalService.deleteValues(IGFolder.class.getName(), folder.getFolderId());
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        IGFolder folder = this.igFolderPersistence.findByPrimaryKey(folderId);
        this.deleteFolder(folder);
    }

    public void deleteFolders(long groupId) throws PortalException, SystemException {
        List folders = this.igFolderPersistence.findByG_P(groupId, 0L);
        for (IGFolder folder : folders) {
            this.deleteFolder(folder);
        }
    }

    public IGFolder getFolder(long folderId) throws PortalException, SystemException {
        return this.igFolderPersistence.findByPrimaryKey(folderId);
    }

    public IGFolder getFolder(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        return this.igFolderPersistence.findByG_P_N(groupId, parentFolderId, name);
    }

    public List<IGFolder> getFolders(long groupId) throws SystemException {
        return this.igFolderPersistence.findByGroupId(groupId);
    }

    public List<IGFolder> getFolders(long groupId, long parentFolderId) throws SystemException {
        return this.igFolderPersistence.findByG_P(groupId, parentFolderId);
    }

    public List<IGFolder> getFolders(long groupId, long parentFolderId, int start, int end) throws SystemException {
        return this.igFolderPersistence.findByG_P(groupId, parentFolderId, start, end);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.igFolderPersistence.countByG_P(groupId, parentFolderId);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) throws SystemException {
        List folders = this.igFolderPersistence.findByG_P(groupId, folderId);
        for (IGFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId());
        }
    }

    public void reIndex(String[] ids) throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        long companyId = GetterUtil.getLong((String)ids[0]);
        try {
            this.reIndexFolders(companyId);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Hits search(long companyId, long groupId, long userId, long[] folderIds, String keywords, int start, int end) throws SystemException {
        try {
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create();
            contextQuery.addRequiredTerm("portletId", "31");
            if (groupId > 0L) {
                Group group = this.groupLocalService.getGroup(groupId);
                if (group.isLayout()) {
                    contextQuery.addRequiredTerm("scopeGroupId", groupId);
                    groupId = group.getParentGroupId();
                }
                contextQuery.addRequiredTerm("groupId", groupId);
            }
            if (folderIds != null && folderIds.length > 0) {
                BooleanQuery folderIdsQuery = BooleanQueryFactoryUtil.create();
                for (long folderId : folderIds) {
                    if (userId > 0L) {
                        try {
                            this.igFolderService.getFolder(folderId);
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    TermQuery termQuery = TermQueryFactoryUtil.create((String)"folderId", (long)folderId);
                    folderIdsQuery.add((Query)termQuery, BooleanClauseOccur.SHOULD);
                }
                contextQuery.add((Query)folderIdsQuery, BooleanClauseOccur.MUST);
            }
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            if (Validator.isNotNull((String)keywords)) {
                searchQuery.addTerm("title", keywords);
                searchQuery.addTerm("description", keywords);
                searchQuery.addTerm("tagsEntries", keywords, true);
            }
            BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
            fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
            if (searchQuery.clauses().size() > 0) {
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            return SearchEngineUtil.search((long)companyId, (long)groupId, (long)userId, (String)IGImage.class.getName(), (Query)fullQuery, (int)start, (int)end);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public IGFolder updateFolder(long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException, SystemException {
        IGFolder folder = this.igFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(folder, parentFolderId);
        this.validate(folder.getFolderId(), folder.getGroupId(), parentFolderId, name);
        folder.setModifiedDate(new Date());
        folder.setParentFolderId(parentFolderId);
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.igFolderPersistence.update((BaseModel)folder, false);
        if (mergeWithParentFolder && folderId != parentFolderId && parentFolderId != 0L) {
            this.mergeFolders(folder, parentFolderId);
        }
        return folder;
    }

    protected long getParentFolderId(IGFolder folder, long parentFolderId) throws SystemException {
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        if (folder.getFolderId() == parentFolderId) {
            return folder.getParentFolderId();
        }
        IGFolder parentFolder = this.igFolderPersistence.fetchByPrimaryKey(parentFolderId);
        if (parentFolder == null || folder.getGroupId() != parentFolder.getGroupId()) {
            return folder.getParentFolderId();
        }
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        this.getSubfolderIds(subfolderIds, folder.getGroupId(), folder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            return folder.getParentFolderId();
        }
        return parentFolderId;
    }

    protected long getParentFolderId(long groupId, long parentFolderId) throws SystemException {
        IGFolder parentFolder;
        if (parentFolderId != 0L && ((parentFolder = this.igFolderPersistence.fetchByPrimaryKey(parentFolderId)) == null || groupId != parentFolder.getGroupId())) {
            parentFolderId = 0L;
        }
        return parentFolderId;
    }

    protected void mergeFolders(IGFolder fromFolder, long toFolderId) throws PortalException, SystemException {
        List folders = this.igFolderPersistence.findByG_P(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (IGFolder folder : folders) {
            this.mergeFolders(folder, toFolderId);
        }
        List images = this.igImagePersistence.findByFolderId(fromFolder.getFolderId());
        for (IGImage image : images) {
            image.setFolderId(toFolderId);
            this.igImagePersistence.update((BaseModel)image, false);
            this.igImageLocalService.reIndex(image);
        }
        this.deleteFolder(fromFolder);
    }

    protected void reIndexFolders(long companyId) throws SystemException {
        int folderCount = this.igFolderPersistence.countByCompanyId(companyId);
        int folderPages = folderCount / 1000;
        for (int i = 0; i <= folderPages; ++i) {
            int folderStart = i * 1000;
            int folderEnd = folderStart + 1000;
            this.reIndexFolders(companyId, folderStart, folderEnd);
        }
    }

    protected void reIndexFolders(long companyId, int folderStart, int folderEnd) throws SystemException {
        List folders = this.igFolderPersistence.findByCompanyId(companyId, folderStart, folderEnd);
        for (IGFolder folder : folders) {
            long folderId = folder.getFolderId();
            int entryCount = this.igImagePersistence.countByFolderId(folderId);
            int entryPages = entryCount / 1000;
            for (int i = 0; i <= entryPages; ++i) {
                int entryStart = i * 1000;
                int entryEnd = entryStart + 1000;
                this.reIndexImages(folderId, entryStart, entryEnd);
            }
        }
    }

    protected void reIndexImages(long folderId, int entryStart, int entryEnd) throws SystemException {
        List images = this.igImagePersistence.findByFolderId(folderId, entryStart, entryEnd);
        for (IGImage image : images) {
            this.igImageLocalService.reIndex(image);
        }
    }

    protected void validate(long folderId, long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        if (!TagsUtil.isValidWord(name)) {
            throw new FolderNameException();
        }
        IGFolder folder = this.igFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
        if (folder != null && folder.getFolderId() != folderId) {
            throw new DuplicateFolderNameException();
        }
        if (name.indexOf(".") != -1) {
            String nameWithExtension = name;
            name = FileUtil.stripExtension((String)nameWithExtension);
            List images = this.igImagePersistence.findByF_N(parentFolderId, name);
            for (IGImage image : images) {
                if (!nameWithExtension.equals(image.getNameWithExtension())) continue;
                throw new DuplicateFolderNameException();
            }
        }
    }

    protected void validate(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        long folderId = 0L;
        this.validate(folderId, groupId, parentFolderId, name);
    }
}

