/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.image.ImageProcessorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.imagegallery.DuplicateImageNameException;
import com.liferay.portlet.imagegallery.ImageNameException;
import com.liferay.portlet.imagegallery.ImageSizeException;
import com.liferay.portlet.imagegallery.NoSuchImageException;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.model.impl.IGImageImpl;
import com.liferay.portlet.imagegallery.service.base.IGImageLocalServiceBaseImpl;
import com.liferay.portlet.imagegallery.util.Indexer;
import com.liferay.portlet.imagegallery.util.comparator.ImageModifiedDateComparator;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGImageLocalServiceImpl
extends IGImageLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(IGImageLocalServiceImpl.class);

    public IGImage addImage(long userId, long folderId, String name, String description, File file, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addImage(null, userId, folderId, name, description, file, contentType, serviceContext);
    }

    public IGImage addImage(long userId, long folderId, String name, String description, String fileName, byte[] bytes, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addImage(null, userId, folderId, name, description, fileName, bytes, contentType, serviceContext);
    }

    public IGImage addImage(long userId, long folderId, String name, String description, String fileName, InputStream is, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addImage(null, userId, folderId, name, description, fileName, is, contentType, serviceContext);
    }

    public IGImage addImage(String uuid, long userId, long folderId, String name, String description, File file, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            String fileName = file.getName();
            byte[] bytes = FileUtil.getBytes((File)file);
            return this.addImage(uuid, userId, folderId, name, description, fileName, bytes, contentType, serviceContext);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public IGImage addImage(String uuid, long userId, long folderId, String name, String description, String fileName, byte[] bytes, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            String extension = FileUtil.getExtension((String)fileName);
            if (Validator.isNotNull((String)name) && StringUtil.endsWith((String)name, (String)extension)) {
                name = FileUtil.stripExtension((String)name);
            }
            String nameWithExtension = name + "." + extension;
            this.validate(folderId, nameWithExtension, fileName, bytes);
            User user = this.userPersistence.findByPrimaryKey(userId);
            IGFolder folder = this.igFolderPersistence.findByPrimaryKey(folderId);
            RenderedImage renderedImage = ImageProcessorUtil.read((byte[])bytes).getRenderedImage();
            Date now = new Date();
            long imageId = this.counterLocalService.increment();
            if (Validator.isNull((String)name)) {
                name = String.valueOf(imageId);
            }
            IGImage image = this.igImagePersistence.create(imageId);
            image.setUuid(uuid);
            image.setGroupId(folder.getGroupId());
            image.setCompanyId(user.getCompanyId());
            image.setUserId(user.getUserId());
            image.setCreateDate(now);
            image.setModifiedDate(now);
            image.setFolderId(folderId);
            image.setName(name);
            image.setDescription(description);
            image.setSmallImageId(this.counterLocalService.increment());
            image.setLargeImageId(this.counterLocalService.increment());
            if (PropsValues.IG_IMAGE_CUSTOM_1_MAX_DIMENSION > 0) {
                image.setCustom1ImageId(this.counterLocalService.increment());
            }
            if (PropsValues.IG_IMAGE_CUSTOM_2_MAX_DIMENSION > 0) {
                image.setCustom2ImageId(this.counterLocalService.increment());
            }
            image.setExpandoBridgeAttributes(serviceContext);
            this.igImagePersistence.update((BaseModel)image, false);
            if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
                this.addImageResources(image, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
            } else {
                this.addImageResources(image, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
            }
            this.saveImages(image.getLargeImageId(), renderedImage, image.getSmallImageId(), image.getCustom1ImageId(), image.getCustom2ImageId(), bytes, contentType);
            this.socialActivityLocalService.addActivity(userId, image.getGroupId(), IGImage.class.getName(), imageId, 1, "", 0L);
            this.updateTagsAsset(userId, image, serviceContext.getTagsCategories(), serviceContext.getTagsEntries(), contentType);
            this.reIndex(image);
            return image;
        }
        catch (IOException ioe) {
            throw new ImageSizeException((Throwable)ioe);
        }
    }

    public IGImage addImage(String uuid, long userId, long folderId, String name, String description, String fileName, InputStream is, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            byte[] bytes = FileUtil.getBytes((InputStream)is);
            return this.addImage(uuid, userId, folderId, name, description, fileName, bytes, contentType, serviceContext);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void addImageResources(IGImage image, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(image.getCompanyId(), image.getGroupId(), image.getUserId(), IGImage.class.getName(), image.getImageId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addImageResources(IGImage image, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(image.getCompanyId(), image.getGroupId(), image.getUserId(), IGImage.class.getName(), image.getImageId(), communityPermissions, guestPermissions);
    }

    public void addImageResources(long imageId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        IGImage image = this.igImagePersistence.findByPrimaryKey(imageId);
        this.addImageResources(image, addCommunityPermissions, addGuestPermissions);
    }

    public void addImageResources(long imageId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        IGImage image = this.igImagePersistence.findByPrimaryKey(imageId);
        this.addImageResources(image, communityPermissions, guestPermissions);
    }

    public void deleteImage(IGImage image) throws PortalException, SystemException {
        this.igImagePersistence.remove((BaseModel)image);
        this.resourceLocalService.deleteResource(image.getCompanyId(), IGImage.class.getName(), 4, image.getImageId());
        this.imageLocalService.deleteImage(image.getSmallImageId());
        this.imageLocalService.deleteImage(image.getLargeImageId());
        this.expandoValueLocalService.deleteValues(IGImage.class.getName(), image.getImageId());
        this.socialActivityLocalService.deleteActivities(IGImage.class.getName(), image.getImageId());
        this.tagsAssetLocalService.deleteAsset(IGImage.class.getName(), image.getImageId());
        try {
            Indexer.deleteImage(image.getCompanyId(), image.getImageId());
        }
        catch (SearchException se) {
            _log.error((Object)("Deleting index " + image.getImageId()), (Throwable)se);
        }
    }

    public void deleteImage(long imageId) throws PortalException, SystemException {
        IGImage image = this.igImagePersistence.findByPrimaryKey(imageId);
        this.deleteImage(image);
    }

    public void deleteImages(long folderId) throws PortalException, SystemException {
        List images = this.igImagePersistence.findByFolderId(folderId);
        for (IGImage image : images) {
            this.deleteImage(image);
        }
    }

    public int getFoldersImagesCount(List<Long> folderIds) throws SystemException {
        return this.igImageFinder.countByFolderIds(folderIds);
    }

    public List<IGImage> getGroupImages(long groupId, int start, int end) throws SystemException {
        return this.igImagePersistence.findByGroupId(groupId, start, end, (OrderByComparator)new ImageModifiedDateComparator());
    }

    public List<IGImage> getGroupImages(long groupId, long userId, int start, int end) throws SystemException {
        ImageModifiedDateComparator orderByComparator = new ImageModifiedDateComparator();
        if (userId <= 0L) {
            return this.igImagePersistence.findByGroupId(groupId, start, end, (OrderByComparator)orderByComparator);
        }
        return this.igImagePersistence.findByG_U(groupId, userId, start, end, (OrderByComparator)orderByComparator);
    }

    public int getGroupImagesCount(long groupId) throws SystemException {
        return this.igImagePersistence.countByGroupId(groupId);
    }

    public int getGroupImagesCount(long groupId, long userId) throws SystemException {
        if (userId <= 0L) {
            return this.igImagePersistence.countByGroupId(groupId);
        }
        return this.igImagePersistence.countByG_U(groupId, userId);
    }

    public IGImage getImage(long imageId) throws PortalException, SystemException {
        return this.igImagePersistence.findByPrimaryKey(imageId);
    }

    public IGImage getImageByCustom1ImageId(long custom1ImageId) throws PortalException, SystemException {
        return this.igImagePersistence.findByCustom1ImageId(custom1ImageId);
    }

    public IGImage getImageByCustom2ImageId(long custom2ImageId) throws PortalException, SystemException {
        return this.igImagePersistence.findByCustom2ImageId(custom2ImageId);
    }

    public IGImage getImageByFolderIdAndNameWithExtension(long folderId, String nameWithExtension) throws PortalException, SystemException {
        long imageId;
        IGImage image;
        String name = FileUtil.stripExtension((String)nameWithExtension);
        List images = this.igImagePersistence.findByF_N(folderId, name);
        if (images.size() <= 0 && Validator.isNumber((String)name) && (image = this.igImagePersistence.fetchByPrimaryKey(imageId = GetterUtil.getLong((String)name))) != null) {
            images.add(image);
        }
        for (IGImage image2 : images) {
            if (!nameWithExtension.equals(image2.getNameWithExtension())) continue;
            return image2;
        }
        throw new NoSuchImageException();
    }

    public IGImage getImageByLargeImageId(long largeImageId) throws PortalException, SystemException {
        return this.igImagePersistence.findByLargeImageId(largeImageId);
    }

    public IGImage getImageBySmallImageId(long smallImageId) throws PortalException, SystemException {
        return this.igImagePersistence.findBySmallImageId(smallImageId);
    }

    public IGImage getImageByUuidAndGroupId(String uuid, long groupId) throws PortalException, SystemException {
        return this.igImagePersistence.findByUUID_G(uuid, groupId);
    }

    public List<IGImage> getImages(long folderId) throws SystemException {
        return this.igImagePersistence.findByFolderId(folderId);
    }

    public List<IGImage> getImages(long folderId, int start, int end) throws SystemException {
        return this.igImagePersistence.findByFolderId(folderId, start, end);
    }

    public List<IGImage> getImages(long folderId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.igImagePersistence.findByFolderId(folderId, start, end, obc);
    }

    public int getImagesCount(long folderId) throws SystemException {
        return this.igImagePersistence.countByFolderId(folderId);
    }

    public List<IGImage> getNoAssetImages() throws SystemException {
        return this.igImageFinder.findByNoAssets();
    }

    public void reIndex(IGImage image) throws SystemException {
        long companyId = image.getCompanyId();
        long groupId = image.getGroupId();
        long folderId = image.getFolderId();
        long imageId = image.getImageId();
        String name = image.getName();
        String description = image.getDescription();
        Date modifiedDate = image.getModifiedDate();
        String[] tagsCategories = this.tagsEntryLocalService.getEntryNames(IGImage.class.getName(), imageId, false);
        String[] tagsEntries = this.tagsEntryLocalService.getEntryNames(IGImage.class.getName(), imageId);
        ExpandoBridge expandoBridge = image.getExpandoBridge();
        try {
            Indexer.updateImage(companyId, groupId, folderId, imageId, name, description, modifiedDate, tagsCategories, tagsEntries, expandoBridge);
        }
        catch (SearchException se) {
            _log.error((Object)("Reindexing " + imageId), (Throwable)se);
        }
    }

    public void reIndex(long imageId) throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        IGImage image = this.igImagePersistence.fetchByPrimaryKey(imageId);
        if (image == null) {
            return;
        }
        this.reIndex(image);
    }

    public IGImage updateImage(long userId, long imageId, long folderId, String name, String description, byte[] bytes, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            IGImage image = this.igImagePersistence.findByPrimaryKey(imageId);
            IGFolder folder = this.getFolder(image, folderId);
            RenderedImage renderedImage = null;
            if (bytes != null) {
                renderedImage = ImageProcessorUtil.read((byte[])bytes).getRenderedImage();
                this.validate(bytes);
            }
            if (Validator.isNotNull((String)name) && !name.equals(image.getName())) {
                String nameWithExtension = IGImageImpl.getNameWithExtension(name, image.getImageType());
                this.validate(folderId, nameWithExtension);
            } else {
                name = image.getName();
            }
            image.setModifiedDate(new Date());
            image.setFolderId(folder.getFolderId());
            image.setName(name);
            image.setDescription(description);
            image.setExpandoBridgeAttributes(serviceContext);
            this.igImagePersistence.update((BaseModel)image, false);
            if (renderedImage != null) {
                this.saveImages(image.getLargeImageId(), renderedImage, image.getSmallImageId(), image.getCustom1ImageId(), image.getCustom2ImageId(), bytes, contentType);
            }
            this.socialActivityLocalService.addActivity(userId, image.getGroupId(), IGImage.class.getName(), imageId, 2, "", 0L);
            String[] tagsCategories = serviceContext.getTagsCategories();
            String[] tagsEntries = serviceContext.getTagsEntries();
            this.updateTagsAsset(userId, image, tagsCategories, tagsEntries, contentType);
            this.reIndex(image);
            return image;
        }
        catch (IOException ioe) {
            throw new ImageSizeException((Throwable)ioe);
        }
    }

    public IGImage updateImage(long userId, long imageId, long folderId, String name, String description, File file, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            byte[] bytes = null;
            if (file != null && file.exists()) {
                bytes = FileUtil.getBytes((File)file);
            }
            return this.updateImage(userId, imageId, folderId, name, description, bytes, contentType, serviceContext);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public IGImage updateImage(long userId, long imageId, long folderId, String name, String description, InputStream is, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            byte[] bytes = null;
            if (is != null) {
                bytes = FileUtil.getBytes((InputStream)is);
            }
            return this.updateImage(userId, imageId, folderId, name, description, bytes, contentType, serviceContext);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void updateSmallImage(long smallImageId, long largeImageId) throws PortalException, SystemException {
        try {
            RenderedImage renderedImage = null;
            Image largeImage = this.imageLocalService.getImage(largeImageId);
            byte[] bytes = largeImage.getTextObj();
            String contentType = largeImage.getType();
            if (bytes != null) {
                renderedImage = ImageProcessorUtil.read((byte[])bytes).getRenderedImage();
            }
            if (renderedImage != null) {
                this.saveScaledImage(renderedImage, smallImageId, contentType, PrefsPropsUtil.getInteger("ig.image.thumbnail.max.dimension"));
            }
        }
        catch (IOException ioe) {
            throw new ImageSizeException((Throwable)ioe);
        }
    }

    public void updateTagsAsset(long userId, IGImage image, String[] tagsCategories, String[] tagsEntries) throws PortalException, SystemException {
        this.updateTagsAsset(userId, image, tagsCategories, tagsEntries, null);
    }

    public void updateTagsAsset(long userId, IGImage image, String[] tagsCategories, String[] tagsEntries, String contentType) throws PortalException, SystemException {
        Image largeImage = this.imageLocalService.getImage(image.getLargeImageId());
        if (largeImage == null) {
            return;
        }
        if (contentType == null) {
            contentType = MimeTypesUtil.getContentType((String)largeImage.getType());
        }
        this.tagsAssetLocalService.updateAsset(userId, image.getGroupId(), IGImage.class.getName(), image.getImageId(), tagsCategories, tagsEntries, true, null, null, null, null, contentType, image.getName(), image.getDescription(), null, null, largeImage.getHeight(), largeImage.getWidth(), null, false);
    }

    protected IGFolder getFolder(IGImage image, long folderId) throws PortalException, SystemException {
        if (image.getFolderId() != folderId) {
            IGFolder oldFolder = this.igFolderPersistence.findByPrimaryKey(image.getFolderId());
            IGFolder newFolder = this.igFolderPersistence.fetchByPrimaryKey(folderId);
            if (newFolder == null || oldFolder.getGroupId() != newFolder.getGroupId()) {
                folderId = image.getFolderId();
            }
        }
        return this.igFolderPersistence.findByPrimaryKey(folderId);
    }

    protected void saveImages(long largeImageId, RenderedImage renderedImage, long smallImageId, long custom1ImageId, long custom2ImageId, byte[] bytes, String contentType) throws PortalException, SystemException {
        try {
            this.imageLocalService.updateImage(largeImageId, bytes);
            this.saveScaledImage(renderedImage, smallImageId, contentType, PrefsPropsUtil.getInteger("ig.image.thumbnail.max.dimension"));
            if (custom1ImageId > 0L) {
                this.saveScaledImage(renderedImage, custom1ImageId, contentType, PropsValues.IG_IMAGE_CUSTOM_1_MAX_DIMENSION);
            }
            if (custom2ImageId > 0L) {
                this.saveScaledImage(renderedImage, custom2ImageId, contentType, PropsValues.IG_IMAGE_CUSTOM_2_MAX_DIMENSION);
            }
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected void saveScaledImage(RenderedImage renderedImage, long imageId, String contentType, int dimension) throws IOException, PortalException, SystemException {
        RenderedImage thumbnail = ImageProcessorUtil.scale((RenderedImage)renderedImage, (int)dimension, (int)dimension);
        this.imageLocalService.updateImage(imageId, ImageProcessorUtil.getBytes((RenderedImage)thumbnail, (String)contentType));
    }

    protected void validate(byte[] bytes) throws ImageSizeException, SystemException {
        if (PrefsPropsUtil.getLong("ig.image.max.size") > 0L && (bytes == null || (long)bytes.length > PrefsPropsUtil.getLong("ig.image.max.size"))) {
            throw new ImageSizeException();
        }
    }

    protected void validate(long folderId, String nameWithExtension) throws PortalException, SystemException {
        if (nameWithExtension.indexOf("\\\\") != -1 || nameWithExtension.indexOf("//") != -1 || nameWithExtension.indexOf(":") != -1 || nameWithExtension.indexOf("*") != -1 || nameWithExtension.indexOf("?") != -1 || nameWithExtension.indexOf("\"") != -1 || nameWithExtension.indexOf("<") != -1 || nameWithExtension.indexOf(">") != -1 || nameWithExtension.indexOf("|") != -1 || nameWithExtension.indexOf("&") != -1 || nameWithExtension.indexOf("[") != -1 || nameWithExtension.indexOf("]") != -1 || nameWithExtension.indexOf("'") != -1) {
            throw new ImageNameException();
        }
        boolean validImageExtension = false;
        String[] imageExtensions = PrefsPropsUtil.getStringArray("ig.image.extensions", ",");
        for (int i = 0; i < imageExtensions.length; ++i) {
            if (!"*".equals(imageExtensions[i]) && !StringUtil.endsWith((String)nameWithExtension, (String)imageExtensions[i])) continue;
            validImageExtension = true;
            break;
        }
        if (!validImageExtension) {
            throw new ImageNameException();
        }
        String name = FileUtil.stripExtension((String)nameWithExtension);
        String imageType = FileUtil.getExtension((String)nameWithExtension);
        List images = this.igImagePersistence.findByF_N(folderId, name);
        if (imageType.equals("jpeg")) {
            imageType = "jpg";
        } else if (imageType.equals("tif")) {
            imageType = "tiff";
        }
        for (IGImage image : images) {
            if (!imageType.equals(image.getImageType())) continue;
            throw new DuplicateImageNameException();
        }
    }

    protected void validate(long folderId, String nameWithExtension, String fileName, byte[] bytes) throws PortalException, SystemException {
        if (Validator.isNotNull((String)fileName)) {
            String extension = FileUtil.getExtension((String)fileName);
            if (Validator.isNull((String)nameWithExtension)) {
                nameWithExtension = fileName;
            } else if (!StringUtil.endsWith((String)nameWithExtension, (String)extension)) {
                throw new ImageNameException();
            }
        }
        this.validate(folderId, nameWithExtension);
        this.validate(bytes);
    }
}

