/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.base.IGImageServiceBaseImpl;
import com.liferay.portlet.imagegallery.service.permission.IGFolderPermission;
import com.liferay.portlet.imagegallery.service.permission.IGImagePermission;
import java.io.File;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGImageServiceImpl
extends IGImageServiceBaseImpl {
    public IGImage addImage(long folderId, String name, String description, File file, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        IGFolderPermission.check(this.getPermissionChecker(), folderId, "ADD_IMAGE");
        return this.igImageLocalService.addImage(this.getUserId(), folderId, name, description, file, contentType, serviceContext);
    }

    public void deleteImage(long imageId) throws PortalException, SystemException {
        IGImagePermission.check(this.getPermissionChecker(), imageId, "DELETE");
        this.igImageLocalService.deleteImage(imageId);
    }

    public void deleteImageByFolderIdAndNameWithExtension(long folderId, String nameWithExtension) throws PortalException, SystemException {
        IGImage image = this.igImageLocalService.getImageByFolderIdAndNameWithExtension(folderId, nameWithExtension);
        this.deleteImage(image.getImageId());
    }

    public IGImage getImage(long imageId) throws PortalException, SystemException {
        IGImagePermission.check(this.getPermissionChecker(), imageId, "VIEW");
        return this.igImageLocalService.getImage(imageId);
    }

    public IGImage getImageByFolderIdAndNameWithExtension(long folderId, String nameWithExtension) throws PortalException, SystemException {
        IGImage image = this.igImageLocalService.getImageByFolderIdAndNameWithExtension(folderId, nameWithExtension);
        IGImagePermission.check(this.getPermissionChecker(), image, "VIEW");
        return image;
    }

    public IGImage getImageByLargeImageId(long largeImageId) throws PortalException, SystemException {
        IGImage image = this.igImageLocalService.getImageByLargeImageId(largeImageId);
        IGImagePermission.check(this.getPermissionChecker(), image.getImageId(), "VIEW");
        return image;
    }

    public IGImage getImageBySmallImageId(long smallImageId) throws PortalException, SystemException {
        IGImage image = this.igImageLocalService.getImageBySmallImageId(smallImageId);
        IGImagePermission.check(this.getPermissionChecker(), image.getImageId(), "VIEW");
        return image;
    }

    public List<IGImage> getImages(long folderId) throws PortalException, SystemException {
        List images = this.igImageLocalService.getImages(folderId);
        images = ListUtil.copy((List)images);
        Iterator itr = images.iterator();
        while (itr.hasNext()) {
            IGImage image = (IGImage)itr.next();
            if (IGImagePermission.contains(this.getPermissionChecker(), image, "VIEW")) continue;
            itr.remove();
        }
        return images;
    }

    public IGImage updateImage(long imageId, long folderId, String name, String description, File file, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        IGImagePermission.check(this.getPermissionChecker(), imageId, "UPDATE");
        return this.igImageLocalService.updateImage(this.getUserId(), imageId, folderId, name, description, file, contentType, serviceContext);
    }
}

