/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import com.liferay.portlet.imagegallery.service.permission.IGFolderPermission;

public class IGImagePermission {
    public static void check(PermissionChecker permissionChecker, long imageId, String actionId) throws PortalException, SystemException {
        if (!IGImagePermission.contains(permissionChecker, imageId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, IGImage image, String actionId) throws PortalException, SystemException {
        if (!IGImagePermission.contains(permissionChecker, image, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long imageId, String actionId) throws PortalException, SystemException {
        IGImage image = IGImageLocalServiceUtil.getImage((long)imageId);
        return IGImagePermission.contains(permissionChecker, image, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, IGImage image, String actionId) throws PortalException, SystemException {
        IGFolder folder = image.getFolder();
        if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE && !IGFolderPermission.contains(permissionChecker, folder, "VIEW")) {
            return false;
        }
        if (permissionChecker.hasOwnerPermission(image.getCompanyId(), IGImage.class.getName(), image.getImageId(), image.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(folder.getGroupId(), IGImage.class.getName(), image.getImageId(), actionId);
    }
}

