/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.service.persistence;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.model.impl.IGImageImpl;
import com.liferay.portlet.imagegallery.service.persistence.IGImageFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGImageFinderImpl
extends BasePersistenceImpl<IGImage>
implements IGImageFinder {
    public static String COUNT_BY_FOLDER_IDS = IGImageFinder.class.getName() + ".countByFolderIds";
    public static String FIND_BY_NO_ASSETS = IGImageFinder.class.getName() + ".findByNoAssets";

    public int countByFolderIds(List<Long> folderIds) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_FOLDER_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$FOLDER_ID$]", (String)this.getFolderIds(folderIds));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (int i = 0; i < folderIds.size(); ++i) {
                Long folderId = folderIds.get(i);
                qPos.add(folderId);
            }
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<IGImage> findByNoAssets() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ASSETS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("IGImage", IGImageImpl.class);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getFolderIds(List<Long> folderIds) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < folderIds.size(); ++i) {
            sb.append("folderId = ? ");
            if (i + 1 == folderIds.size()) continue;
            sb.append("OR ");
        }
        return sb.toString();
    }
}

