/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.social;

import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import com.liferay.portlet.imagegallery.service.permission.IGImagePermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityFeedEntry;

public class IGActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{IGImage.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected SocialActivityFeedEntry doInterpret(SocialActivity activity, ThemeDisplay themeDisplay) throws Exception {
        IGImage image;
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!IGImagePermission.contains(permissionChecker, image = IGImageLocalServiceUtil.getIGImage((long)activity.getClassPK()), "VIEW")) {
            return null;
        }
        String groupName = "";
        if (activity.getGroupId() != themeDisplay.getScopeGroupId()) {
            groupName = this.getGroupName(activity.getGroupId(), themeDisplay);
        }
        String creatorUserName = this.getUserName(activity.getUserId(), themeDisplay);
        int activityType = activity.getType();
        String link = themeDisplay.getPortalURL() + themeDisplay.getPathMain() + "/image_gallery/find_image?imageId=" + image.getImageId();
        String titlePattern = null;
        if (activityType == 1) {
            titlePattern = "activity-image-gallery-add-image";
        } else if (activityType == 2) {
            titlePattern = "activity-image-gallery-update-image";
        }
        if (Validator.isNotNull((String)groupName)) {
            titlePattern = titlePattern + "-in";
        }
        String imageName = this.wrapLink(link, HtmlUtil.escape((String)this.cleanContent(image.getName())));
        Object[] titleArguments = new Object[]{groupName, creatorUserName, imageName};
        String title = themeDisplay.translate(titlePattern, titleArguments);
        String folderLink = themeDisplay.getPortalURL() + themeDisplay.getPathMain() + "/image_gallery/find_folder?folderId=" + image.getFolderId();
        String body = this.wrapLink(folderLink, "go-to-folder", themeDisplay);
        return new SocialActivityFeedEntry(link, title, body);
    }
}

