/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGFolderLocalServiceUtil;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.jsp.PageContext;

public class IGUtil {
    public static String getBreadcrumbs(long folderId, long imageId, PageContext pageContext, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        if (imageId > 0L) {
            IGImage image = IGImageLocalServiceUtil.getImage((long)imageId);
            return IGUtil.getBreadcrumbs(image.getFolder(), image, pageContext, renderRequest, renderResponse);
        }
        IGFolder folder = null;
        try {
            folder = IGFolderLocalServiceUtil.getFolder((long)folderId);
        }
        catch (Exception e) {
            // empty catch block
        }
        return IGUtil.getBreadcrumbs(folder, null, pageContext, renderRequest, renderResponse);
    }

    public static String getBreadcrumbs(IGFolder folder, IGImage image, PageContext pageContext, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        if (image != null && folder == null) {
            folder = image.getFolder();
        }
        PortletURL foldersURL = renderResponse.createRenderURL();
        WindowState windowState = renderRequest.getWindowState();
        if (windowState.equals((Object)LiferayWindowState.POP_UP)) {
            foldersURL.setWindowState(LiferayWindowState.POP_UP);
            foldersURL.setParameter("struts_action", "/image_gallery/select_folder");
        } else {
            foldersURL.setParameter("struts_action", "/image_gallery/view");
        }
        String foldersLink = "<a href=\"" + foldersURL.toString() + "\">" + LanguageUtil.get((PageContext)pageContext, (String)"folders") + "</a>";
        if (folder == null) {
            return "<span class=\"first last\">" + foldersLink + "</span>";
        }
        String breadcrumbs = "";
        if (folder != null) {
            int i = 0;
            while (true) {
                folder = folder.toEscapedModel();
                PortletURL portletURL = renderResponse.createRenderURL();
                if (windowState.equals((Object)LiferayWindowState.POP_UP)) {
                    portletURL.setWindowState(LiferayWindowState.POP_UP);
                    portletURL.setParameter("struts_action", "/image_gallery/select_folder");
                    portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
                } else {
                    portletURL.setParameter("struts_action", "/image_gallery/view");
                    portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
                }
                String folderLink = "<a href=\"" + portletURL.toString() + "\">" + folder.getName() + "</a>";
                breadcrumbs = i == 0 ? (image != null ? breadcrumbs + folderLink : "<span class=\"last\">" + folderLink + "</span>") : folderLink + " &raquo; " + breadcrumbs;
                if (folder.isRoot()) break;
                folder = IGFolderLocalServiceUtil.getFolder((long)folder.getParentFolderId());
                ++i;
            }
        }
        breadcrumbs = "<span class=\"first\">" + foldersLink + " &raquo; </span>" + breadcrumbs;
        if (image != null) {
            image = image.toEscapedModel();
            PortletURL imageURL = renderResponse.createRenderURL();
            imageURL.setParameter("struts_action", "/image_gallery/edit_image");
            imageURL.setParameter("imageId", String.valueOf(image.getImageId()));
            String imageLink = "<span class=\"last\"><a href=\"" + imageURL.toString() + "\">" + image.getImageId() + "</a></span>";
            breadcrumbs = breadcrumbs + " &raquo; " + imageLink;
        }
        return breadcrumbs;
    }
}

