/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.util;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.DocumentSummary;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGFolderLocalServiceUtil;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import java.util.Date;
import javax.portlet.PortletURL;

public class Indexer
implements com.liferay.portal.kernel.search.Indexer {
    public static final String PORTLET_ID = "31";
    private static final String[] _CLASS_NAMES = new String[]{IGImage.class.getName()};

    public static void addImage(long companyId, long groupId, long folderId, long imageId, String name, String description, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, ExpandoBridge expandoBridge) throws SearchException {
        Document doc = Indexer.getImageDocument(companyId, groupId, folderId, imageId, name, description, modifiedDate, tagsCategories, tagsEntries, expandoBridge);
        SearchEngineUtil.addDocument((long)companyId, (Document)doc);
    }

    public static void deleteImage(long companyId, long imageId) throws SearchException {
        SearchEngineUtil.deleteDocument((long)companyId, (String)Indexer.getImageUID(imageId));
    }

    public static Document getImageDocument(long companyId, long groupId, long folderId, long imageId, String name, String description, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, ExpandoBridge expandoBridge) {
        long scopeGroupId = groupId;
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLayout()) {
                groupId = group.getParentGroupId();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, imageId);
        doc.addModifiedDate(modifiedDate);
        doc.addKeyword("companyId", companyId);
        doc.addKeyword("portletId", PORTLET_ID);
        doc.addKeyword("groupId", groupId);
        doc.addKeyword("scopeGroupId", scopeGroupId);
        doc.addText("title", name);
        doc.addText("description", description);
        doc.addKeyword("tagsCategories", tagsCategories);
        doc.addKeyword("tagsEntries", tagsEntries);
        doc.addKeyword("folderId", folderId);
        doc.addKeyword("entryClassName", IGImage.class.getName());
        doc.addKeyword("entryClassPK", imageId);
        ExpandoBridgeIndexerUtil.addAttributes((Document)doc, (ExpandoBridge)expandoBridge);
        return doc;
    }

    public static String getImageUID(long imageId) {
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, imageId);
        return doc.get("uid");
    }

    public static void updateImage(long companyId, long groupId, long folderId, long imageId, String name, String description, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, ExpandoBridge expandoBridge) throws SearchException {
        Document doc = Indexer.getImageDocument(companyId, groupId, folderId, imageId, name, description, modifiedDate, tagsCategories, tagsEntries, expandoBridge);
        SearchEngineUtil.updateDocument((long)companyId, (String)doc.get("uid"), (Document)doc);
    }

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    public DocumentSummary getDocumentSummary(Document doc, String snippet, PortletURL portletURL) {
        String title = doc.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)doc.get("description"), (int)200);
        }
        String imageId = doc.get("entryClassPK");
        portletURL.setParameter("struts_action", "/image_gallery/edit_image");
        portletURL.setParameter("imageId", imageId);
        return new DocumentSummary(title, content, portletURL);
    }

    public void reIndex(String className, long classPK) throws SearchException {
        try {
            IGImageLocalServiceUtil.reIndex((long)classPK);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void reIndex(String[] ids) throws SearchException {
        try {
            IGFolderLocalServiceUtil.reIndex((String[])ids);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }
}

