/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.webdav;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.webdav.BaseResourceImpl;
import com.liferay.portal.webdav.WebDAVException;
import com.liferay.portlet.imagegallery.model.IGImage;
import java.io.InputStream;

public class IGImageResourceImpl
extends BaseResourceImpl {
    private IGImage _image;

    public IGImageResourceImpl(IGImage image, String parentPath, String name) {
        super(parentPath, name, image.getNameWithExtension(), image.getCreateDate(), image.getModifiedDate(), image.getImageSize());
        this.setModel(image);
        this.setClassName(IGImage.class.getName());
        this.setPrimaryKey(image.getPrimaryKey());
        this._image = image;
    }

    public boolean isCollection() {
        return false;
    }

    public String getContentType() {
        String type = "";
        try {
            type = this._image.getImageType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MimeTypesUtil.getContentType((String)type);
    }

    public InputStream getContentAsStream() throws WebDAVException {
        try {
            Image image = ImageLocalServiceUtil.getImage((long)this._image.getLargeImageId());
            byte[] bytes = image.getTextObj();
            return new UnsyncByteArrayInputStream(bytes);
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }
}

