/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.webdav;

import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.webdav.BaseResourceImpl;
import com.liferay.portal.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.webdav.Resource;
import com.liferay.portal.webdav.Status;
import com.liferay.portal.webdav.WebDAVException;
import com.liferay.portal.webdav.WebDAVRequest;
import com.liferay.portal.webdav.WebDAVUtil;
import com.liferay.portlet.imagegallery.DuplicateFolderNameException;
import com.liferay.portlet.imagegallery.NoSuchFolderException;
import com.liferay.portlet.imagegallery.NoSuchImageException;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGFolderServiceUtil;
import com.liferay.portlet.imagegallery.service.IGImageServiceUtil;
import com.liferay.portlet.imagegallery.webdav.IGImageResourceImpl;
import com.liferay.portlet.tags.service.TagsEntryLocalServiceUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    private static Log _log = LogFactoryUtil.getLog(IGWebDAVStorageImpl.class);

    public int copyCollectionResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite, long depth) throws WebDAVException {
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            long parentFolderId = 0L;
            try {
                parentFolderId = this.getParentFolderId(destinationArray);
            }
            catch (NoSuchFolderException nsfe) {
                return 409;
            }
            IGFolder folder = (IGFolder)resource.getModel();
            long groupId = WebDAVUtil.getGroupId((String)destination);
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = folder.getDescription();
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, name)) {
                status = 204;
            }
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddCommunityPermissions(this.isAddCommunityPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            serviceContext.setScopeGroupId(groupId);
            if (depth == 0L) {
                IGFolderServiceUtil.addFolder((long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            } else {
                IGFolderServiceUtil.copyFolder((long)folder.getFolderId(), (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            }
            return status;
        }
        catch (DuplicateFolderNameException dfne) {
            return 412;
        }
        catch (PrincipalException pe) {
            return 403;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int copySimpleResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        File file = null;
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            long parentFolderId = 0L;
            try {
                parentFolderId = this.getParentFolderId(destinationArray);
            }
            catch (NoSuchFolderException nsfe) {
                int n = 409;
                if (file != null) {
                    file.delete();
                }
                return n;
            }
            IGImage image = (IGImage)resource.getModel();
            long groupId = WebDAVUtil.getGroupId((String)destination);
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = image.getDescription();
            String contentType = MimeTypesUtil.getContentType((String)image.getNameWithExtension());
            file = FileUtil.createTempFile((String)image.getImageType());
            InputStream is = resource.getContentAsStream();
            FileUtil.write((File)file, (InputStream)is);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddCommunityPermissions(this.isAddCommunityPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, name)) {
                status = 204;
            }
            IGImageServiceUtil.addImage((long)parentFolderId, (String)name, (String)description, (File)file, (String)contentType, (ServiceContext)serviceContext);
            int n = status;
            return n;
        }
        catch (DuplicateFolderNameException dfne) {
            int n = 412;
            return n;
        }
        catch (DuplicateFileException dfe) {
            int n = 412;
            return n;
        }
        catch (PrincipalException pe) {
            int n = 403;
            return n;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public int deleteResource(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            Resource resource = this.getResource(webDavRequest);
            if (resource == null) {
                return 404;
            }
            Object model = resource.getModel();
            if (model instanceof IGFolder) {
                IGFolder folder = (IGFolder)model;
                IGFolderServiceUtil.deleteFolder((long)folder.getFolderId());
            } else {
                IGImage image = (IGImage)model;
                IGImageServiceUtil.deleteImage((long)image.getImageId());
            }
            return 204;
        }
        catch (PrincipalException pe) {
            return 403;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public Resource getResource(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            String[] pathArray = webDavRequest.getPathArray();
            long parentFolderId = this.getParentFolderId(pathArray);
            String name = WebDAVUtil.getResourceName((String[])pathArray);
            if (Validator.isNull((String)name)) {
                String path = this.getRootPath() + webDavRequest.getPath();
                return new BaseResourceImpl(path, "", this.getToken());
            }
            try {
                IGFolder folder = IGFolderServiceUtil.getFolder((long)webDavRequest.getGroupId(), (long)parentFolderId, (String)name);
                if (folder.getParentFolderId() != parentFolderId || webDavRequest.getGroupId() != folder.getGroupId()) {
                    throw new NoSuchFolderException();
                }
                return this.toResource(webDavRequest, folder, false);
            }
            catch (NoSuchFolderException nsfe) {
                try {
                    IGImage image = IGImageServiceUtil.getImageByFolderIdAndNameWithExtension((long)parentFolderId, (String)name);
                    return this.toResource(webDavRequest, image, false);
                }
                catch (NoSuchImageException nsie) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public List<Resource> getResources(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            long folderId = this.getFolderId(webDavRequest.getPathArray());
            List<Resource> folders = this.getFolders(webDavRequest, folderId);
            List<Resource> images = this.getImages(webDavRequest, folderId);
            ArrayList<Resource> resources = new ArrayList<Resource>(folders.size() + images.size());
            resources.addAll(folders);
            resources.addAll(images);
            return resources;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public Status makeCollection(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            HttpServletRequest request = webDavRequest.getHttpServletRequest();
            if (request.getContentLength() > 0) {
                return new Status(415);
            }
            Object[] pathArray = webDavRequest.getPathArray();
            long groupId = webDavRequest.getGroupId();
            long parentFolderId = this.getParentFolderId((String[])pathArray);
            String name = WebDAVUtil.getResourceName((String[])pathArray);
            String description = "";
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddCommunityPermissions(this.isAddCommunityPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            serviceContext.setPlid(this.getPlid(webDavRequest.getGroupId()));
            serviceContext.setScopeGroupId(webDavRequest.getGroupId());
            IGFolderServiceUtil.addFolder((long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            String location = StringUtil.merge((Object[])pathArray, (String)"/");
            return new Status((Object)location, 201);
        }
        catch (DuplicateFolderNameException dfne) {
            return new Status(405);
        }
        catch (NoSuchFolderException nsfe) {
            return new Status(409);
        }
        catch (PrincipalException pe) {
            return new Status(403);
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int moveCollectionResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            IGFolder folder = (IGFolder)resource.getModel();
            long groupId = WebDAVUtil.getGroupId((String[])destinationArray);
            long folderId = folder.getFolderId();
            long parentFolderId = this.getParentFolderId(destinationArray);
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = folder.getDescription();
            ServiceContext serviceContext = new ServiceContext();
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, name)) {
                status = 204;
            }
            IGFolderServiceUtil.updateFolder((long)folderId, (long)parentFolderId, (String)name, (String)description, (boolean)false, (ServiceContext)serviceContext);
            return status;
        }
        catch (PrincipalException pe) {
            return 403;
        }
        catch (DuplicateFolderNameException dfne) {
            return 412;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int moveSimpleResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            IGImage image = (IGImage)resource.getModel();
            long groupId = WebDAVUtil.getGroupId((String[])destinationArray);
            long parentFolderId = this.getParentFolderId(destinationArray);
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = image.getDescription();
            File file = null;
            String contentType = null;
            ServiceContext serviceContext = new ServiceContext();
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, name)) {
                status = 204;
            }
            IGImageServiceUtil.updateImage((long)image.getImageId(), (long)parentFolderId, (String)name, (String)description, file, contentType, (ServiceContext)serviceContext);
            return status;
        }
        catch (PrincipalException pe) {
            return 403;
        }
        catch (DuplicateFileException dfe) {
            return 412;
        }
        catch (DuplicateFolderNameException dfne) {
            return 412;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int putResource(WebDAVRequest webDavRequest) throws WebDAVException {
        File file = null;
        try {
            HttpServletRequest request = webDavRequest.getHttpServletRequest();
            String[] pathArray = webDavRequest.getPathArray();
            long groupId = webDavRequest.getGroupId();
            long parentFolderId = this.getParentFolderId(pathArray);
            String name = WebDAVUtil.getResourceName((String[])pathArray);
            String description = "";
            file = FileUtil.createTempFile((String)FileUtil.getExtension((String)name));
            FileUtil.write((File)file, (InputStream)request.getInputStream());
            String contentType = MimeTypesUtil.getContentType((String)name);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddCommunityPermissions(this.isAddCommunityPermissions(groupId));
            serviceContext.setAddGuestPermissions(true);
            try {
                IGImage image = IGImageServiceUtil.getImageByFolderIdAndNameWithExtension((long)parentFolderId, (String)name);
                long imageId = image.getImageId();
                description = image.getDescription();
                String[] tagsEntries = TagsEntryLocalServiceUtil.getEntryNames((String)IGImage.class.getName(), (long)imageId);
                serviceContext.setTagsEntries(tagsEntries);
                IGImageServiceUtil.updateImage((long)imageId, (long)parentFolderId, (String)name, (String)description, (File)file, (String)contentType, (ServiceContext)serviceContext);
            }
            catch (NoSuchImageException nsie) {
                IGImageServiceUtil.addImage((long)parentFolderId, (String)name, (String)description, (File)file, (String)contentType, (ServiceContext)serviceContext);
            }
            int n = 201;
            return n;
        }
        catch (PrincipalException pe) {
            int n = 403;
            return n;
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)pe, (Throwable)pe);
            }
            int n = 409;
            return n;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    protected boolean deleteResource(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        try {
            IGFolder folder = IGFolderServiceUtil.getFolder((long)groupId, (long)parentFolderId, (String)name);
            IGFolderServiceUtil.deleteFolder((long)folder.getFolderId());
            return true;
        }
        catch (NoSuchFolderException nsfe) {
            if (name.indexOf(".") == -1) {
                return false;
            }
            try {
                IGImageServiceUtil.deleteImageByFolderIdAndNameWithExtension((long)parentFolderId, (String)name);
                return true;
            }
            catch (NoSuchImageException nsie) {
                return false;
            }
        }
    }

    protected List<Resource> getFolders(WebDAVRequest webDavRequest, long parentFolderId) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        long groupId = webDavRequest.getGroupId();
        List folders = IGFolderServiceUtil.getFolders((long)groupId, (long)parentFolderId);
        for (IGFolder folder : folders) {
            Resource resource = this.toResource(webDavRequest, folder, true);
            resources.add(resource);
        }
        return resources;
    }

    protected List<Resource> getImages(WebDAVRequest webDavRequest, long parentFolderId) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List images = IGImageServiceUtil.getImages((long)parentFolderId);
        for (IGImage image : images) {
            Resource resource = this.toResource(webDavRequest, image, true);
            resources.add(resource);
        }
        return resources;
    }

    protected long getFolderId(String[] pathArray) throws Exception {
        return this.getFolderId(pathArray, false);
    }

    protected long getFolderId(String[] pathArray, boolean parent) throws Exception {
        long folderId = 0L;
        if (pathArray.length <= 2) {
            return folderId;
        }
        long groupId = WebDAVUtil.getGroupId((String[])pathArray);
        int x = pathArray.length;
        if (parent) {
            --x;
        }
        for (int i = 3; i < x; ++i) {
            String name = pathArray[i];
            IGFolder folder = IGFolderServiceUtil.getFolder((long)groupId, (long)folderId, (String)name);
            if (groupId != folder.getGroupId()) continue;
            folderId = folder.getFolderId();
        }
        return folderId;
    }

    protected long getParentFolderId(String[] pathArray) throws Exception {
        return this.getFolderId(pathArray, true);
    }

    protected Resource toResource(WebDAVRequest webDavRequest, IGImage image, boolean appendPath) {
        String parentPath = this.getRootPath() + webDavRequest.getPath();
        String name = "";
        if (appendPath) {
            name = image.getNameWithExtension();
        }
        return new IGImageResourceImpl(image, parentPath, name);
    }

    protected Resource toResource(WebDAVRequest webDavRequest, IGFolder folder, boolean appendPath) {
        String parentPath = this.getRootPath() + webDavRequest.getPath();
        String name = "";
        if (appendPath) {
            name = folder.getName();
        }
        BaseResourceImpl resource = new BaseResourceImpl(parentPath, name, folder.getName(), folder.getCreateDate(), folder.getModifiedDate());
        resource.setModel((Object)folder);
        resource.setClassName(IGFolder.class.getName());
        resource.setPrimaryKey(folder.getPrimaryKey());
        return resource;
    }
}

