/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.ActionRequestImpl;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.journal.ArticleContentException;
import com.liferay.portlet.journal.ArticleDisplayDateException;
import com.liferay.portlet.journal.ArticleExpirationDateException;
import com.liferay.portlet.journal.ArticleIdException;
import com.liferay.portlet.journal.ArticleSmallImageNameException;
import com.liferay.portlet.journal.ArticleSmallImageSizeException;
import com.liferay.portlet.journal.ArticleTitleException;
import com.liferay.portlet.journal.ArticleTypeException;
import com.liferay.portlet.journal.DuplicateArticleIdException;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.NoSuchStructureException;
import com.liferay.portlet.journal.NoSuchTemplateException;
import com.liferay.portlet.journal.action.ActionUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.portlet.tags.TagsEntryException;
import com.liferay.util.LocalizationUtil;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditArticleAction
extends PortletAction {
    public static final String VERSION_SEPARATOR = "_version_";

    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        JournalArticle article = null;
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                article = this.updateArticle(actionRequest);
            } else if (cmd.equals("approve")) {
                this.approveArticle(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteArticles(actionRequest);
            } else if (cmd.equals("expire")) {
                this.expireArticles(actionRequest);
            } else if (cmd.equals("removeArticlesLocale")) {
                this.removeArticlesLocale(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                boolean saveAndContinue;
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                if (article != null && (saveAndContinue = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"saveAndContinue"))) {
                    redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, article, redirect);
                }
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchArticleException || e instanceof NoSuchStructureException || e instanceof NoSuchTemplateException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.journal.error");
            }
            if (e instanceof ArticleContentException || e instanceof ArticleDisplayDateException || e instanceof ArticleExpirationDateException || e instanceof ArticleIdException || e instanceof ArticleSmallImageNameException || e instanceof ArticleSmallImageSizeException || e instanceof ArticleTitleException || e instanceof ArticleTypeException || e instanceof DuplicateArticleIdException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            if (e instanceof TagsEntryException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            String cmd = ParamUtil.getString((PortletRequest)renderRequest, (String)"cmd");
            if (!cmd.equals("add")) {
                ActionUtil.getArticle(renderRequest);
            }
        }
        catch (NoSuchArticleException nsse) {
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.journal.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.journal.edit_article"));
    }

    protected void approveArticle(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        double version = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"version");
        String articleURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleURL");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        JournalArticleServiceUtil.approveArticle((long)groupId, (String)articleId, (double)version, (String)articleURL, (ServiceContext)serviceContext);
    }

    protected void deleteArticles(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String[] deleteArticleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteArticleIds"));
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        for (int i = 0; i < deleteArticleIds.length; ++i) {
            int pos = deleteArticleIds[i].lastIndexOf(VERSION_SEPARATOR);
            String articleId = deleteArticleIds[i].substring(0, pos);
            double version = GetterUtil.getDouble((String)deleteArticleIds[i].substring(pos + VERSION_SEPARATOR.length()));
            String articleURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleURL");
            JournalArticleServiceUtil.deleteArticle((long)groupId, (String)articleId, (double)version, (String)articleURL, (ServiceContext)serviceContext);
            JournalUtil.removeRecentArticle((PortletRequest)actionRequest, deleteArticleIds[i]);
        }
    }

    protected void expireArticles(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String[] expireArticleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"expireArticleIds"));
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        for (int i = 0; i < expireArticleIds.length; ++i) {
            int pos = expireArticleIds[i].lastIndexOf(VERSION_SEPARATOR);
            String articleId = expireArticleIds[i].substring(0, pos);
            double version = GetterUtil.getDouble((String)expireArticleIds[i].substring(pos + VERSION_SEPARATOR.length()));
            String articleURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleURL");
            JournalArticleServiceUtil.expireArticle((long)groupId, (String)articleId, (double)version, (String)articleURL, (ServiceContext)serviceContext);
        }
    }

    protected Map<String, byte[]> getImages(UploadPortletRequest uploadRequest) throws Exception {
        HashMap<String, byte[]> images = new HashMap<String, byte[]>();
        String imagePrefix = "structure_image_";
        Enumeration enu = uploadRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            File file;
            byte[] bytes;
            String name = (String)enu.nextElement();
            if (!name.startsWith(imagePrefix) || (bytes = FileUtil.getBytes((File)(file = uploadRequest.getFile(name)))) == null || bytes.length <= 0) continue;
            name = name.substring(imagePrefix.length(), name.length());
            images.put(name, bytes);
        }
        return images;
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, JournalArticle article, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String originalRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"originalRedirect");
        PortletURLImpl portletURL = new PortletURLImpl((ActionRequestImpl)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setWindowState(WindowState.MAXIMIZED);
        portletURL.setParameter("struts_action", "/journal/edit_article");
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("originalRedirect", originalRedirect, false);
        portletURL.setParameter("groupId", String.valueOf(article.getGroupId()), false);
        portletURL.setParameter("articleId", article.getArticleId(), false);
        portletURL.setParameter("version", String.valueOf(article.getVersion()), false);
        return portletURL.toString();
    }

    protected void removeArticlesLocale(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String[] removeArticleLocaleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteArticleIds"));
        for (int i = 0; i < removeArticleLocaleIds.length; ++i) {
            int pos = removeArticleLocaleIds[i].lastIndexOf(VERSION_SEPARATOR);
            String articleId = removeArticleLocaleIds[i].substring(0, pos);
            double version = GetterUtil.getDouble((String)removeArticleLocaleIds[i].substring(pos + VERSION_SEPARATOR.length()));
            String languageId = ParamUtil.getString((PortletRequest)actionRequest, (String)"languageId");
            JournalArticleServiceUtil.removeArticleLocale((long)groupId, (String)articleId, (double)version, (String)languageId);
        }
    }

    protected JournalArticle updateArticle(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest((ActionRequest)actionRequest);
        String cmd = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"cmd");
        long groupId = ParamUtil.getLong((HttpServletRequest)uploadRequest, (String)"groupId");
        String articleId = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"articleId");
        boolean autoArticleId = ParamUtil.getBoolean((HttpServletRequest)uploadRequest, (String)"autoArticleId");
        double version = ParamUtil.getDouble((HttpServletRequest)uploadRequest, (String)"version");
        boolean incrementVersion = ParamUtil.getBoolean((HttpServletRequest)uploadRequest, (String)"incrementVersion");
        String title = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"title");
        String description = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"description");
        String content = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"content");
        String type = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"type");
        String structureId = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"structureId");
        String templateId = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"templateId");
        String lastLanguageId = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"lastLanguageId");
        String defaultLanguageId = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"defaultLanguageId");
        int displayDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"displayDateMonth");
        int displayDateDay = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"displayDateDay");
        int displayDateYear = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"displayDateYear");
        int displayDateHour = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"displayDateHour");
        int displayDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"displayDateMinute");
        int displayDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"displayDateAmPm");
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        int expirationDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"expirationDateMonth");
        int expirationDateDay = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"expirationDateDay");
        int expirationDateYear = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"expirationDateYear");
        int expirationDateHour = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"expirationDateHour");
        int expirationDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"expirationDateMinute");
        int expirationDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"expirationDateAmPm");
        boolean neverExpire = ParamUtil.getBoolean((HttpServletRequest)uploadRequest, (String)"neverExpire");
        if (expirationDateAmPm == 1) {
            expirationDateHour += 12;
        }
        int reviewDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"reviewDateMonth");
        int reviewDateDay = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"reviewDateDay");
        int reviewDateYear = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"reviewDateYear");
        int reviewDateHour = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"reviewDateHour");
        int reviewDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"reviewDateMinute");
        int reviewDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"reviewDateAmPm");
        boolean neverReview = ParamUtil.getBoolean((HttpServletRequest)uploadRequest, (String)"neverReview");
        if (reviewDateAmPm == 1) {
            reviewDateHour += 12;
        }
        boolean indexable = ParamUtil.getBoolean((HttpServletRequest)uploadRequest, (String)"indexable");
        boolean smallImage = ParamUtil.getBoolean((HttpServletRequest)uploadRequest, (String)"smallImage");
        String smallImageURL = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"smallImageURL");
        File smallFile = uploadRequest.getFile("smallFile");
        Map<String, byte[]> images = this.getImages(uploadRequest);
        String articleURL = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"articleURL");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        JournalArticle article = null;
        if (cmd.equals("add")) {
            if (Validator.isNull((String)structureId)) {
                content = LocalizationUtil.updateLocalization((String)"", (String)"static-content", (String)content, (String)lastLanguageId, (String)defaultLanguageId, (boolean)true);
            }
            article = JournalArticleServiceUtil.addArticle((long)groupId, (String)articleId, (boolean)autoArticleId, (String)title, (String)description, (String)content, (String)type, (String)structureId, (String)templateId, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)indexable, (boolean)smallImage, (String)smallImageURL, (File)smallFile, images, (String)articleURL, (ServiceContext)serviceContext);
            AssetPublisherUtil.addAndStoreSelection(actionRequest, JournalArticle.class.getName(), article.getResourcePrimKey(), -1);
        } else {
            JournalArticle curArticle = JournalArticleServiceUtil.getArticle((long)groupId, (String)articleId, (double)version);
            if (Validator.isNull((String)structureId)) {
                if (!curArticle.isTemplateDriven()) {
                    content = LocalizationUtil.updateLocalization((String)curArticle.getContent(), (String)"static-content", (String)content, (String)lastLanguageId, (String)defaultLanguageId, (boolean)true);
                }
            } else if (curArticle.isTemplateDriven()) {
                JournalStructure structure = JournalStructureLocalServiceUtil.getStructure((long)groupId, (String)structureId);
                content = JournalUtil.mergeArticleContent(curArticle.getContent(), content);
                content = JournalUtil.removeOldContent(content, structure.getMergedXsd());
            }
            article = JournalArticleServiceUtil.updateArticle((long)groupId, (String)articleId, (double)version, (boolean)incrementVersion, (String)title, (String)description, (String)content, (String)type, (String)structureId, (String)templateId, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)indexable, (boolean)smallImage, (String)smallImageURL, (File)smallFile, images, (String)articleURL, (ServiceContext)serviceContext);
        }
        boolean approve = ParamUtil.getBoolean((HttpServletRequest)uploadRequest, (String)"approve");
        if (approve) {
            article = JournalArticleServiceUtil.approveArticle((long)article.getGroupId(), (String)article.getArticleId(), (double)article.getVersion(), (String)articleURL, (ServiceContext)serviceContext);
        }
        JournalUtil.addRecentArticle((PortletRequest)actionRequest, article);
        String portletResource = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"portletResource");
        if (Validator.isNotNull((String)portletResource)) {
            PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((HttpServletRequest)uploadRequest, (String)portletResource);
            preferences.setValue("group-id", String.valueOf(article.getGroupId()));
            preferences.setValue("article-id", article.getArticleId());
            preferences.store();
            this.updateContentSearch(actionRequest, portletResource, article.getArticleId());
        }
        return article;
    }

    protected void updateContentSearch(ActionRequest actionRequest, String portletResource, String articleId) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        JournalContentSearchLocalServiceUtil.updateContentSearch((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletResource, (String)articleId);
    }
}

