/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.ActionRequestImpl;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.journal.DuplicateStructureIdException;
import com.liferay.portlet.journal.NoSuchStructureException;
import com.liferay.portlet.journal.RequiredStructureException;
import com.liferay.portlet.journal.StructureDescriptionException;
import com.liferay.portlet.journal.StructureIdException;
import com.liferay.portlet.journal.StructureInheritanceException;
import com.liferay.portlet.journal.StructureNameException;
import com.liferay.portlet.journal.StructureXsdException;
import com.liferay.portlet.journal.action.ActionUtil;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.JournalStructureServiceUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditStructureAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        JournalStructure structure = null;
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                structure = this.updateStructure(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteStructures(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                boolean saveAndContinue;
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                if (structure != null && (saveAndContinue = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"saveAndContinue"))) {
                    redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, structure, redirect);
                }
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchStructureException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.journal.error");
            }
            if (e instanceof DuplicateStructureIdException || e instanceof RequiredStructureException || e instanceof StructureDescriptionException || e instanceof StructureIdException || e instanceof StructureInheritanceException || e instanceof StructureNameException || e instanceof StructureXsdException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                if (e instanceof RequiredStructureException) {
                    actionResponse.sendRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                }
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            String cmd = ParamUtil.getString((PortletRequest)renderRequest, (String)"cmd");
            if (!cmd.equals("add")) {
                ActionUtil.getStructure(renderRequest);
            }
        }
        catch (NoSuchStructureException nsse) {
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.journal.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.journal.edit_structure"));
    }

    protected void deleteStructures(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String[] deleteStructureIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteStructureIds"));
        for (int i = 0; i < deleteStructureIds.length; ++i) {
            JournalStructureServiceUtil.deleteStructure((long)groupId, (String)deleteStructureIds[i]);
            JournalUtil.removeRecentStructure((PortletRequest)actionRequest, deleteStructureIds[i]);
        }
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, JournalStructure structure, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String originalRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"originalRedirect");
        PortletURLImpl portletURL = new PortletURLImpl((ActionRequestImpl)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setWindowState(WindowState.MAXIMIZED);
        portletURL.setParameter("struts_action", "/journal/edit_structure");
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("originalRedirect", originalRedirect, false);
        portletURL.setParameter("groupId", String.valueOf(structure.getGroupId()), false);
        portletURL.setParameter("structureId", structure.getStructureId(), false);
        return portletURL.toString();
    }

    protected JournalStructure updateStructure(ActionRequest actionRequest) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String structureId = ParamUtil.getString((PortletRequest)actionRequest, (String)"structureId");
        boolean autoStructureId = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"autoStructureId");
        String parentStructureId = ParamUtil.getString((PortletRequest)actionRequest, (String)"parentStructureId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        String xsd = ParamUtil.getString((PortletRequest)actionRequest, (String)"xsd");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalStructure.class.getName(), (PortletRequest)actionRequest);
        JournalStructure structure = null;
        structure = cmd.equals("add") ? JournalStructureServiceUtil.addStructure((long)groupId, (String)structureId, (boolean)autoStructureId, (String)parentStructureId, (String)name, (String)description, (String)xsd, (ServiceContext)serviceContext) : JournalStructureServiceUtil.updateStructure((long)groupId, (String)structureId, (String)parentStructureId, (String)name, (String)description, (String)xsd, (ServiceContext)serviceContext);
        JournalUtil.addRecentStructure((PortletRequest)actionRequest, structure);
        return structure;
    }
}

