/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.ActionRequestImpl;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.journal.DuplicateTemplateIdException;
import com.liferay.portlet.journal.NoSuchTemplateException;
import com.liferay.portlet.journal.RequiredTemplateException;
import com.liferay.portlet.journal.TemplateDescriptionException;
import com.liferay.portlet.journal.TemplateIdException;
import com.liferay.portlet.journal.TemplateNameException;
import com.liferay.portlet.journal.TemplateSmallImageNameException;
import com.liferay.portlet.journal.TemplateSmallImageSizeException;
import com.liferay.portlet.journal.TemplateXslException;
import com.liferay.portlet.journal.action.ActionUtil;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalTemplateServiceUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.util.JS;
import java.io.File;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditTemplateAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        JournalTemplate template = null;
        try {
            boolean saveAndContinue;
            if (cmd.equals("add") || cmd.equals("update")) {
                template = this.updateTemplate(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteTemplates(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            if (template != null && (saveAndContinue = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"saveAndContinue"))) {
                redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, template, redirect);
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            if (e instanceof NoSuchTemplateException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.journal.error");
            }
            if (e instanceof DuplicateTemplateIdException || e instanceof RequiredTemplateException || e instanceof TemplateDescriptionException || e instanceof TemplateIdException || e instanceof TemplateNameException || e instanceof TemplateSmallImageNameException || e instanceof TemplateSmallImageSizeException || e instanceof TemplateXslException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                if (e instanceof RequiredTemplateException) {
                    actionResponse.sendRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                }
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            String cmd = ParamUtil.getString((PortletRequest)renderRequest, (String)"cmd");
            if (!cmd.equals("add")) {
                ActionUtil.getTemplate(renderRequest);
            }
        }
        catch (NoSuchTemplateException nsse) {
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.journal.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.journal.edit_template"));
    }

    protected void deleteTemplates(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String[] deleteTemplateIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteTemplateIds"));
        for (int i = 0; i < deleteTemplateIds.length; ++i) {
            JournalTemplateServiceUtil.deleteTemplate((long)groupId, (String)deleteTemplateIds[i]);
            JournalUtil.removeRecentTemplate((PortletRequest)actionRequest, deleteTemplateIds[i]);
        }
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, JournalTemplate template, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String originalRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"originalRedirect");
        PortletURLImpl portletURL = new PortletURLImpl((ActionRequestImpl)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setWindowState(WindowState.MAXIMIZED);
        portletURL.setParameter("struts_action", "/journal/edit_template");
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("originalRedirect", originalRedirect, false);
        portletURL.setParameter("groupId", String.valueOf(template.getGroupId()), false);
        portletURL.setParameter("templateId", template.getTemplateId(), false);
        return portletURL.toString();
    }

    protected JournalTemplate updateTemplate(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest((ActionRequest)actionRequest);
        String cmd = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"cmd");
        long groupId = ParamUtil.getLong((HttpServletRequest)uploadRequest, (String)"groupId");
        String templateId = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"templateId");
        boolean autoTemplateId = ParamUtil.getBoolean((HttpServletRequest)uploadRequest, (String)"autoTemplateId");
        String structureId = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"structureId");
        String name = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"name");
        String description = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"description");
        String xsl = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"xsl");
        String xslContent = JS.decodeURIComponent((String)ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"xslContent"));
        boolean formatXsl = ParamUtil.getBoolean((HttpServletRequest)uploadRequest, (String)"formatXsl");
        if (Validator.isNull((String)xsl)) {
            xsl = xslContent;
        }
        String langType = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"langType", (String)"xsl");
        boolean cacheable = ParamUtil.getBoolean((HttpServletRequest)uploadRequest, (String)"cacheable");
        boolean smallImage = ParamUtil.getBoolean((HttpServletRequest)uploadRequest, (String)"smallImage");
        String smallImageURL = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"smallImageURL");
        File smallFile = uploadRequest.getFile("smallFile");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalTemplate.class.getName(), (PortletRequest)actionRequest);
        JournalTemplate template = null;
        template = cmd.equals("add") ? JournalTemplateServiceUtil.addTemplate((long)groupId, (String)templateId, (boolean)autoTemplateId, (String)structureId, (String)name, (String)description, (String)xsl, (boolean)formatXsl, (String)langType, (boolean)cacheable, (boolean)smallImage, (String)smallImageURL, (File)smallFile, (ServiceContext)serviceContext) : JournalTemplateServiceUtil.updateTemplate((long)groupId, (String)templateId, (String)structureId, (String)name, (String)description, (String)xsl, (boolean)formatXsl, (String)langType, (boolean)cacheable, (boolean)smallImage, (String)smallImageURL, (File)smallFile, (ServiceContext)serviceContext);
        JournalUtil.addRecentTemplate((PortletRequest)actionRequest, template);
        return template;
    }
}

