/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.BasePortletDataHandler;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataException;
import com.liferay.portal.lar.PortletDataHandlerBoolean;
import com.liferay.portal.lar.PortletDataHandlerControl;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portlet.documentlibrary.lar.DLPortletDataHandlerImpl;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileRank;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.imagegallery.lar.IGPortletDataHandlerImpl;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.lar.JournalPortletDataHandlerImpl;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import com.liferay.portlet.journal.service.persistence.JournalStructureUtil;
import com.liferay.portlet.journal.service.persistence.JournalTemplateUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class JournalContentPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _PUBLISH_TO_LIVE_BY_DEFAULT = true;
    private static final String _NAMESPACE = "journal";
    private static final PortletDataHandlerBoolean _selectedArticles = new PortletDataHandlerBoolean("journal", "selected-web-content", true, true);
    private static final PortletDataHandlerBoolean _embeddedAssets = new PortletDataHandlerBoolean("journal", "embedded-assets");
    private static final PortletDataHandlerBoolean _images = new PortletDataHandlerBoolean("journal", "images");
    private static final PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("journal", "comments");
    private static final PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("journal", "ratings");
    private static final PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("journal", "tags");
    private static Log _log = LogFactoryUtil.getLog(JournalContentPortletDataHandlerImpl.class);

    public PortletPreferences deleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            preferences.setValue("group-id", "");
            preferences.setValue("article-id", "");
            return preferences;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public String exportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            String templateId;
            JournalArticle article;
            block11: {
                String articleId = preferences.getValue("article-id", null);
                if (articleId == null) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("No article id found in preferences of portlet " + portletId));
                    }
                    return "";
                }
                long articleGroupId = GetterUtil.getLong((String)preferences.getValue("group-id", ""));
                if (articleGroupId <= 0L) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("No group id found in preferences of portlet " + portletId));
                    }
                    return "";
                }
                article = null;
                try {
                    article = JournalArticleLocalServiceUtil.getLatestArticle((long)articleGroupId, (String)articleId, (Boolean)true);
                }
                catch (NoSuchArticleException nsae) {
                    if (!_log.isWarnEnabled()) break block11;
                    _log.warn((Throwable)nsae);
                }
            }
            if (article == null) {
                return "";
            }
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("journal-content-data");
            Element dlFoldersEl = root.addElement("dl-folders");
            Element dlFilesEl = root.addElement("dl-file-entries");
            Element dlFileRanksEl = root.addElement("dl-file-ranks");
            Element igFoldersEl = root.addElement("ig-folders");
            Element igImagesEl = root.addElement("ig-images");
            JournalPortletDataHandlerImpl.exportArticle(context, root, dlFoldersEl, dlFilesEl, dlFileRanksEl, igFoldersEl, igImagesEl, article);
            String structureId = article.getStructureId();
            if (Validator.isNotNull((String)structureId)) {
                JournalStructure structure = JournalStructureUtil.findByG_S((long)article.getGroupId(), (String)structureId);
                JournalPortletDataHandlerImpl.exportStructure(context, root, structure);
            }
            if (Validator.isNotNull((String)(templateId = article.getTemplateId()))) {
                JournalTemplate template = JournalTemplateUtil.findByG_T((long)article.getGroupId(), (String)templateId);
                JournalPortletDataHandlerImpl.exportTemplate(context, root, dlFoldersEl, dlFilesEl, dlFileRanksEl, igFoldersEl, igImagesEl, template);
            }
            return doc.formattedString();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_selectedArticles, _embeddedAssets, _images, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_selectedArticles, _images, _comments, _ratings, _tags};
    }

    public PortletPreferences importData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws PortletDataException {
        try {
            if (Validator.isNull((String)data)) {
                return null;
            }
            Document doc = SAXReaderUtil.read((String)data);
            Element root = doc.getRootElement();
            Element structureEl = root.element("structure");
            Map structureIds = context.getNewPrimaryKeysMap(JournalStructure.class);
            if (structureEl != null) {
                JournalPortletDataHandlerImpl.importStructure(context, (Map<String, String>)structureIds, structureEl);
            }
            Element templateEl = root.element("template");
            Map templateIds = context.getNewPrimaryKeysMap(JournalTemplate.class);
            if (templateEl != null) {
                JournalPortletDataHandlerImpl.importTemplate(context, structureIds, templateIds, templateEl);
            }
            Element articleEl = root.element("article");
            Map articleIds = context.getNewPrimaryKeysMap(JournalArticle.class);
            if (articleEl != null) {
                JournalPortletDataHandlerImpl.importArticle(context, structureIds, templateIds, articleIds, articleEl);
            }
            Element dlFoldersEl = root.element("dl-folders");
            List dlFolderEls = Collections.EMPTY_LIST;
            if (dlFoldersEl != null) {
                dlFolderEls = dlFoldersEl.elements("folder");
            }
            Map dlFolderPKs = context.getNewPrimaryKeysMap(DLFolder.class);
            for (Element folderEl : dlFolderEls) {
                String path = folderEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                DLFolder folder = (DLFolder)context.getZipEntryAsObject(path);
                DLPortletDataHandlerImpl.importFolder(context, dlFolderPKs, folder);
            }
            Element dlFileEntriesEl = root.element("dl-file-entries");
            List dlFileEntryEls = Collections.EMPTY_LIST;
            if (dlFileEntriesEl != null) {
                dlFileEntryEls = dlFileEntriesEl.elements("file-entry");
            }
            Map fileEntryNames = context.getNewPrimaryKeysMap(DLFileEntry.class);
            for (Element fileEntryEl : dlFileEntryEls) {
                String path = fileEntryEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                DLFileEntry fileEntry = (DLFileEntry)context.getZipEntryAsObject(path);
                String binPath = fileEntryEl.attributeValue("bin-path");
                DLPortletDataHandlerImpl.importFileEntry(context, dlFolderPKs, fileEntryNames, fileEntry, binPath);
            }
            Element dlFileRanksEl = root.element("dl-file-ranks");
            List dlFileRankEls = Collections.EMPTY_LIST;
            if (dlFileRanksEl != null) {
                dlFileRankEls = dlFileRanksEl.elements("file-rank");
            }
            for (Element fileRankEl : dlFileRankEls) {
                String path = fileRankEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                DLFileRank fileRank = (DLFileRank)context.getZipEntryAsObject(path);
                DLPortletDataHandlerImpl.importFileRank(context, dlFolderPKs, fileEntryNames, fileRank);
            }
            Element igFoldersEl = root.element("ig-folders");
            List igFolderEls = Collections.EMPTY_LIST;
            if (igFoldersEl != null) {
                igFolderEls = igFoldersEl.elements("folder");
            }
            Map igFolderPKs = context.getNewPrimaryKeysMap(IGFolder.class);
            for (Element folderEl : igFolderEls) {
                String path = folderEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                IGFolder folder = (IGFolder)context.getZipEntryAsObject(path);
                IGPortletDataHandlerImpl.importFolder(context, igFolderPKs, folder);
            }
            Element igImagesEl = root.element("ig-images");
            List igImageEls = Collections.EMPTY_LIST;
            if (igImagesEl != null) {
                igImageEls = igImagesEl.elements("image");
            }
            for (Element imageEl : igImageEls) {
                String path = imageEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                IGImage image = (IGImage)context.getZipEntryAsObject(path);
                String binPath = imageEl.attributeValue("bin-path");
                IGPortletDataHandlerImpl.importImage(context, igFolderPKs, image, binPath);
            }
            String articleId = preferences.getValue("article-id", "");
            if (Validator.isNotNull((String)articleId)) {
                articleId = MapUtil.getString((Map)articleIds, (String)articleId, (String)articleId);
                preferences.setValue("group-id", String.valueOf(context.getGroupId()));
                preferences.setValue("article-id", articleId);
                Layout layout = LayoutLocalServiceUtil.getLayout((long)context.getPlid());
                JournalContentSearchLocalServiceUtil.updateContentSearch((long)context.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletId, (String)articleId, (boolean)true);
            }
            return preferences;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public boolean isPublishToLiveByDefault() {
        return true;
    }
}

