/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.NoSuchImageException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.BasePortletDataHandler;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataException;
import com.liferay.portal.lar.PortletDataHandlerBoolean;
import com.liferay.portal.lar.PortletDataHandlerControl;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.ImageUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.lar.DLPortletDataHandlerImpl;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileRank;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.imagegallery.lar.IGPortletDataHandlerImpl;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import com.liferay.portlet.journal.lar.JournalCreationStrategy;
import com.liferay.portlet.journal.lar.JournalCreationStrategyFactory;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleImage;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalFeedLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalTemplateLocalServiceUtil;
import com.liferay.portlet.journal.service.persistence.JournalArticleImageUtil;
import com.liferay.portlet.journal.service.persistence.JournalArticleUtil;
import com.liferay.portlet.journal.service.persistence.JournalFeedUtil;
import com.liferay.portlet.journal.service.persistence.JournalStructureUtil;
import com.liferay.portlet.journal.service.persistence.JournalTemplateUtil;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final String _NAMESPACE = "journal";
    private static final PortletDataHandlerBoolean _embeddedAssets = new PortletDataHandlerBoolean("journal", "embedded-assets");
    private static final PortletDataHandlerBoolean _images = new PortletDataHandlerBoolean("journal", "images");
    private static final PortletDataHandlerBoolean _categories = new PortletDataHandlerBoolean("journal", "categories");
    private static final PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("journal", "comments");
    private static final PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("journal", "ratings");
    private static final PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("journal", "tags");
    private static final PortletDataHandlerBoolean _articles = new PortletDataHandlerBoolean("journal", "articles", true, false, new PortletDataHandlerControl[]{_images, _comments, _ratings, _tags});
    private static final PortletDataHandlerBoolean _structuresTemplatesAndFeeds = new PortletDataHandlerBoolean("journal", "structures-templates-and-feeds", true, true);
    private static Log _log = LogFactoryUtil.getLog(JournalPortletDataHandlerImpl.class);

    public static void exportArticle(PortletDataContext context, Element articlesEl, Element dlFoldersEl, Element dlFileEntriesEl, Element dlFileRanks, Element igFoldersEl, Element igImagesEl, JournalArticle article) throws PortalException, SystemException {
        if (!context.isWithinDateRange(article.getModifiedDate())) {
            return;
        }
        String path = JournalPortletDataHandlerImpl.getArticlePath(context, article);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        article = (JournalArticle)article.clone();
        Element articleEl = articlesEl.addElement("article");
        articleEl.addAttribute("path", path);
        Image smallImage = ImageUtil.fetchByPrimaryKey((long)article.getSmallImageId());
        if (article.isSmallImage() && smallImage != null) {
            String smallImagePath = JournalPortletDataHandlerImpl.getArticleSmallImagePath(context, article);
            articleEl.addAttribute("small-image-path", smallImagePath);
            article.setSmallImageType(smallImage.getType());
            context.addZipEntry(smallImagePath, smallImage.getTextObj());
        }
        if (context.getBooleanParameter(_NAMESPACE, "images")) {
            String imagePath = JournalPortletDataHandlerImpl.getArticleImagePath(context, article);
            articleEl.addAttribute("image-path", imagePath);
            List articleImages = JournalArticleImageUtil.findByG_A_V((long)article.getGroupId(), (String)article.getArticleId(), (double)article.getVersion());
            for (JournalArticleImage articleImage : articleImages) {
                try {
                    Image image = ImageUtil.findByPrimaryKey((long)articleImage.getArticleImageId());
                    String articleImagePath = JournalPortletDataHandlerImpl.getArticleImagePath(context, article, articleImage, image);
                    if (!context.isPathNotProcessed(articleImagePath)) continue;
                    context.addZipEntry(articleImagePath, image.getTextObj());
                }
                catch (NoSuchImageException nsie) {}
            }
        }
        if (context.getBooleanParameter(_NAMESPACE, "categories")) {
            context.addTagsCategories(JournalArticle.class, article.getResourcePrimKey());
        }
        if (context.getBooleanParameter(_NAMESPACE, "comments")) {
            context.addComments(JournalArticle.class, article.getResourcePrimKey());
        }
        if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
            context.addRatingsEntries(JournalArticle.class, article.getResourcePrimKey());
        }
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            context.addTagsEntries(JournalArticle.class, article.getResourcePrimKey());
        }
        if (context.getBooleanParameter(_NAMESPACE, "embedded-assets")) {
            String content = article.getContent();
            content = JournalPortletDataHandlerImpl.exportDLFileEntries(context, dlFoldersEl, dlFileEntriesEl, dlFileRanks, article.getGroupId(), content);
            content = JournalPortletDataHandlerImpl.exportIGImages(context, igFoldersEl, igImagesEl, article.getGroupId(), content);
            article.setContent(content);
        }
        article.setUserUuid(article.getUserUuid());
        article.setApprovedByUserUuid(article.getApprovedByUserUuid());
        context.addZipEntry(path, (Object)article);
    }

    public static void exportFeed(PortletDataContext context, Element feedsEl, JournalFeed feed) throws SystemException {
        if (!context.isWithinDateRange(feed.getModifiedDate())) {
            return;
        }
        String path = JournalPortletDataHandlerImpl.getFeedPath(context, feed);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element feedEl = feedsEl.addElement("feed");
        feedEl.addAttribute("path", path);
        feed.setUserUuid(feed.getUserUuid());
        context.addZipEntry(path, (Object)feed);
    }

    public static String exportDLFileEntries(PortletDataContext context, Element foldersEl, Element fileEntriesEl, Element fileRanks, long entityGroupId, String content) {
        StringBuilder sb = new StringBuilder(content);
        int beginPos = content.length();
        while (true) {
            block16: {
                if ((beginPos = content.lastIndexOf("/get_file?", beginPos)) == -1) {
                    return sb.toString();
                }
                int endPos1 = content.indexOf("'", beginPos);
                int endPos2 = content.indexOf("]", beginPos);
                int endPos3 = content.indexOf(")", beginPos);
                int endPos4 = content.indexOf("<", beginPos);
                int endPos5 = content.indexOf("\"", beginPos);
                int endPos6 = content.indexOf(" ", beginPos);
                int endPos = endPos1;
                if (endPos == -1 || endPos2 != -1 && endPos2 < endPos) {
                    endPos = endPos2;
                }
                if (endPos == -1 || endPos3 != -1 && endPos3 < endPos) {
                    endPos = endPos3;
                }
                if (endPos == -1 || endPos4 != -1 && endPos4 < endPos) {
                    endPos = endPos4;
                }
                if (endPos == -1 || endPos5 != -1 && endPos5 < endPos) {
                    endPos = endPos5;
                }
                if (endPos == -1 || endPos6 != -1 && endPos6 < endPos) {
                    endPos = endPos6;
                }
                if (beginPos == -1 || endPos == -1) break;
                try {
                    String oldParameters = content.substring(beginPos, endPos);
                    oldParameters = oldParameters.substring(oldParameters.indexOf("?") + 1);
                    boolean hasEncodedAmpersands = false;
                    while (oldParameters.contains("&amp;")) {
                        hasEncodedAmpersands = true;
                        oldParameters = oldParameters.replace("&amp;", "&");
                    }
                    LinkedHashMap map = MapUtil.toLinkedHashMap((String[])oldParameters.split("&"), (String)"=");
                    DLFileEntry fileEntry = null;
                    if (map.containsKey("uuid")) {
                        String uuid = (String)map.get("uuid");
                        String groupIdString = (String)map.get("groupId");
                        long groupId = GetterUtil.getLong((String)groupIdString);
                        if (groupIdString.equals("@group_id@")) {
                            groupId = entityGroupId;
                        }
                        fileEntry = DLFileEntryLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                    } else if (map.containsKey("folderId")) {
                        long folderId = GetterUtil.getLong((String)((String)map.get("folderId")));
                        String name = (String)map.get("name");
                        fileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)folderId, (String)name);
                    }
                    if (fileEntry == null) {
                        --beginPos;
                        continue;
                    }
                    DLPortletDataHandlerImpl.exportFileEntry(context, foldersEl, fileEntriesEl, fileRanks, fileEntry);
                    String newParameters = "/get_file?uuid=" + fileEntry.getUuid() + "&groupId=@data_handler_group_id@";
                    if (hasEncodedAmpersands) {
                        newParameters = newParameters.replace("&", "&amp;");
                    }
                    sb.replace(beginPos, endPos, newParameters);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block16;
                    _log.warn((Throwable)e);
                }
            }
            --beginPos;
        }
        return sb.toString();
    }

    public static String exportIGImages(PortletDataContext context, Element foldersEl, Element imagesEl, long entityGroupId, String content) {
        StringBuilder sb = new StringBuilder(content);
        int beginPos = content.length();
        while (true) {
            block20: {
                if ((beginPos = content.lastIndexOf("/image_gallery?", beginPos)) == -1) {
                    return sb.toString();
                }
                int endPos1 = content.indexOf("'", beginPos);
                int endPos2 = content.indexOf("]", beginPos);
                int endPos3 = content.indexOf(")", beginPos);
                int endPos4 = content.indexOf("<", beginPos);
                int endPos5 = content.indexOf("\"", beginPos);
                int endPos6 = content.indexOf(" ", beginPos);
                int endPos = endPos1;
                if (endPos == -1 || endPos2 != -1 && endPos2 < endPos) {
                    endPos = endPos2;
                }
                if (endPos == -1 || endPos3 != -1 && endPos3 < endPos) {
                    endPos = endPos3;
                }
                if (endPos == -1 || endPos4 != -1 && endPos4 < endPos) {
                    endPos = endPos4;
                }
                if (endPos == -1 || endPos5 != -1 && endPos5 < endPos) {
                    endPos = endPos5;
                }
                if (endPos == -1 || endPos6 != -1 && endPos6 < endPos) {
                    endPos = endPos6;
                }
                if (beginPos == -1 || endPos == -1) break;
                try {
                    String oldParameters = content.substring(beginPos, endPos);
                    oldParameters = oldParameters.substring(oldParameters.indexOf("?") + 1);
                    boolean hasEncodedAmpersands = false;
                    while (oldParameters.contains("&amp;")) {
                        hasEncodedAmpersands = true;
                        oldParameters = oldParameters.replace("&amp;", "&");
                    }
                    LinkedHashMap map = MapUtil.toLinkedHashMap((String[])oldParameters.split("&"), (String)"=");
                    IGImage image = null;
                    if (map.containsKey("uuid")) {
                        String uuid = (String)map.get("uuid");
                        String groupIdString = (String)map.get("groupId");
                        long groupId = GetterUtil.getLong((String)groupIdString);
                        if (groupIdString.equals("@group_id@")) {
                            groupId = entityGroupId;
                        }
                        image = IGImageLocalServiceUtil.getImageByUuidAndGroupId((String)uuid, (long)groupId);
                    } else if (map.containsKey("image_id") || map.containsKey("img_id") || map.containsKey("i_id")) {
                        long imageId = GetterUtil.getLong((String)((String)map.get("image_id")));
                        if (imageId <= 0L && (imageId = GetterUtil.getLong((String)((String)map.get("img_id")))) <= 0L) {
                            imageId = GetterUtil.getLong((String)((String)map.get("i_id")));
                        }
                        try {
                            image = IGImageLocalServiceUtil.getImageByLargeImageId((long)imageId);
                        }
                        catch (Exception e) {
                            image = IGImageLocalServiceUtil.getImageBySmallImageId((long)imageId);
                        }
                    }
                    if (image == null) {
                        --beginPos;
                        continue;
                    }
                    IGPortletDataHandlerImpl.exportImage(context, foldersEl, imagesEl, image);
                    String timestamp = (String)map.get("t");
                    if (timestamp == null) {
                        timestamp = String.valueOf(System.currentTimeMillis());
                    }
                    String newParameters = "/image_gallery?uuid=" + image.getUuid() + "&groupId=@data_handler_group_id@&t=" + timestamp;
                    if (hasEncodedAmpersands) {
                        newParameters = newParameters.replace("&", "&amp;");
                    }
                    sb.replace(beginPos, endPos, newParameters);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block20;
                    _log.warn((Throwable)e);
                }
            }
            --beginPos;
        }
        return sb.toString();
    }

    public static void exportStructure(PortletDataContext context, Element structuresEl, JournalStructure structure) throws SystemException {
        if (!context.isWithinDateRange(structure.getModifiedDate())) {
            return;
        }
        String path = JournalPortletDataHandlerImpl.getStructurePath(context, structure);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element structureEl = structuresEl.addElement("structure");
        structureEl.addAttribute("path", path);
        structure.setUserUuid(structure.getUserUuid());
        context.addZipEntry(path, (Object)structure);
    }

    public static void exportTemplate(PortletDataContext context, Element templatesEl, Element dlFoldersEl, Element dlFileEntriesEl, Element dlFileRanks, Element igFoldersEl, Element igImagesEl, JournalTemplate template) throws PortalException, SystemException {
        if (!context.isWithinDateRange(template.getModifiedDate())) {
            return;
        }
        String path = JournalPortletDataHandlerImpl.getTemplatePath(context, template);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        template = (JournalTemplate)template.clone();
        Element templateEl = templatesEl.addElement("template");
        templateEl.addAttribute("path", path);
        if (template.isSmallImage()) {
            String smallImagePath = JournalPortletDataHandlerImpl.getTemplateSmallImagePath(context, template);
            templateEl.addAttribute("small-image-path", smallImagePath);
            Image smallImage = ImageUtil.fetchByPrimaryKey((long)template.getSmallImageId());
            template.setSmallImageType(smallImage.getType());
            context.addZipEntry(smallImagePath, smallImage.getTextObj());
        }
        if (context.getBooleanParameter(_NAMESPACE, "embedded-assets")) {
            String content = template.getXsl();
            content = JournalPortletDataHandlerImpl.exportDLFileEntries(context, dlFoldersEl, dlFileEntriesEl, dlFileRanks, template.getGroupId(), content);
            content = JournalPortletDataHandlerImpl.exportIGImages(context, igFoldersEl, igImagesEl, template.getGroupId(), content);
            content = StringUtil.replace((String)content, (String)"&amp;", (String)"&");
            template.setXsl(content);
        }
        template.setUserUuid(template.getUserUuid());
        context.addZipEntry(path, (Object)template);
    }

    public static void importArticle(PortletDataContext context, Map<String, String> structureIds, Map<String, String> templateIds, Map<String, String> articleIds, Element articleEl) throws Exception {
        JournalTemplate template;
        JournalStructure structure;
        String newContent;
        JournalCreationStrategy creationStrategy;
        long authorId;
        String newArticleId;
        String path = articleEl.attributeValue("path");
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        JournalArticle article = (JournalArticle)context.getZipEntryAsObject(path);
        long userId = context.getUserId(article.getUserUuid());
        User user = UserLocalServiceUtil.getUser((long)userId);
        long groupId = context.getGroupId();
        String articleId = article.getArticleId();
        boolean autoArticleId = false;
        if (Validator.isNumber((String)articleId) || JournalArticleUtil.fetchByG_A_V((long)groupId, (String)articleId, (double)1.0) != null) {
            autoArticleId = true;
        }
        if (Validator.isNotNull((String)(newArticleId = articleIds.get(articleId)))) {
            articleId = newArticleId;
            autoArticleId = false;
        }
        boolean incrementVersion = false;
        String content = article.getContent();
        article.setContent(StringUtil.replace((String)content, (String)"@data_handler_group_id@", (String)String.valueOf(groupId)));
        String parentStructureId = MapUtil.getString(structureIds, (String)article.getStructureId(), (String)article.getStructureId());
        String parentTemplateId = MapUtil.getString(templateIds, (String)article.getTemplateId(), (String)article.getTemplateId());
        Date displayDate = article.getDisplayDate();
        int displayDateMonth = 0;
        int displayDateDay = 0;
        int displayDateYear = 0;
        int displayDateHour = 0;
        int displayDateMinute = 0;
        if (displayDate != null) {
            Calendar displayCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            displayCal.setTime(displayDate);
            displayDateMonth = displayCal.get(2);
            displayDateDay = displayCal.get(5);
            displayDateYear = displayCal.get(1);
            displayDateHour = displayCal.get(10);
            displayDateMinute = displayCal.get(12);
            if (displayCal.get(9) == 1) {
                displayDateHour += 12;
            }
        }
        Date expirationDate = article.getExpirationDate();
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            expirationCal.setTime(expirationDate);
            expirationDateMonth = expirationCal.get(2);
            expirationDateDay = expirationCal.get(5);
            expirationDateYear = expirationCal.get(1);
            expirationDateHour = expirationCal.get(10);
            expirationDateMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationDateHour += 12;
            }
        }
        Date reviewDate = article.getReviewDate();
        int reviewDateMonth = 0;
        int reviewDateDay = 0;
        int reviewDateYear = 0;
        int reviewDateHour = 0;
        int reviewDateMinute = 0;
        boolean neverReview = true;
        if (reviewDate != null) {
            Calendar reviewCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            reviewCal.setTime(reviewDate);
            reviewDateMonth = reviewCal.get(2);
            reviewDateDay = reviewCal.get(5);
            reviewDateYear = reviewCal.get(1);
            reviewDateHour = reviewCal.get(10);
            reviewDateMinute = reviewCal.get(12);
            neverReview = false;
            if (reviewCal.get(9) == 1) {
                reviewDateHour += 12;
            }
        }
        File smallFile = null;
        String smallImagePath = articleEl.attributeValue("small-image-path");
        if (article.isSmallImage() && Validator.isNotNull((String)smallImagePath)) {
            byte[] bytes = context.getZipEntryAsByteArray(smallImagePath);
            smallFile = File.createTempFile(String.valueOf(article.getSmallImageId()), "." + article.getSmallImageType());
            FileUtil.write((File)smallFile, (byte[])bytes);
        }
        HashMap<String, byte[]> images = new HashMap<String, byte[]>();
        if (context.getBooleanParameter(_NAMESPACE, "images")) {
            String imagePath = articleEl.attributeValue("image-path");
            List imageFiles = context.getZipFolderEntries(imagePath);
            for (String imageFile : imageFiles) {
                String fileName = imageFile;
                if (fileName.contains("/")) {
                    fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                }
                if (fileName.endsWith(".xml")) continue;
                int pos = fileName.lastIndexOf(".");
                if (pos != -1) {
                    fileName = fileName.substring(0, pos);
                }
                images.put(fileName, context.getZipEntryAsByteArray(imageFile));
            }
        }
        String articleURL = null;
        String[] tagsCategories = null;
        String[] tagsEntries = null;
        if (context.getBooleanParameter(_NAMESPACE, "categories")) {
            tagsCategories = context.getTagsCategories(JournalArticle.class, article.getResourcePrimKey());
        }
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            tagsEntries = context.getTagsEntries(JournalArticle.class, article.getResourcePrimKey());
        }
        if ((authorId = (creationStrategy = JournalCreationStrategyFactory.getInstance()).getAuthorUserId(context, article)) != 0L) {
            userId = authorId;
        }
        if ((newContent = creationStrategy.getTransformedContent(context, article)) != JournalCreationStrategy.ARTICLE_CONTENT_UNCHANGED) {
            article.setContent(newContent);
        }
        boolean addCommunityPermissions = creationStrategy.addCommunityPermissions(context, article);
        boolean addGuestPermissions = creationStrategy.addGuestPermissions(context, article);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(addCommunityPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        serviceContext.setTagsCategories(tagsCategories);
        serviceContext.setTagsEntries(tagsEntries);
        JournalArticle existingArticle = null;
        if (Validator.isNotNull((String)article.getStructureId()) && (structure = JournalStructureUtil.fetchByG_S((long)context.getGroupId(), (String)article.getStructureId())) == null) {
            String structurePath = JournalPortletDataHandlerImpl.getImportStructurePath(context, article.getStructureId());
            JournalPortletDataHandlerImpl.importStructure(context, structureIds, structurePath);
        }
        if (Validator.isNotNull((String)article.getTemplateId()) && (template = JournalTemplateUtil.fetchByG_T((long)context.getGroupId(), (String)article.getTemplateId())) == null) {
            String templatePath = JournalPortletDataHandlerImpl.getImportTemplatePath(context, article.getTemplateId());
            String templateSmallImagePath = JournalPortletDataHandlerImpl.getImportTemplateSmallImagePath(context, article.getTemplateId());
            JournalPortletDataHandlerImpl.importTemplate(context, structureIds, templateIds, templateSmallImagePath, templatePath);
        }
        existingArticle = context.getDataStrategy().equals("DATA_STRATEGY_MIRROR") ? ((existingArticle = JournalArticleUtil.fetchByUUID_G((String)article.getUuid(), (long)groupId)) == null ? JournalArticleLocalServiceUtil.addArticle((String)article.getUuid(), (long)userId, (long)groupId, (String)articleId, (boolean)autoArticleId, (double)article.getVersion(), (String)article.getTitle(), (String)article.getDescription(), (String)article.getContent(), (String)article.getType(), (String)parentStructureId, (String)parentTemplateId, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)article.getIndexable(), (boolean)article.getSmallImage(), (String)article.getSmallImageURL(), (File)smallFile, images, articleURL, (ServiceContext)serviceContext) : JournalArticleLocalServiceUtil.updateArticle((long)userId, (long)existingArticle.getGroupId(), (String)existingArticle.getArticleId(), (double)existingArticle.getVersion(), (boolean)incrementVersion, (String)article.getTitle(), (String)article.getDescription(), (String)article.getContent(), (String)article.getType(), (String)existingArticle.getStructureId(), (String)existingArticle.getTemplateId(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)article.getIndexable(), (boolean)article.getSmallImage(), (String)article.getSmallImageURL(), (File)smallFile, images, articleURL, (ServiceContext)serviceContext)) : JournalArticleLocalServiceUtil.addArticle((long)userId, (long)groupId, (String)articleId, (boolean)autoArticleId, (double)article.getVersion(), (String)article.getTitle(), (String)article.getDescription(), (String)article.getContent(), (String)article.getType(), (String)parentStructureId, (String)parentTemplateId, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)article.getIndexable(), (boolean)article.getSmallImage(), (String)article.getSmallImageURL(), (File)smallFile, images, articleURL, (ServiceContext)serviceContext);
        long strategyApprovalUserId = creationStrategy.getApprovalUserId(context, article);
        if (strategyApprovalUserId != 0L || article.isApproved() && !existingArticle.isApproved()) {
            long approvedByUserId = strategyApprovalUserId;
            if (approvedByUserId == 0L) {
                approvedByUserId = context.getUserId(article.getApprovedByUserUuid());
            }
            JournalArticleLocalServiceUtil.approveArticle((long)approvedByUserId, (long)groupId, (String)existingArticle.getArticleId(), (double)existingArticle.getVersion(), articleURL, (ServiceContext)serviceContext);
        }
        if (context.getBooleanParameter(_NAMESPACE, "comments")) {
            context.importComments(JournalArticle.class, article.getResourcePrimKey(), existingArticle.getResourcePrimKey(), groupId);
        }
        if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
            context.importRatingsEntries(JournalArticle.class, article.getResourcePrimKey(), existingArticle.getResourcePrimKey());
        }
        articleIds.put(articleId, existingArticle.getArticleId());
        if (!articleId.equals(existingArticle.getArticleId()) && _log.isWarnEnabled()) {
            _log.warn((Object)("An article with the ID " + articleId + " already " + "exists. The new generated ID is " + existingArticle.getArticleId()));
        }
    }

    public static void importFeed(PortletDataContext context, Map<String, String> structureIds, Map<String, String> templateIds, Map<String, String> feedIds, Element feedEl) throws Exception {
        String path = feedEl.attributeValue("path");
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        JournalFeed feed = (JournalFeed)context.getZipEntryAsObject(path);
        long userId = context.getUserId(feed.getUserUuid());
        long groupId = context.getGroupId();
        String feedId = feed.getFeedId();
        boolean autoFeedId = false;
        if (Validator.isNumber((String)feedId) || JournalFeedUtil.fetchByG_F((long)groupId, (String)feedId) != null) {
            autoFeedId = true;
        }
        String parentStructureId = MapUtil.getString(structureIds, (String)feed.getStructureId(), (String)feed.getStructureId());
        String parentTemplateId = MapUtil.getString(templateIds, (String)feed.getTemplateId(), (String)feed.getTemplateId());
        String parentRenderTemplateId = MapUtil.getString(templateIds, (String)feed.getRendererTemplateId(), (String)feed.getRendererTemplateId());
        JournalCreationStrategy creationStrategy = JournalCreationStrategyFactory.getInstance();
        long authorId = creationStrategy.getAuthorUserId(context, feed);
        if (authorId != 0L) {
            userId = authorId;
        }
        boolean addCommunityPermissions = creationStrategy.addCommunityPermissions(context, feed);
        boolean addGuestPermissions = creationStrategy.addGuestPermissions(context, feed);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(addCommunityPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        JournalFeed existingFeed = null;
        existingFeed = context.getDataStrategy().equals("DATA_STRATEGY_MIRROR") ? ((existingFeed = JournalFeedUtil.fetchByUUID_G((String)feed.getUuid(), (long)groupId)) == null ? JournalFeedLocalServiceUtil.addFeed((String)feed.getUuid(), (long)userId, (long)groupId, (String)feedId, (boolean)autoFeedId, (String)feed.getName(), (String)feed.getDescription(), (String)feed.getType(), (String)parentStructureId, (String)parentTemplateId, (String)parentRenderTemplateId, (int)feed.getDelta(), (String)feed.getOrderByCol(), (String)feed.getOrderByType(), (String)feed.getTargetLayoutFriendlyUrl(), (String)feed.getTargetPortletId(), (String)feed.getContentField(), (String)feed.getFeedType(), (double)feed.getFeedVersion(), (ServiceContext)serviceContext) : JournalFeedLocalServiceUtil.updateFeed((long)existingFeed.getGroupId(), (String)existingFeed.getFeedId(), (String)feed.getName(), (String)feed.getDescription(), (String)feed.getType(), (String)parentStructureId, (String)parentTemplateId, (String)parentRenderTemplateId, (int)feed.getDelta(), (String)feed.getOrderByCol(), (String)feed.getOrderByType(), (String)feed.getTargetLayoutFriendlyUrl(), (String)feed.getTargetPortletId(), (String)feed.getContentField(), (String)feed.getFeedType(), (double)feed.getFeedVersion(), (ServiceContext)serviceContext)) : JournalFeedLocalServiceUtil.addFeed((long)userId, (long)groupId, (String)feedId, (boolean)autoFeedId, (String)feed.getName(), (String)feed.getDescription(), (String)feed.getType(), (String)parentStructureId, (String)parentTemplateId, (String)parentRenderTemplateId, (int)feed.getDelta(), (String)feed.getOrderByCol(), (String)feed.getOrderByType(), (String)feed.getTargetLayoutFriendlyUrl(), (String)feed.getTargetPortletId(), (String)feed.getContentField(), (String)feed.getFeedType(), (double)feed.getFeedVersion(), (ServiceContext)serviceContext);
        feedIds.put(feedId, existingFeed.getFeedId());
        if (!feedId.equals(existingFeed.getStructureId()) && _log.isWarnEnabled()) {
            _log.warn((Object)("A feed with the ID " + feedId + " already " + "exists. The new generated ID is " + existingFeed.getFeedId()));
        }
    }

    public static void importStructure(PortletDataContext context, Map<String, String> structureIds, Element structureEl) throws Exception {
        String path = structureEl.attributeValue("path");
        JournalPortletDataHandlerImpl.importStructure(context, structureIds, path);
    }

    protected static void importStructure(PortletDataContext context, Map<String, String> structureIds, String path) throws Exception {
        JournalCreationStrategy creationStrategy;
        long authorId;
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        JournalStructure structure = (JournalStructure)context.getZipEntryAsObject(path);
        long userId = context.getUserId(structure.getUserUuid());
        long groupId = context.getGroupId();
        String structureId = structure.getStructureId();
        boolean autoStructureId = false;
        if (Validator.isNumber((String)structureId) || JournalStructureUtil.fetchByG_S((long)groupId, (String)structureId) != null) {
            autoStructureId = true;
        }
        if ((authorId = (creationStrategy = JournalCreationStrategyFactory.getInstance()).getAuthorUserId(context, structure)) != 0L) {
            userId = authorId;
        }
        boolean addCommunityPermissions = creationStrategy.addCommunityPermissions(context, structure);
        boolean addGuestPermissions = creationStrategy.addGuestPermissions(context, structure);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(addCommunityPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        JournalStructure existingStructure = null;
        existingStructure = context.getDataStrategy().equals("DATA_STRATEGY_MIRROR") ? ((existingStructure = JournalStructureUtil.fetchByUUID_G((String)structure.getUuid(), (long)groupId)) == null ? JournalStructureLocalServiceUtil.addStructure((String)structure.getUuid(), (long)userId, (long)groupId, (String)structureId, (boolean)autoStructureId, (String)structure.getParentStructureId(), (String)structure.getName(), (String)structure.getDescription(), (String)structure.getXsd(), (ServiceContext)serviceContext) : JournalStructureLocalServiceUtil.updateStructure((long)existingStructure.getGroupId(), (String)existingStructure.getStructureId(), (String)structure.getParentStructureId(), (String)structure.getName(), (String)structure.getDescription(), (String)structure.getXsd(), (ServiceContext)serviceContext)) : JournalStructureLocalServiceUtil.addStructure((long)userId, (long)groupId, (String)structureId, (boolean)autoStructureId, (String)structure.getParentStructureId(), (String)structure.getName(), (String)structure.getDescription(), (String)structure.getXsd(), (ServiceContext)serviceContext);
        structureIds.put(structureId, existingStructure.getStructureId());
        if (!structureId.equals(existingStructure.getStructureId()) && _log.isWarnEnabled()) {
            _log.warn((Object)("A structure with the ID " + structureId + " already " + "exists. The new generated ID is " + existingStructure.getStructureId()));
        }
    }

    public static void importTemplate(PortletDataContext context, Map<String, String> structureIds, Map<String, String> templateIds, Element templateEl) throws Exception {
        String path = templateEl.attributeValue("path");
        JournalPortletDataHandlerImpl.importTemplate(context, structureIds, templateIds, templateEl.attributeValue("small-image-path"), path);
    }

    protected static void importTemplate(PortletDataContext context, Map<String, String> structureIds, Map<String, String> templateIds, String smallImagePath, String path) throws Exception {
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        JournalTemplate template = (JournalTemplate)context.getZipEntryAsObject(path);
        long userId = context.getUserId(template.getUserUuid());
        long groupId = context.getGroupId();
        String templateId = template.getTemplateId();
        boolean autoTemplateId = false;
        if (Validator.isNumber((String)templateId) || JournalTemplateUtil.fetchByG_T((long)groupId, (String)templateId) != null) {
            autoTemplateId = true;
        }
        String parentStructureId = MapUtil.getString(structureIds, (String)template.getStructureId(), (String)template.getStructureId());
        boolean formatXsl = false;
        JournalCreationStrategy creationStrategy = JournalCreationStrategyFactory.getInstance();
        long authorId = creationStrategy.getAuthorUserId(context, template);
        if (authorId != 0L) {
            userId = authorId;
        }
        boolean addCommunityPermissions = creationStrategy.addCommunityPermissions(context, template);
        boolean addGuestPermissions = creationStrategy.addGuestPermissions(context, template);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(addCommunityPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        File smallFile = null;
        if (template.isSmallImage() && Validator.isNotNull((String)smallImagePath)) {
            byte[] bytes;
            if (smallImagePath.endsWith(".")) {
                smallImagePath = smallImagePath + template.getSmallImageType();
            }
            if ((bytes = context.getZipEntryAsByteArray(smallImagePath)) != null) {
                smallFile = File.createTempFile(String.valueOf(template.getSmallImageId()), "." + template.getSmallImageType());
                FileUtil.write((File)smallFile, (byte[])bytes);
            }
        }
        JournalTemplate existingTemplate = null;
        existingTemplate = context.getDataStrategy().equals("DATA_STRATEGY_MIRROR") ? ((existingTemplate = JournalTemplateUtil.fetchByUUID_G((String)template.getUuid(), (long)groupId)) == null ? JournalTemplateLocalServiceUtil.addTemplate((String)template.getUuid(), (long)userId, (long)groupId, (String)templateId, (boolean)autoTemplateId, (String)parentStructureId, (String)template.getName(), (String)template.getDescription(), (String)template.getXsl(), (boolean)formatXsl, (String)template.getLangType(), (boolean)template.getCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext) : JournalTemplateLocalServiceUtil.updateTemplate((long)existingTemplate.getGroupId(), (String)existingTemplate.getTemplateId(), (String)existingTemplate.getStructureId(), (String)template.getName(), (String)template.getDescription(), (String)template.getXsl(), (boolean)formatXsl, (String)template.getLangType(), (boolean)template.getCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext)) : JournalTemplateLocalServiceUtil.addTemplate((long)userId, (long)groupId, (String)templateId, (boolean)autoTemplateId, (String)parentStructureId, (String)template.getName(), (String)template.getDescription(), (String)template.getXsl(), (boolean)formatXsl, (String)template.getLangType(), (boolean)template.getCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
        templateIds.put(templateId, existingTemplate.getTemplateId());
        if (!templateId.equals(existingTemplate.getTemplateId()) && _log.isWarnEnabled()) {
            _log.warn((Object)("A template with the ID " + templateId + " already " + "exists. The new generated ID is " + existingTemplate.getTemplateId()));
        }
    }

    public PortletPreferences deleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            if (!context.addPrimaryKey(JournalPortletDataHandlerImpl.class, "deleteData")) {
                JournalArticleLocalServiceUtil.deleteArticles((long)context.getGroupId());
                JournalTemplateLocalServiceUtil.deleteTemplates((long)context.getGroupId());
                JournalStructureLocalServiceUtil.deleteStructures((long)context.getGroupId());
            }
            return preferences;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public String exportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("journal-data");
            root.addAttribute("group-id", String.valueOf(context.getGroupId()));
            Element structuresEl = root.addElement("structures");
            List structures = JournalStructureUtil.findByGroupId((long)context.getGroupId());
            for (JournalStructure structure : structures) {
                JournalPortletDataHandlerImpl.exportStructure(context, structuresEl, structure);
            }
            Element templatesEl = root.addElement("templates");
            Element dlFoldersEl = root.addElement("dl-folders");
            Element dlFilesEl = root.addElement("dl-file-entries");
            Element dlFileRanksEl = root.addElement("dl-file-ranks");
            Element igFoldersEl = root.addElement("ig-folders");
            Element igImagesEl = root.addElement("ig-images");
            List templates = JournalTemplateUtil.findByGroupId((long)context.getGroupId());
            for (JournalTemplate template : templates) {
                JournalPortletDataHandlerImpl.exportTemplate(context, templatesEl, dlFoldersEl, dlFilesEl, dlFileRanksEl, igFoldersEl, igImagesEl, template);
            }
            Element feedsEl = root.addElement("feeds");
            List feeds = JournalFeedUtil.findByGroupId((long)context.getGroupId());
            for (JournalFeed feed : feeds) {
                if (!context.isWithinDateRange(feed.getModifiedDate())) continue;
                JournalPortletDataHandlerImpl.exportFeed(context, feedsEl, feed);
            }
            Element articlesEl = root.addElement("articles");
            if (context.getBooleanParameter(_NAMESPACE, "articles")) {
                List articles = JournalArticleUtil.findByGroupId((long)context.getGroupId());
                for (JournalArticle article : articles) {
                    JournalPortletDataHandlerImpl.exportArticle(context, articlesEl, dlFoldersEl, dlFilesEl, dlFileRanksEl, igFoldersEl, igImagesEl, article);
                }
            }
            return doc.formattedString();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_articles, _structuresTemplatesAndFeeds, _embeddedAssets, _images, _categories, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_articles, _structuresTemplatesAndFeeds, _images, _categories, _comments, _ratings, _tags};
    }

    public PortletPreferences importData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.read((String)data);
            Element root = doc.getRootElement();
            List structureEls = root.element("structures").elements("structure");
            Map structureIds = context.getNewPrimaryKeysMap(JournalStructure.class);
            for (Element structureEl : structureEls) {
                JournalPortletDataHandlerImpl.importStructure(context, (Map<String, String>)structureIds, structureEl);
            }
            List templateEls = root.element("templates").elements("template");
            Map templateIds = context.getNewPrimaryKeysMap(JournalTemplate.class);
            for (Element templateEl : templateEls) {
                JournalPortletDataHandlerImpl.importTemplate(context, structureIds, templateIds, templateEl);
            }
            List feedEls = root.element("feeds").elements("feed");
            Map feedIds = context.getNewPrimaryKeysMap(JournalFeed.class);
            for (Element feedEl : feedEls) {
                JournalPortletDataHandlerImpl.importFeed(context, structureIds, templateIds, feedIds, feedEl);
            }
            if (context.getBooleanParameter(_NAMESPACE, "articles")) {
                List articleEls = root.element("articles").elements("article");
                Map articleIds = context.getNewPrimaryKeysMap(JournalArticle.class);
                for (Element articleEl : articleEls) {
                    JournalPortletDataHandlerImpl.importArticle(context, structureIds, templateIds, articleIds, articleEl);
                }
            }
            List dlFolderEls = root.element("dl-folders").elements("folder");
            Map dlFolderPKs = context.getNewPrimaryKeysMap(DLFolder.class);
            for (Element folderEl : dlFolderEls) {
                String path = folderEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                DLFolder folder = (DLFolder)context.getZipEntryAsObject(path);
                DLPortletDataHandlerImpl.importFolder(context, dlFolderPKs, folder);
            }
            List fileEntryEls = root.element("dl-file-entries").elements("file-entry");
            Map fileEntryNames = context.getNewPrimaryKeysMap(DLFileEntry.class);
            for (Element fileEntryEl : fileEntryEls) {
                String path = fileEntryEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                DLFileEntry fileEntry = null;
                try {
                    fileEntry = (DLFileEntry)context.getZipEntryAsObject(path);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("No file entry found for path " + path));
                    continue;
                }
                String binPath = fileEntryEl.attributeValue("bin-path");
                DLPortletDataHandlerImpl.importFileEntry(context, dlFolderPKs, fileEntryNames, fileEntry, binPath);
            }
            List fileRankEls = root.element("dl-file-ranks").elements("file-rank");
            for (Element fileRankEl : fileRankEls) {
                String path = fileRankEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                DLFileRank fileRank = (DLFileRank)context.getZipEntryAsObject(path);
                DLPortletDataHandlerImpl.importFileRank(context, dlFolderPKs, fileEntryNames, fileRank);
            }
            List igFolderEls = root.element("ig-folders").elements("folder");
            Map igFolderPKs = context.getNewPrimaryKeysMap(IGFolder.class);
            for (Element folderEl : igFolderEls) {
                String path = folderEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                IGFolder folder = (IGFolder)context.getZipEntryAsObject(path);
                IGPortletDataHandlerImpl.importFolder(context, igFolderPKs, folder);
            }
            List imageEls = root.element("ig-images").elements("image");
            for (Element imageEl : imageEls) {
                String path = imageEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                IGImage image = (IGImage)context.getZipEntryAsObject(path);
                String binPath = imageEl.attributeValue("bin-path");
                IGPortletDataHandlerImpl.importImage(context, igFolderPKs, image, binPath);
            }
            return preferences;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    public boolean isPublishToLiveByDefault() {
        return PropsValues.JOURNAL_PUBLISH_TO_LIVE_BY_DEFAULT;
    }

    protected static String getArticlePath(PortletDataContext context, JournalArticle article) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("15"));
        sb.append("/articles/");
        sb.append(article.getArticleId());
        sb.append("/");
        sb.append(article.getVersion());
        sb.append("/");
        sb.append(article.getArticleId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getArticleImagePath(PortletDataContext context, JournalArticle article) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("15"));
        sb.append("/articles/");
        sb.append(article.getArticleId());
        sb.append("/");
        sb.append(article.getVersion());
        sb.append("/");
        return sb.toString();
    }

    protected static String getArticleImagePath(PortletDataContext context, JournalArticle article, JournalArticleImage articleImage, Image image) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("15"));
        sb.append("/articles/");
        sb.append(article.getArticleId());
        sb.append("/");
        sb.append(article.getVersion());
        sb.append("/");
        sb.append(articleImage.getElInstanceId());
        sb.append("_");
        sb.append(articleImage.getElName());
        if (Validator.isNotNull((String)articleImage.getLanguageId())) {
            sb.append("_");
            sb.append(articleImage.getLanguageId());
        }
        sb.append(".");
        sb.append(image.getType());
        return sb.toString();
    }

    protected static String getArticleSmallImagePath(PortletDataContext context, JournalArticle article) throws PortalException, SystemException {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("15"));
        sb.append("/articles/");
        sb.append(article.getArticleId());
        sb.append("/thumbnail");
        sb.append(".");
        sb.append(article.getSmallImageType());
        return sb.toString();
    }

    protected static String getFeedPath(PortletDataContext context, JournalFeed feed) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("15"));
        sb.append("/feeds/");
        sb.append(feed.getFeedId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getImportStructurePath(PortletDataContext context, String structureId) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getSourcePortletPath("15"));
        sb.append("/structures/");
        sb.append(structureId);
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getImportTemplatePath(PortletDataContext context, String templateId) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getSourcePortletPath("15"));
        sb.append("/templates/");
        sb.append(templateId);
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getImportTemplateSmallImagePath(PortletDataContext context, String templateId) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getSourcePortletPath("15"));
        sb.append("/templates/thumbnail-");
        sb.append(templateId);
        sb.append(".");
        return sb.toString();
    }

    protected static String getTemplatePath(PortletDataContext context, JournalTemplate template) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("15"));
        sb.append("/templates/");
        sb.append(template.getTemplateId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getTemplateSmallImagePath(PortletDataContext context, JournalTemplate template) throws PortalException, SystemException {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("15"));
        sb.append("/templates/thumbnail-");
        sb.append(template.getTemplateId());
        sb.append(".");
        sb.append(template.getSmallImageType());
        return sb.toString();
    }

    protected static String getStructurePath(PortletDataContext context, JournalStructure structure) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("15"));
        sb.append("/structures/");
        sb.append(structure.getStructureId());
        sb.append(".xml");
        return sb.toString();
    }
}

