/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.base.JournalArticleServiceBaseImpl;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import java.io.File;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalArticleServiceImpl
extends JournalArticleServiceBaseImpl {
    public JournalArticle addArticle(long groupId, String articleId, boolean autoArticleId, String title, String description, String content, String type, String structureId, String templateId, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_ARTICLE");
        return this.journalArticleLocalService.addArticle(this.getUserId(), groupId, articleId, autoArticleId, title, description, content, type, structureId, templateId, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, false, null, null, null, articleURL, serviceContext);
    }

    public JournalArticle addArticle(long groupId, String articleId, boolean autoArticleId, String title, String description, String content, String type, String structureId, String templateId, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_ARTICLE");
        return this.journalArticleLocalService.addArticle(this.getUserId(), groupId, articleId, autoArticleId, title, description, content, type, structureId, templateId, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, smallImage, smallImageURL, smallFile, images, articleURL, serviceContext);
    }

    public JournalArticle approveArticle(long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.getUser();
        JournalPermission.check(this.getPermissionChecker(), groupId, "APPROVE_ARTICLE");
        return this.journalArticleLocalService.approveArticle(user.getUserId(), groupId, articleId, version, articleURL, serviceContext);
    }

    public JournalArticle copyArticle(long groupId, String oldArticleId, String newArticleId, boolean autoArticleId, double version) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_ARTICLE");
        return this.journalArticleLocalService.copyArticle(this.getUserId(), groupId, oldArticleId, newArticleId, autoArticleId, version);
    }

    public JournalArticle getArticle(long groupId, String articleId) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "VIEW");
        return this.journalArticleLocalService.getArticle(groupId, articleId);
    }

    public JournalArticle getArticle(long groupId, String articleId, double version) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "VIEW");
        return this.journalArticleLocalService.getArticle(groupId, articleId, version);
    }

    public JournalArticle getArticleByUrlTitle(long groupId, String urlTitle) throws PortalException, SystemException {
        JournalArticle article = this.journalArticleLocalService.getArticleByUrlTitle(groupId, urlTitle);
        JournalArticlePermission.check(this.getPermissionChecker(), article, "VIEW");
        return article;
    }

    public String getArticleContent(long groupId, String articleId, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "VIEW");
        return this.journalArticleLocalService.getArticleContent(groupId, articleId, null, languageId, themeDisplay);
    }

    public String getArticleContent(long groupId, String articleId, double version, String languageId, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "VIEW");
        return this.journalArticleLocalService.getArticleContent(groupId, articleId, version, null, languageId, themeDisplay);
    }

    public void deleteArticle(long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "DELETE");
        this.journalArticleLocalService.deleteArticle(groupId, articleId, version, articleURL, serviceContext);
    }

    public void expireArticle(long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "EXPIRE");
        this.journalArticleLocalService.expireArticle(groupId, articleId, version, articleURL, serviceContext);
    }

    public void removeArticleLocale(long companyId, String languageId) throws PortalException, SystemException {
        for (JournalArticle article : this.journalArticlePersistence.findByCompanyId(companyId)) {
            this.removeArticleLocale(article.getGroupId(), article.getArticleId(), article.getVersion(), languageId);
        }
    }

    public JournalArticle removeArticleLocale(long groupId, String articleId, double version, String languageId) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "UPDATE");
        return this.journalArticleLocalService.removeArticleLocale(groupId, articleId, version, languageId);
    }

    public JournalArticle updateArticle(long groupId, String articleId, double version, boolean incrementVersion, String content) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "UPDATE");
        return this.journalArticleLocalService.updateArticle(this.getUserId(), groupId, articleId, version, incrementVersion, content);
    }

    public JournalArticle updateArticle(long groupId, String articleId, double version, boolean incrementVersion, String title, String description, String content, String type, String structureId, String templateId, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "UPDATE");
        return this.journalArticleLocalService.updateArticle(this.getUserId(), groupId, articleId, version, incrementVersion, title, description, content, type, structureId, templateId, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, smallImage, smallImageURL, smallFile, images, articleURL, serviceContext);
    }

    public JournalArticle updateContent(long groupId, String articleId, double version, String content) throws PortalException, SystemException {
        JournalArticlePermission.check(this.getPermissionChecker(), groupId, articleId, "UPDATE");
        return this.journalArticleLocalService.updateContent(groupId, articleId, version, content);
    }
}

