/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.base.JournalStructureServiceBaseImpl;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import com.liferay.portlet.journal.service.permission.JournalStructurePermission;

public class JournalStructureServiceImpl
extends JournalStructureServiceBaseImpl {
    public JournalStructure addStructure(long groupId, String structureId, boolean autoStructureId, String parentStructureId, String name, String description, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_STRUCTURE");
        return this.journalStructureLocalService.addStructure(this.getUserId(), groupId, structureId, autoStructureId, parentStructureId, name, description, xsd, serviceContext);
    }

    public JournalStructure copyStructure(long groupId, String oldStructureId, String newStructureId, boolean autoStructureId) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_STRUCTURE");
        return this.journalStructureLocalService.copyStructure(this.getUserId(), groupId, oldStructureId, newStructureId, autoStructureId);
    }

    public void deleteStructure(long groupId, String structureId) throws PortalException, SystemException {
        JournalStructurePermission.check(this.getPermissionChecker(), groupId, structureId, "DELETE");
        this.journalStructureLocalService.deleteStructure(groupId, structureId);
    }

    public JournalStructure getStructure(long groupId, String structureId) throws PortalException, SystemException {
        JournalStructurePermission.check(this.getPermissionChecker(), groupId, structureId, "VIEW");
        return this.journalStructureLocalService.getStructure(groupId, structureId);
    }

    public JournalStructure updateStructure(long groupId, String structureId, String parentStructureId, String name, String description, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalStructurePermission.check(this.getPermissionChecker(), groupId, structureId, "UPDATE");
        return this.journalStructureLocalService.updateStructure(groupId, structureId, parentStructureId, name, description, xsd, serviceContext);
    }
}

