/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.base.JournalTemplateServiceBaseImpl;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import com.liferay.portlet.journal.service.permission.JournalStructurePermission;
import com.liferay.portlet.journal.service.permission.JournalTemplatePermission;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalTemplateServiceImpl
extends JournalTemplateServiceBaseImpl {
    public JournalTemplate addTemplate(long groupId, String templateId, boolean autoTemplateId, String structureId, String name, String description, String xsl, boolean formatXsl, String langType, boolean cacheable, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_TEMPLATE");
        return this.journalTemplateLocalService.addTemplate(this.getUserId(), groupId, templateId, autoTemplateId, structureId, name, description, xsl, formatXsl, langType, cacheable, false, null, null, serviceContext);
    }

    public JournalTemplate addTemplate(long groupId, String templateId, boolean autoTemplateId, String structureId, String name, String description, String xsl, boolean formatXsl, String langType, boolean cacheable, boolean smallImage, String smallImageURL, File smallFile, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_TEMPLATE");
        return this.journalTemplateLocalService.addTemplate(this.getUserId(), groupId, templateId, autoTemplateId, structureId, name, description, xsl, formatXsl, langType, cacheable, smallImage, smallImageURL, smallFile, serviceContext);
    }

    public JournalTemplate copyTemplate(long groupId, String oldTemplateId, String newTemplateId, boolean autoTemplateId) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_TEMPLATE");
        return this.journalTemplateLocalService.copyTemplate(this.getUserId(), groupId, oldTemplateId, newTemplateId, autoTemplateId);
    }

    public void deleteTemplate(long groupId, String templateId) throws PortalException, SystemException {
        JournalTemplatePermission.check(this.getPermissionChecker(), groupId, templateId, "DELETE");
        this.journalTemplateLocalService.deleteTemplate(groupId, templateId);
    }

    public List<JournalTemplate> getStructureTemplates(long groupId, String structureId) throws PortalException, SystemException {
        if (!JournalStructurePermission.contains(this.getPermissionChecker(), groupId, structureId, "VIEW")) {
            return new ArrayList<JournalTemplate>();
        }
        List list = this.journalTemplateLocalService.getStructureTemplates(groupId, structureId);
        list = ListUtil.copy((List)list);
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            JournalTemplate template = (JournalTemplate)itr.next();
            if (JournalTemplatePermission.contains(this.getPermissionChecker(), template, "VIEW")) continue;
            itr.remove();
        }
        return list;
    }

    public JournalTemplate getTemplate(long groupId, String templateId) throws PortalException, SystemException {
        JournalTemplatePermission.check(this.getPermissionChecker(), groupId, templateId, "VIEW");
        return this.journalTemplateLocalService.getTemplate(groupId, templateId);
    }

    public JournalTemplate updateTemplate(long groupId, String templateId, String structureId, String name, String description, String xsl, boolean formatXsl, String langType, boolean cacheable, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalTemplatePermission.check(this.getPermissionChecker(), groupId, templateId, "UPDATE");
        return this.journalTemplateLocalService.updateTemplate(groupId, templateId, structureId, name, description, xsl, formatXsl, langType, cacheable, false, null, null, serviceContext);
    }

    public JournalTemplate updateTemplate(long groupId, String templateId, String structureId, String name, String description, String xsl, boolean formatXsl, String langType, boolean cacheable, boolean smallImage, String smallImageURL, File smallFile, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalTemplatePermission.check(this.getPermissionChecker(), groupId, templateId, "UPDATE");
        return this.journalTemplateLocalService.updateTemplate(groupId, templateId, structureId, name, description, xsl, formatXsl, langType, cacheable, smallImage, smallImageURL, smallFile, serviceContext);
    }
}

