/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.portlet.journal.util.TransformerListener;
import java.util.Map;

public class ContentTransformerListener
extends TransformerListener {
    private static Log _log = LogFactoryUtil.getLog(ContentTransformerListener.class);

    public String onXml(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onXml");
        }
        s = this.replace(s);
        return s;
    }

    public String onScript(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onScript");
        }
        return s;
    }

    public String onOutput(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onOutput");
        }
        return s;
    }

    protected String replace(String xml) {
        try {
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            this.replace(root);
            xml = JournalUtil.formatXML(doc);
        }
        catch (Exception e) {
            _log.warn((Object)e.getMessage());
        }
        return xml;
    }

    protected void replace(Element root) throws Exception {
        Map<String, String> tokens = this.getTokens();
        long groupId = GetterUtil.getLong((String)tokens.get("group_id"));
        for (Element el : root.elements()) {
            Element dynamicContent = el.element("dynamic-content");
            if (dynamicContent != null) {
                String text = dynamicContent.getText();
                text = HtmlUtil.stripComments((String)text);
                text = HtmlUtil.stripHtml((String)text);
                if (Validator.isNotNull((String)(text = text.trim())) && text.length() >= 7 && text.startsWith("[@") && text.endsWith("@]")) {
                    int pos = (text = text.substring(2, text.length() - 2)).indexOf(";");
                    if (pos != -1) {
                        String articleId = text.substring(0, pos);
                        String elementName = text.substring(pos + 1, text.length());
                        JournalArticle article = JournalArticleLocalServiceUtil.getArticle((long)groupId, (String)articleId);
                        dynamicContent.clearContent();
                        dynamicContent.addCDATA(this._getDynamicContent(article.getContent(), elementName));
                    }
                } else if (text != null && text.startsWith("/image/journal/article?img_id")) {
                    dynamicContent.setText("@cdn_host@@root_path@" + text);
                }
            }
            this.replace(el);
        }
    }

    private String _getDynamicContent(String xml, String elementName) {
        String content = null;
        try {
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            for (Element el : root.elements()) {
                String elName = el.attributeValue("name", "");
                if (!elName.equals(elementName)) continue;
                content = el.elementText("dynamic-content");
                break;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return GetterUtil.getString(content);
    }
}

