/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.DocumentSummary;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;

public class Indexer
implements com.liferay.portal.kernel.search.Indexer {
    public static final String PORTLET_ID = "15";
    private static final String[] _CLASS_NAMES = new String[]{JournalArticle.class.getName()};

    public static void addArticle(long companyId, long groupId, long resourcePrimKey, String articleId, double version, String title, String description, String content, String type, Date displayDate, String[] tagsCategories, String[] tagsEntries, ExpandoBridge expandoBridge) throws SearchException {
        Document doc = Indexer.getArticleDocument(companyId, groupId, resourcePrimKey, articleId, version, title, description, content, type, displayDate, tagsCategories, tagsEntries, expandoBridge);
        SearchEngineUtil.addDocument((long)companyId, (Document)doc);
    }

    public static void deleteArticle(long companyId, long groupId, String articleId) throws SearchException {
        SearchEngineUtil.deleteDocument((long)companyId, (String)Indexer.getArticleUID(groupId, articleId));
    }

    public static Document getArticleDocument(long companyId, long groupId, long resourcePrimKey, String articleId, double version, String title, String description, String content, String type, Date displayDate, String[] tagsCategories, String[] tagsEntries, ExpandoBridge expandoBridge) {
        DocumentImpl doc = new DocumentImpl();
        if (content != null && (content.indexOf("<dynamic-content") != -1 || content.indexOf("<static-content") != -1)) {
            content = Indexer._getIndexableContent((Document)doc, content);
            content = StringUtil.replace((String)content, (String)"<![CDATA[", (String)"");
            content = StringUtil.replace((String)content, (String)"]]>", (String)"");
        }
        content = StringUtil.replace((String)content, (String)"&amp;", (String)"&");
        content = StringUtil.replace((String)content, (String)"&lt;", (String)"<");
        content = StringUtil.replace((String)content, (String)"&gt;", (String)">");
        content = HtmlUtil.extractText((String)content);
        doc.addUID(PORTLET_ID, groupId, articleId);
        doc.addModifiedDate(displayDate);
        doc.addKeyword("companyId", companyId);
        doc.addKeyword("portletId", PORTLET_ID);
        doc.addKeyword("groupId", groupId);
        doc.addText("title", title);
        doc.addText("content", content);
        doc.addText("description", description);
        doc.addKeyword("tagsCategories", tagsCategories);
        doc.addKeyword("tagsEntries", tagsEntries);
        doc.addKeyword("entryClassName", JournalArticle.class.getName());
        doc.addKeyword("entryClassPK", articleId);
        doc.addKeyword("rootEntryClassPK", resourcePrimKey);
        doc.addKeyword("version", version);
        doc.addKeyword("type", type);
        ExpandoBridgeIndexerUtil.addAttributes((Document)doc, (ExpandoBridge)expandoBridge);
        return doc;
    }

    public static String getArticleUID(long groupId, String articleId) {
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, groupId, articleId);
        return doc.get("uid");
    }

    public static void updateArticle(long companyId, long groupId, long resourcePrimKey, String articleId, double version, String title, String description, String content, String type, Date displayDate, String[] tagsCategories, String[] tagsEntries, ExpandoBridge expandoBridge) throws SearchException {
        Document doc = Indexer.getArticleDocument(companyId, groupId, resourcePrimKey, articleId, version, title, description, content, type, displayDate, tagsCategories, tagsEntries, expandoBridge);
        SearchEngineUtil.updateDocument((long)companyId, (String)doc.get("uid"), (Document)doc);
    }

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    public DocumentSummary getDocumentSummary(Document doc, String snippet, PortletURL portletURL) {
        String title = doc.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)doc.get("content"), (int)200);
        }
        String groupId = doc.get("groupId");
        String articleId = doc.get("entryClassPK");
        String version = doc.get("version");
        portletURL.setParameter("struts_action", "/journal/edit_article");
        portletURL.setParameter("groupId", groupId);
        portletURL.setParameter("articleId", articleId);
        portletURL.setParameter("version", version);
        return new DocumentSummary(title, content, portletURL);
    }

    public void reIndex(String className, long classPK) throws SearchException {
        try {
            JournalArticleLocalServiceUtil.reIndex((long)classPK);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void reIndex(String[] ids) throws SearchException {
        try {
            JournalArticleLocalServiceUtil.reIndex((String[])ids);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    private static String _getIndexableContent(Document doc, String content) {
        try {
            StringBuilder sb = new StringBuilder();
            com.liferay.portal.kernel.xml.Document contentDoc = SAXReaderUtil.read((String)content);
            Element root = contentDoc.getRootElement();
            Indexer._getIndexableContent(sb, doc, root);
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return content;
        }
    }

    private static void _getIndexableContent(StringBuilder sb, Document doc, Element root) throws Exception {
        for (Element el : root.elements()) {
            String elType = el.attributeValue("type", "");
            String elIndexType = el.attributeValue("index-type", "");
            Indexer._indexField(doc, el, elType, elIndexType);
            if (elType.equals("text") || elType.equals("text_box") || elType.equals("text_area")) {
                for (Element dynamicContent : el.elements("dynamic-content")) {
                    String text = dynamicContent.getText();
                    sb.append(text);
                    sb.append(" ");
                }
            } else if (el.getName().equals("static-content")) {
                String text = el.getText();
                sb.append(text);
                sb.append(" ");
            }
            Indexer._getIndexableContent(sb, doc, el);
        }
    }

    private static void _indexField(Document doc, Element el, String elType, String elIndexType) {
        if (Validator.isNull((String)elIndexType)) {
            return;
        }
        Element dynamicContent = el.element("dynamic-content");
        String name = el.attributeValue("name", "");
        Object[] value = new String[]{dynamicContent.getText()};
        if (elType.equals("multi-list")) {
            List options = dynamicContent.elements();
            value = new String[options.size()];
            for (int i = 0; i < options.size(); ++i) {
                value[i] = ((Element)options.get(i)).getText();
            }
        }
        if (elIndexType.equals("keyword")) {
            doc.addKeyword(name, (String[])value);
        } else if (elIndexType.equals("text")) {
            doc.addText(name, StringUtil.merge((Object[])value, (String)" "));
        }
    }
}

