/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.model.Layout;
import com.liferay.portal.search.HitsOpenSearchImpl;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.journal.model.JournalContentSearch;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import java.util.List;
import javax.portlet.PortletURL;

public class JournalOpenSearchImpl
extends HitsOpenSearchImpl {
    public static final String SEARCH_PATH = "/c/journal/open_search";
    public static final String TITLE = "Liferay Journal Search: ";

    public Hits getHits(long companyId, long groupId, long userId, String keywords, int start, int end) throws Exception {
        return JournalArticleLocalServiceUtil.search((long)companyId, (long)groupId, (long)userId, (String)keywords, (int)start, (int)end);
    }

    public String getSearchPath() {
        return SEARCH_PATH;
    }

    public String getTitle(String keywords) {
        return TITLE + keywords;
    }

    protected String getLayoutURL(ThemeDisplay themeDisplay, String articleId) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        List contentSearches = JournalContentSearchLocalServiceUtil.getArticleContentSearches((String)articleId);
        for (JournalContentSearch contentSearch : contentSearches) {
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)contentSearch.getGroupId(), (boolean)contentSearch.isPrivateLayout(), (long)contentSearch.getLayoutId(), (String)"VIEW") || contentSearch.isPrivateLayout() && !GroupLocalServiceUtil.hasUserGroup((long)themeDisplay.getUserId(), (long)contentSearch.getGroupId())) continue;
            Layout hitLayout = LayoutLocalServiceUtil.getLayout((long)contentSearch.getGroupId(), (boolean)contentSearch.isPrivateLayout(), (long)contentSearch.getLayoutId());
            return PortalUtil.getLayoutURL((Layout)hitLayout, (ThemeDisplay)themeDisplay);
        }
        return null;
    }

    protected String getURL(ThemeDisplay themeDisplay, long groupId, Document result, PortletURL portletURL) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        Layout layout = themeDisplay.getLayout();
        String articleId = result.get("entryClassPK");
        String version = result.get("version");
        List hitLayoutIds = JournalContentSearchLocalServiceUtil.getLayoutIds((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (String)articleId);
        for (Long hitLayoutId : hitLayoutIds) {
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)hitLayoutId, (String)"VIEW")) continue;
            Layout hitLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)hitLayoutId);
            return PortalUtil.getLayoutURL((Layout)hitLayout, (ThemeDisplay)themeDisplay);
        }
        String layoutURL = this.getLayoutURL(themeDisplay, articleId);
        if (layoutURL != null) {
            return layoutURL;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(themeDisplay.getPathMain());
        sb.append("/journal/view_article_content?groupId=");
        sb.append(groupId);
        sb.append("&articleId=");
        sb.append(articleId);
        sb.append("&version=");
        sb.append(version);
        return sb.toString();
    }
}

