/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.FriendlyURLNormalizer;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.journal.TransformException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalArticleImageLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalTemplateLocalServiceUtil;
import com.liferay.portlet.journal.util.TemplateParser;
import com.liferay.portlet.journal.util.TransformerListener;
import com.liferay.portlet.journal.util.comparator.ArticleCreateDateComparator;
import com.liferay.portlet.journal.util.comparator.ArticleDisplayDateComparator;
import com.liferay.portlet.journal.util.comparator.ArticleIDComparator;
import com.liferay.portlet.journal.util.comparator.ArticleModifiedDateComparator;
import com.liferay.portlet.journal.util.comparator.ArticleReviewDateComparator;
import com.liferay.portlet.journal.util.comparator.ArticleTitleComparator;
import com.liferay.portlet.journal.util.comparator.ArticleVersionComparator;
import com.liferay.portlet.tags.service.TagsEntryLocalServiceUtil;
import com.liferay.util.FiniteUniqueStack;
import com.liferay.util.LocalizationUtil;
import com.liferay.util.xml.XMLFormatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalUtil {
    public static final int MAX_STACK_SIZE = 20;
    public static final String XML_INDENT = "  ";
    private static final char[] _URL_TITLE_REPLACE_CHARS = new char[]{'.', '/'};
    private static Log _log = LogFactoryUtil.getLog(JournalUtil.class);
    private static Log _logOutputAfterListener = LogFactoryUtil.getLog((String)(JournalUtil.class.getName() + ".OutputAfterListener"));
    private static Log _logOutputBeforeListener = LogFactoryUtil.getLog((String)(JournalUtil.class.getName() + ".OutputBeforeListener"));
    private static Log _logScriptAfterListener = LogFactoryUtil.getLog((String)(JournalUtil.class.getName() + ".ScriptAfterListener"));
    private static Log _logScriptBeforeListener = LogFactoryUtil.getLog((String)(JournalUtil.class.getName() + ".ScriptBeforeListener"));
    private static Log _logTransfromAfter = LogFactoryUtil.getLog((String)(JournalUtil.class.getName() + ".TransformAfter"));
    private static Log _logTransformBefore = LogFactoryUtil.getLog((String)(JournalUtil.class.getName() + ".BeforeTransform"));
    private static Log _logTokens = LogFactoryUtil.getLog((String)(JournalUtil.class.getName() + ".Tokens"));
    private static Log _logXmlAfterListener = LogFactoryUtil.getLog((String)(JournalUtil.class.getName() + ".XmlAfterListener"));
    private static Log _logXmlBeforeListener = LogFactoryUtil.getLog((String)(JournalUtil.class.getName() + ".XmlBeforeListener"));

    public static void addRecentArticle(PortletRequest portletRequest, JournalArticle article) {
        if (article != null) {
            Stack<JournalArticle> stack = JournalUtil.getRecentArticles(portletRequest);
            stack.push(article);
        }
    }

    public static void addRecentStructure(PortletRequest portletRequest, JournalStructure structure) {
        if (structure != null) {
            Stack<JournalStructure> stack = JournalUtil.getRecentStructures(portletRequest);
            stack.push(structure);
        }
    }

    public static void addRecentTemplate(PortletRequest portletRequest, JournalTemplate template) {
        if (template != null) {
            Stack<JournalTemplate> stack = JournalUtil.getRecentTemplates(portletRequest);
            stack.push(template);
        }
    }

    public static void addReservedEl(Element root, Map<String, String> tokens, String name, double value) {
        JournalUtil.addReservedEl(root, tokens, name, String.valueOf(value));
    }

    public static void addReservedEl(Element root, Map<String, String> tokens, String name, Date value) {
        JournalUtil.addReservedEl(root, tokens, name, Time.getRFC822((Date)value));
    }

    public static void addReservedEl(Element root, Map<String, String> tokens, String name, String value) {
        if (root != null) {
            Element dynamicEl = SAXReaderUtil.createElement((String)"dynamic-element");
            dynamicEl.add(SAXReaderUtil.createAttribute((Element)dynamicEl, (String)"name", (String)name));
            dynamicEl.add(SAXReaderUtil.createAttribute((Element)dynamicEl, (String)"type", (String)"text"));
            Element dynamicContent = SAXReaderUtil.createElement((String)"dynamic-content");
            dynamicContent.setText(value);
            dynamicEl.add(dynamicContent);
            root.add(dynamicEl);
        }
        tokens.put(StringUtil.replace((String)name, (String)"-", (String)"_"), value);
    }

    public static void addAllReservedEls(Element root, Map<String, String> tokens, JournalArticle article) {
        JournalUtil.addReservedEl(root, tokens, "reserved-article-id", article.getArticleId());
        JournalUtil.addReservedEl(root, tokens, "reserved-article-version", article.getVersion());
        JournalUtil.addReservedEl(root, tokens, "reserved-article-title", article.getTitle());
        JournalUtil.addReservedEl(root, tokens, "reserved-article-url-title", article.getUrlTitle());
        JournalUtil.addReservedEl(root, tokens, "reserved-article-description", article.getDescription());
        JournalUtil.addReservedEl(root, tokens, "reserved-article-type", article.getType());
        JournalUtil.addReservedEl(root, tokens, "reserved-article-create-date", article.getCreateDate());
        JournalUtil.addReservedEl(root, tokens, "reserved-article-modified-date", article.getModifiedDate());
        if (article.getDisplayDate() != null) {
            JournalUtil.addReservedEl(root, tokens, "reserved-article-display-date", article.getDisplayDate());
        }
        JournalUtil.addReservedEl(root, tokens, "reserved-article-small-image-url", article.getSmallImageURL());
        Object[] tagsEntries = new String[]{};
        try {
            tagsEntries = TagsEntryLocalServiceUtil.getEntryNames((String)JournalArticle.class.getName(), (long)article.getResourcePrimKey());
        }
        catch (SystemException se) {
            // empty catch block
        }
        JournalUtil.addReservedEl(root, tokens, "reserved-article-asset-tag-names", StringUtil.merge((Object[])tagsEntries));
        JournalUtil.addReservedEl(root, tokens, "reserved-article-author-id", String.valueOf(article.getUserId()));
        String userName = "";
        String userEmailAddress = "";
        String userComments = "";
        String userJobTitle = "";
        User user = null;
        try {
            user = UserLocalServiceUtil.getUserById((long)article.getUserId());
            userName = user.getFullName();
            userEmailAddress = user.getEmailAddress();
            userComments = user.getComments();
            userJobTitle = user.getJobTitle();
        }
        catch (PortalException pe) {
        }
        catch (SystemException se) {
            // empty catch block
        }
        JournalUtil.addReservedEl(root, tokens, "reserved-article-author-name", userName);
        JournalUtil.addReservedEl(root, tokens, "reserved-article-author-email-address", userEmailAddress);
        JournalUtil.addReservedEl(root, tokens, "reserved-article-author-comments", userComments);
        JournalUtil.addReservedEl(root, tokens, "reserved-article-author-job-title", userJobTitle);
    }

    public static String formatVM(String vm) {
        return vm;
    }

    public static String formatXML(String xml) throws DocumentException, IOException {
        xml = StringUtil.replace((String)xml, (String)"&#", (String)"[$SPECIAL_CHARACTER$]");
        xml = XMLFormatter.toString((String)xml, (String)XML_INDENT);
        xml = StringUtil.replace((String)xml, (String)"[$SPECIAL_CHARACTER$]", (String)"&#");
        return xml;
    }

    public static String formatXML(Document doc) throws IOException {
        return doc.formattedString(XML_INDENT);
    }

    public static OrderByComparator getArticleOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        ArticleCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("create-date")) {
            orderByComparator = new ArticleCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("display-date")) {
            orderByComparator = new ArticleDisplayDateComparator(orderByAsc);
        } else if (orderByCol.equals("id")) {
            orderByComparator = new ArticleIDComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new ArticleModifiedDateComparator(orderByAsc);
        } else if (orderByCol.equals("review-date")) {
            orderByComparator = new ArticleReviewDateComparator(orderByAsc);
        } else if (orderByCol.equals("title")) {
            orderByComparator = new ArticleTitleComparator(orderByAsc);
        } else if (orderByCol.equals("version")) {
            orderByComparator = new ArticleVersionComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public static String getEmailFromAddress(PortletPreferences preferences) {
        String emailFromAddress = PropsUtil.get("journal.email.from.address");
        return preferences.getValue("email-from-address", emailFromAddress);
    }

    public static String getEmailFromName(PortletPreferences preferences) {
        String emailFromName = PropsUtil.get("journal.email.from.name");
        return preferences.getValue("email-from-name", emailFromName);
    }

    public static boolean getEmailArticleApprovalDeniedEnabled(PortletPreferences preferences) {
        String emailArticleApprovalDeniedEnabled = preferences.getValue("email-article-approval-denied-enabled", "");
        if (Validator.isNotNull((String)emailArticleApprovalDeniedEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleApprovalDeniedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.approval.denied.enabled"));
    }

    public static String getEmailArticleApprovalDeniedBody(PortletPreferences preferences) {
        String emailArticleApprovalDeniedBody = preferences.getValue("email-article-approval-denied-body", "");
        if (Validator.isNotNull((String)emailArticleApprovalDeniedBody)) {
            return emailArticleApprovalDeniedBody;
        }
        return ContentUtil.get(PropsUtil.get("journal.email.article.approval.denied.body"));
    }

    public static String getEmailArticleApprovalDeniedSubject(PortletPreferences preferences) {
        String emailArticleApprovalDeniedSubject = preferences.getValue("email-article-approval-denied-subject", "");
        if (Validator.isNotNull((String)emailArticleApprovalDeniedSubject)) {
            return emailArticleApprovalDeniedSubject;
        }
        return ContentUtil.get(PropsUtil.get("journal.email.article.approval.denied.subject"));
    }

    public static boolean getEmailArticleApprovalGrantedEnabled(PortletPreferences preferences) {
        String emailArticleApprovalGrantedEnabled = preferences.getValue("email-article-approval-granted-enabled", "");
        if (Validator.isNotNull((String)emailArticleApprovalGrantedEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleApprovalGrantedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.approval.granted.enabled"));
    }

    public static String getEmailArticleApprovalGrantedBody(PortletPreferences preferences) {
        String emailArticleApprovalGrantedBody = preferences.getValue("email-article-approval-granted-body", "");
        if (Validator.isNotNull((String)emailArticleApprovalGrantedBody)) {
            return emailArticleApprovalGrantedBody;
        }
        return ContentUtil.get(PropsUtil.get("journal.email.article.approval.granted.body"));
    }

    public static String getEmailArticleApprovalGrantedSubject(PortletPreferences preferences) {
        String emailArticleApprovalGrantedSubject = preferences.getValue("email-article-approval-granted-subject", "");
        if (Validator.isNotNull((String)emailArticleApprovalGrantedSubject)) {
            return emailArticleApprovalGrantedSubject;
        }
        return ContentUtil.get(PropsUtil.get("journal.email.article.approval.granted.subject"));
    }

    public static boolean getEmailArticleApprovalRequestedEnabled(PortletPreferences preferences) {
        String emailArticleApprovalRequestedEnabled = preferences.getValue("email-article-approval-requested-enabled", "");
        if (Validator.isNotNull((String)emailArticleApprovalRequestedEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleApprovalRequestedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.approval.requested.enabled"));
    }

    public static String getEmailArticleApprovalRequestedBody(PortletPreferences preferences) {
        String emailArticleApprovalRequestedBody = preferences.getValue("email-article-approval-requested-body", "");
        if (Validator.isNotNull((String)emailArticleApprovalRequestedBody)) {
            return emailArticleApprovalRequestedBody;
        }
        return ContentUtil.get(PropsUtil.get("journal.email.article.approval.requested.body"));
    }

    public static String getEmailArticleApprovalRequestedSubject(PortletPreferences preferences) {
        String emailArticleApprovalRequestedSubject = preferences.getValue("email-article-approval-requested-subject", "");
        if (Validator.isNotNull((String)emailArticleApprovalRequestedSubject)) {
            return emailArticleApprovalRequestedSubject;
        }
        return ContentUtil.get(PropsUtil.get("journal.email.article.approval.requested.subject"));
    }

    public static boolean getEmailArticleReviewEnabled(PortletPreferences preferences) {
        String emailArticleReviewEnabled = preferences.getValue("email-article-review-enabled", "");
        if (Validator.isNotNull((String)emailArticleReviewEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleReviewEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.review.enabled"));
    }

    public static String getEmailArticleReviewBody(PortletPreferences preferences) {
        String emailArticleReviewBody = preferences.getValue("email-article-review-body", "");
        if (Validator.isNotNull((String)emailArticleReviewBody)) {
            return emailArticleReviewBody;
        }
        return ContentUtil.get(PropsUtil.get("journal.email.article.review.body"));
    }

    public static String getEmailArticleReviewSubject(PortletPreferences preferences) {
        String emailArticleReviewSubject = preferences.getValue("email-article-review-subject", "");
        if (Validator.isNotNull((String)emailArticleReviewSubject)) {
            return emailArticleReviewSubject;
        }
        return ContentUtil.get(PropsUtil.get("journal.email.article.review.subject"));
    }

    public static Stack<JournalArticle> getRecentArticles(PortletRequest portletRequest) {
        PortletSession portletSession = portletRequest.getPortletSession();
        Stack recentArticles = (Stack)portletSession.getAttribute("JOURNAL_RECENT_ARTICLES");
        if (recentArticles == null) {
            recentArticles = new FiniteUniqueStack(20);
            portletSession.setAttribute("JOURNAL_RECENT_ARTICLES", (Object)recentArticles);
        }
        return recentArticles;
    }

    public static Stack<JournalStructure> getRecentStructures(PortletRequest portletRequest) {
        PortletSession portletSession = portletRequest.getPortletSession();
        Stack recentStructures = (Stack)portletSession.getAttribute("JOURNAL_RECENT_STRUCTURES");
        if (recentStructures == null) {
            recentStructures = new FiniteUniqueStack(20);
            portletSession.setAttribute("JOURNAL_RECENT_STRUCTURES", (Object)recentStructures);
        }
        return recentStructures;
    }

    public static Stack<JournalTemplate> getRecentTemplates(PortletRequest portletRequest) {
        PortletSession portletSession = portletRequest.getPortletSession();
        Stack recentTemplates = (Stack)portletSession.getAttribute("JOURNAL_RECENT_TEMPLATES");
        if (recentTemplates == null) {
            recentTemplates = new FiniteUniqueStack(20);
            portletSession.setAttribute("JOURNAL_RECENT_TEMPLATES", (Object)recentTemplates);
        }
        return recentTemplates;
    }

    public static String getTemplateScript(long groupId, String templateId, Map<String, String> tokens, String languageId) throws PortalException, SystemException {
        return JournalUtil.getTemplateScript(groupId, templateId, tokens, languageId, true);
    }

    public static String getTemplateScript(long groupId, String templateId, Map<String, String> tokens, String languageId, boolean transform) throws PortalException, SystemException {
        JournalTemplate template = JournalTemplateLocalServiceUtil.getTemplate((long)groupId, (String)templateId);
        return JournalUtil.getTemplateScript(template, tokens, languageId, transform);
    }

    public static String getTemplateScript(JournalTemplate template, Map<String, String> tokens, String languageId, boolean transform) {
        String script = template.getXsl();
        if (transform) {
            String[] listeners = PropsUtil.getArray("journal.transformer.listener");
            for (int i = 0; i < listeners.length; ++i) {
                TransformerListener listener = null;
                try {
                    listener = (TransformerListener)Class.forName(listeners[i]).newInstance();
                    listener.setTemplateDriven(true);
                    listener.setLanguageId(languageId);
                    listener.setTokens(tokens);
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
                if (listener == null) continue;
                script = listener.onScript(script);
            }
        }
        return script;
    }

    public static Map<String, String> getTokens(long groupId, ThemeDisplay themeDisplay) {
        return JournalUtil.getTokens(groupId, themeDisplay, null);
    }

    public static Map<String, String> getTokens(long groupId, ThemeDisplay themeDisplay, String xmlRequest) {
        HashMap<String, String> tokens;
        block5: {
            tokens = new HashMap<String, String>();
            if (themeDisplay != null) {
                JournalUtil._populateTokens(tokens, groupId, themeDisplay);
            } else if (Validator.isNotNull((String)xmlRequest)) {
                try {
                    JournalUtil._populateTokens(tokens, groupId, xmlRequest);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)e, (Throwable)e);
                }
            }
        }
        return tokens;
    }

    public static String getUrlTitle(long id, String title) {
        if (Validator.isNull((String)(title = title.trim().toLowerCase())) || Validator.isNumber((String)title) || title.equals("rss")) {
            return String.valueOf(id);
        }
        return FriendlyURLNormalizer.normalize(title, _URL_TITLE_REPLACE_CHARS);
    }

    public static String mergeArticleContent(String curContent, String newContent) {
        try {
            Document curDocument = SAXReaderUtil.read((String)curContent);
            Document newDocument = SAXReaderUtil.read((String)newContent);
            Element curRoot = curDocument.getRootElement();
            Element newRoot = newDocument.getRootElement();
            curRoot.addAttribute("default-locale", newRoot.attributeValue("default-locale"));
            curRoot.addAttribute("available-locales", newRoot.attributeValue("available-locales"));
            JournalUtil._mergeArticleContentUpdate(curDocument, newRoot, LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));
            JournalUtil._mergeArticleContentDelete(curRoot, newDocument);
            curContent = JournalUtil.formatXML(curDocument);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return curContent;
    }

    public static String removeArticleLocale(String content, String languageId) {
        try {
            Document doc = SAXReaderUtil.read((String)content);
            Element root = doc.getRootElement();
            String availableLocales = root.attributeValue("available-locales");
            if (availableLocales == null) {
                return content;
            }
            if ((availableLocales = StringUtil.remove((String)availableLocales, (String)languageId)).endsWith(",")) {
                availableLocales = availableLocales.substring(0, availableLocales.length() - 1);
            }
            root.addAttribute("available-locales", availableLocales);
            JournalUtil.removeArticleLocale(root, languageId);
            content = JournalUtil.formatXML(doc);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return content;
    }

    public static void removeArticleLocale(Element el, String languageId) throws PortalException, SystemException {
        for (Element dynamicEl : el.elements("dynamic-element")) {
            for (Element dynamicContentEl : dynamicEl.elements("dynamic-content")) {
                String curLanguageId = GetterUtil.getString((String)dynamicContentEl.attributeValue("language-id"));
                if (!curLanguageId.equals(languageId)) continue;
                long id = GetterUtil.getLong((String)dynamicContentEl.attributeValue("id"));
                if (id > 0L) {
                    ImageLocalServiceUtil.deleteImage((long)id);
                }
                dynamicContentEl.detach();
            }
            JournalUtil.removeArticleLocale(dynamicEl, languageId);
        }
    }

    public static String removeOldContent(String content, String xsd) {
        try {
            Document contentDoc = SAXReaderUtil.read((String)content);
            Document xsdDoc = SAXReaderUtil.read((String)xsd);
            Element contentRoot = contentDoc.getRootElement();
            Stack<String> path = new Stack<String>();
            path.push(contentRoot.getName());
            JournalUtil._removeOldContent(path, contentRoot, xsdDoc);
            content = JournalUtil.formatXML(contentDoc);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return content;
    }

    public static void removeRecentArticle(PortletRequest portletRequest, String articleId) {
        Stack<JournalArticle> stack = JournalUtil.getRecentArticles(portletRequest);
        Iterator itr = stack.iterator();
        while (itr.hasNext()) {
            JournalArticle journalArticle = (JournalArticle)itr.next();
            if (!journalArticle.getArticleId().equals(articleId)) continue;
            itr.remove();
            break;
        }
    }

    public static void removeRecentStructure(PortletRequest portletRequest, String structureId) {
        Stack<JournalStructure> stack = JournalUtil.getRecentStructures(portletRequest);
        Iterator itr = stack.iterator();
        while (itr.hasNext()) {
            JournalStructure journalStructure = (JournalStructure)itr.next();
            if (!journalStructure.getStructureId().equals(structureId)) continue;
            itr.remove();
            break;
        }
    }

    public static void removeRecentTemplate(PortletRequest portletRequest, String templateId) {
        Stack<JournalTemplate> stack = JournalUtil.getRecentTemplates(portletRequest);
        Iterator itr = stack.iterator();
        while (itr.hasNext()) {
            JournalTemplate journalTemplate = (JournalTemplate)itr.next();
            if (!journalTemplate.getTemplateId().equals(templateId)) continue;
            itr.remove();
            break;
        }
    }

    public static String transform(Map<String, String> tokens, String viewMode, String languageId, String xml, String script, String langType) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Language " + languageId));
        }
        if (Validator.isNull((String)viewMode)) {
            viewMode = "view";
        }
        if (_logTokens.isDebugEnabled()) {
            String tokensString = PropertiesUtil.list(tokens);
            _logTokens.debug((Object)tokensString);
        }
        if (_logTransformBefore.isDebugEnabled()) {
            _logTransformBefore.debug((Object)xml);
        }
        ArrayList<TransformerListener> listenersList = new ArrayList<TransformerListener>();
        String[] listeners = PropsUtil.getArray("journal.transformer.listener");
        for (int i = 0; i < listeners.length; ++i) {
            TransformerListener listener = null;
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Instantiate listener " + listeners[i]));
                }
                boolean templateDriven = Validator.isNotNull((String)langType);
                listener = (TransformerListener)Class.forName(listeners[i]).newInstance();
                listener.setTemplateDriven(templateDriven);
                listener.setLanguageId(languageId);
                listener.setTokens(tokens);
                listenersList.add(listener);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            if (_logXmlBeforeListener.isDebugEnabled()) {
                _logXmlBeforeListener.debug((Object)xml);
            }
            if (listener != null) {
                xml = listener.onXml(xml);
                if (_logXmlAfterListener.isDebugEnabled()) {
                    _logXmlAfterListener.debug((Object)xml);
                }
            }
            if (_logScriptBeforeListener.isDebugEnabled()) {
                _logScriptBeforeListener.debug((Object)script);
            }
            if (listener == null) continue;
            script = listener.onScript(script);
            if (!_logScriptAfterListener.isDebugEnabled()) continue;
            _logScriptAfterListener.debug((Object)script);
        }
        String output = null;
        if (Validator.isNull((String)langType)) {
            output = LocalizationUtil.getLocalization((String)xml, (String)languageId);
        } else {
            String templateParserClassName = PropsUtil.get("journal.template.language.parser", new Filter(langType));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Template parser class name " + templateParserClassName));
            }
            if (Validator.isNotNull((String)templateParserClassName)) {
                TemplateParser templateParser = (TemplateParser)InstancePool.get((String)templateParserClassName);
                if (templateParser == null) {
                    throw new TransformException("No template parser found for " + templateParserClassName);
                }
                output = templateParser.transform(tokens, viewMode, languageId, xml, script);
            }
        }
        for (int i = 0; i < listenersList.size(); ++i) {
            TransformerListener listener = (TransformerListener)listenersList.get(i);
            if (_logOutputBeforeListener.isDebugEnabled()) {
                _logOutputBeforeListener.debug((Object)output);
            }
            output = listener.onOutput(output);
            if (!_logOutputAfterListener.isDebugEnabled()) continue;
            _logOutputAfterListener.debug((Object)output);
        }
        if (_logTransfromAfter.isDebugEnabled()) {
            _logTransfromAfter.debug((Object)output);
        }
        return output;
    }

    private static void _addElementOptions(Element curContentElement, Element newContentElement) {
        List newElementOptions = newContentElement.elements("option");
        for (Element newElementOption : newElementOptions) {
            Element curElementOption = SAXReaderUtil.createElement((String)"option");
            curElementOption.addCDATA(newElementOption.getText());
            curContentElement.add(curElementOption);
        }
    }

    private static Element _getElementByInstanceId(Document document, String instanceId) {
        XPath xPathSelector = SAXReaderUtil.createXPath((String)("//dynamic-element[@instance-id='" + instanceId + "']"));
        List nodes = xPathSelector.selectNodes((Object)document);
        if (nodes.size() == 1) {
            return (Element)nodes.get(0);
        }
        return null;
    }

    private static void _mergeArticleContentDelete(Element curParentElement, Document newDocument) throws Exception {
        List curElements = curParentElement.elements("dynamic-element");
        for (int i = 0; i < curElements.size(); ++i) {
            Element curElement = (Element)curElements.get(i);
            JournalUtil._mergeArticleContentDelete(curElement, newDocument);
            String instanceId = curElement.attributeValue("instance-id");
            Element newElement = JournalUtil._getElementByInstanceId(newDocument, instanceId);
            if (newElement != null) continue;
            curElement.detach();
            String type = curElement.attributeValue("type");
            if (!type.equals("image")) continue;
            JournalUtil._mergeArticleContentDeleteImages(curElement.elements("dynamic-content"));
        }
    }

    private static void _mergeArticleContentDeleteImages(List<Element> elements) throws Exception {
        for (Element element : elements) {
            long articleImageId = GetterUtil.getLong((String)element.attributeValue("id"));
            JournalArticleImageLocalServiceUtil.deleteArticleImage((long)articleImageId);
        }
    }

    private static void _mergeArticleContentUpdate(Document curDocument, Element newParentElement, String defaultLocale) throws Exception {
        List newElements = newParentElement.elements("dynamic-element");
        for (int i = 0; i < newElements.size(); ++i) {
            Element newElement = (Element)newElements.get(i);
            JournalUtil._mergeArticleContentUpdate(curDocument, newParentElement, newElement, i, defaultLocale);
        }
    }

    private static void _mergeArticleContentUpdate(Document curDocument, Element newParentElement, Element newElement, int pos, String defaultLocale) throws Exception {
        JournalUtil._mergeArticleContentUpdate(curDocument, newElement, defaultLocale);
        String instanceId = newElement.attributeValue("instance-id");
        Element curElement = JournalUtil._getElementByInstanceId(curDocument, instanceId);
        if (curElement != null) {
            JournalUtil._mergeArticleContentUpdate(curElement, newElement, defaultLocale);
        } else {
            String parentInstanceId = newParentElement.attributeValue("instance-id");
            if (Validator.isNull((String)parentInstanceId)) {
                Element curRoot = curDocument.getRootElement();
                List curRootElements = curRoot.elements();
                curRootElements.add(pos, newElement.createCopy());
            } else {
                Element curParentElement = JournalUtil._getElementByInstanceId(curDocument, parentInstanceId);
                if (curParentElement != null) {
                    List curParentElements = curParentElement.elements();
                    curParentElements.add(pos, newElement.createCopy());
                }
            }
        }
    }

    private static void _mergeArticleContentUpdate(Element curElement, Element newElement, String defaultLocale) {
        Element newContentElement = (Element)newElement.elements("dynamic-content").get(0);
        String newLanguageId = newContentElement.attributeValue("language-id");
        String newValue = newContentElement.getText();
        List curContentElements = curElement.elements("dynamic-content");
        if (Validator.isNull((String)newLanguageId)) {
            for (Element curContentElement : curContentElements) {
                curContentElement.detach();
            }
            Element curContentElement = SAXReaderUtil.createElement((String)"dynamic-content");
            if (newContentElement.element("option") != null) {
                JournalUtil._addElementOptions(curContentElement, newContentElement);
            } else {
                curContentElement.addCDATA(newValue);
            }
            curElement.add(curContentElement);
        } else {
            boolean alreadyExists = false;
            for (Element curContentElement : curContentElements) {
                String curLanguageId = curContentElement.attributeValue("language-id");
                if (!newLanguageId.equals(curLanguageId)) continue;
                alreadyExists = true;
                curContentElement.clearContent();
                if (newContentElement.element("option") != null) {
                    JournalUtil._addElementOptions(curContentElement, newContentElement);
                    break;
                }
                curContentElement.addCDATA(newValue);
                break;
            }
            if (!alreadyExists) {
                Element curContentElement = (Element)curContentElements.get(0);
                String curLanguageId = curContentElement.attributeValue("language-id");
                if (Validator.isNull((String)curLanguageId)) {
                    curContentElement.detach();
                }
                curElement.add(newContentElement.createCopy());
            }
        }
    }

    private static void _populateTokens(Map<String, String> tokens, long groupId, String xmlRequest) throws Exception {
        Document request = SAXReaderUtil.read((String)xmlRequest);
        Element root = request.getRootElement();
        Element themeDisplayEl = root.element("theme-display");
        Layout layout = LayoutLocalServiceUtil.getLayout((long)GetterUtil.getLong((String)themeDisplayEl.elementText("plid")));
        Group group = layout.getGroup();
        LayoutSet layoutSet = layout.getLayoutSet();
        String friendlyUrlCurrent = null;
        friendlyUrlCurrent = layout.isPublicLayout() ? themeDisplayEl.elementText("path-friendly-url-public") : (group.isUserGroup() ? themeDisplayEl.elementText("path-friendly-url-private-user") : themeDisplayEl.elementText("path-friendly-url-private-group"));
        String layoutSetFriendlyUrl = "";
        String virtualHost = layoutSet.getVirtualHost();
        if (Validator.isNull((String)virtualHost) || !virtualHost.equals(themeDisplayEl.elementText("server-name"))) {
            layoutSetFriendlyUrl = friendlyUrlCurrent + group.getFriendlyURL();
        }
        tokens.put("cdn_host", themeDisplayEl.elementText("cdn-host"));
        tokens.put("company_id", themeDisplayEl.elementText("company-id"));
        tokens.put("friendly_url_current", friendlyUrlCurrent);
        tokens.put("friendly_url_private_group", themeDisplayEl.elementText("path-friendly-url-private-group"));
        tokens.put("friendly_url_private_user", themeDisplayEl.elementText("path-friendly-url-private-user"));
        tokens.put("friendly_url_public", themeDisplayEl.elementText("path-friendly-url-public"));
        tokens.put("group_friendly_url", group.getFriendlyURL());
        tokens.put("group_id", String.valueOf(groupId));
        tokens.put("image_path", themeDisplayEl.elementText("path-image"));
        tokens.put("layout_set_friendly_url", layoutSetFriendlyUrl);
        tokens.put("main_path", themeDisplayEl.elementText("path-main"));
        tokens.put("portal_ctx", themeDisplayEl.elementText("path-context"));
        tokens.put("portal_url", HttpUtil.removeProtocol((String)themeDisplayEl.elementText("url-portal")));
        tokens.put("protocol", HttpUtil.getProtocol((String)themeDisplayEl.elementText("url-portal")));
        tokens.put("root_path", themeDisplayEl.elementText("path-context"));
        tokens.put("theme_image_path", themeDisplayEl.elementText("path-theme-images"));
        tokens.put("friendly_url", themeDisplayEl.elementText("path-friendly-url-public"));
        tokens.put("friendly_url_private", themeDisplayEl.elementText("path-friendly-url-private-group"));
        tokens.put("page_url", themeDisplayEl.elementText("path-friendly-url-public"));
    }

    private static void _populateTokens(Map<String, String> tokens, long groupId, ThemeDisplay themeDisplay) {
        Layout layout = themeDisplay.getLayout();
        Group group = layout.getGroup();
        LayoutSet layoutSet = layout.getLayoutSet();
        String friendlyUrlCurrent = null;
        friendlyUrlCurrent = layout.isPublicLayout() ? themeDisplay.getPathFriendlyURLPublic() : (group.isUserGroup() ? themeDisplay.getPathFriendlyURLPrivateUser() : themeDisplay.getPathFriendlyURLPrivateGroup());
        String layoutSetFriendlyUrl = "";
        String virtualHost = layoutSet.getVirtualHost();
        if (Validator.isNull((String)virtualHost) || !virtualHost.equals(themeDisplay.getServerName())) {
            layoutSetFriendlyUrl = friendlyUrlCurrent + group.getFriendlyURL();
        }
        tokens.put("cdn_host", themeDisplay.getCDNHost());
        tokens.put("company_id", String.valueOf(themeDisplay.getCompanyId()));
        tokens.put("friendly_url_current", friendlyUrlCurrent);
        tokens.put("friendly_url_private_group", themeDisplay.getPathFriendlyURLPrivateGroup());
        tokens.put("friendly_url_private_user", themeDisplay.getPathFriendlyURLPrivateUser());
        tokens.put("friendly_url_public", themeDisplay.getPathFriendlyURLPublic());
        tokens.put("group_friendly_url", group.getFriendlyURL());
        tokens.put("group_id", String.valueOf(groupId));
        tokens.put("image_path", themeDisplay.getPathImage());
        tokens.put("layout_set_friendly_url", layoutSetFriendlyUrl);
        tokens.put("main_path", themeDisplay.getPathMain());
        tokens.put("portal_ctx", themeDisplay.getPathContext());
        tokens.put("portal_url", HttpUtil.removeProtocol((String)themeDisplay.getURLPortal()));
        tokens.put("protocol", HttpUtil.getProtocol((String)themeDisplay.getURLPortal()));
        tokens.put("root_path", themeDisplay.getPathContext());
        tokens.put("theme_image_path", themeDisplay.getPathThemeImages());
        tokens.put("friendly_url", themeDisplay.getPathFriendlyURLPublic());
        tokens.put("friendly_url_private", themeDisplay.getPathFriendlyURLPrivateGroup());
        tokens.put("page_url", themeDisplay.getPathFriendlyURLPublic());
    }

    private static void _removeOldContent(Stack<String> path, Element contentEl, Document xsdDoc) throws SystemException {
        int i;
        String elPath = "";
        for (i = 0; i < path.size(); ++i) {
            elPath = elPath + "/" + (String)path.elementAt(i);
        }
        for (i = 0; i < contentEl.nodeCount(); ++i) {
            Node contentNode = contentEl.node(i);
            if (!(contentNode instanceof Element)) continue;
            JournalUtil._removeOldContent(path, (Element)contentNode, xsdDoc, elPath);
        }
    }

    private static void _removeOldContent(Stack<String> path, Element contentEl, Document xsdDoc, String elPath) throws SystemException {
        String name = contentEl.attributeValue("name");
        if (Validator.isNull((String)name)) {
            return;
        }
        String localPath = "dynamic-element[@name='" + name + "']";
        String fullPath = elPath + "/" + localPath;
        XPath xPathSelector = SAXReaderUtil.createXPath((String)fullPath);
        List curNodes = xPathSelector.selectNodes((Object)xsdDoc);
        if (curNodes.size() == 0) {
            contentEl.detach();
        }
        path.push(localPath);
        JournalUtil._removeOldContent(path, contentEl, xsdDoc);
        path.pop();
    }
}

