/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.portlet.journal.util.TransformerListener;
import java.util.List;
import java.util.Locale;

public class LocaleTransformerListener
extends TransformerListener {
    private static Log _log = LogFactoryUtil.getLog(LocaleTransformerListener.class);
    private String _requestedLocale = "";

    public String onXml(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onXml");
        }
        s = this.replace(s);
        return s;
    }

    public String onScript(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onScript");
        }
        s = StringUtil.replace((String)s, (String)"@language_id@", (String)this._requestedLocale);
        return s;
    }

    public String onOutput(String s) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onOutput");
        }
        return s;
    }

    protected String replace(String xml) {
        if (xml == null) {
            return xml;
        }
        this._requestedLocale = this.getLanguageId();
        try {
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
            String[] availableLocales = StringUtil.split((String)root.attributeValue("available-locales", defaultLanguageId));
            String defaultLocale = root.attributeValue("default-locale", defaultLanguageId);
            boolean isSupportedLocale = false;
            for (int i = 0; i < availableLocales.length; ++i) {
                if (!availableLocales[i].equalsIgnoreCase(this.getLanguageId())) continue;
                isSupportedLocale = true;
                break;
            }
            if (!isSupportedLocale) {
                this.setLanguageId(defaultLocale);
            }
            this.replace(root);
            xml = JournalUtil.formatXML(doc);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        return xml;
    }

    protected void replace(Element root) {
        List children = root.elements();
        for (int listIndex = children.size() - 1; listIndex >= 0; --listIndex) {
            Element child = (Element)children.get(listIndex);
            String languageId = child.attributeValue("language-id", this.getLanguageId());
            if (!languageId.equalsIgnoreCase(this.getLanguageId())) {
                root.remove(child);
                continue;
            }
            this.replace(child);
        }
    }
}

