/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.util.PortalUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateNode
extends LinkedHashMap<String, Object> {
    private Map<String, TemplateNode> _children = new LinkedHashMap<String, TemplateNode>();
    private List<TemplateNode> _siblings = new ArrayList<TemplateNode>();

    public TemplateNode(String name, String data, String type) {
        this.put("name", name);
        this.put("data", data);
        this.put("type", type);
        this.put("options", new ArrayList());
    }

    public void appendChild(TemplateNode child) {
        this._children.put(child.getName(), child);
        this.put(child.getName(), child);
    }

    public void appendChildren(List<TemplateNode> children) {
        for (TemplateNode child : children) {
            this.appendChild(child);
        }
    }

    public void appendOption(String option) {
        this.getOptions().add(option);
    }

    public void appendOptions(List<String> options) {
        this.getOptions().addAll(options);
    }

    public void appendSibling(TemplateNode sibling) {
        this._siblings.add(sibling);
    }

    public TemplateNode getChild(String name) {
        return this._children.get(name);
    }

    public List<TemplateNode> getChildren() {
        return new ArrayList<TemplateNode>(this._children.values());
    }

    public String getData() {
        if (this.getType().equals("link_to_layout")) {
            String data = (String)this.get("data");
            int pos = data.indexOf("@");
            if (pos != -1) {
                data = data.substring(0, pos);
            }
            return data;
        }
        return (String)this.get("data");
    }

    public String getName() {
        return (String)this.get("name");
    }

    public List<String> getOptions() {
        return (List)this.get("options");
    }

    public List<TemplateNode> getSiblings() {
        return this._siblings;
    }

    public String getType() {
        return (String)this.get("type");
    }

    public String getUrl() {
        if (this.getType().equals("link_to_layout")) {
            String layoutLink = (String)this.get("data");
            String layoutId = layoutLink;
            int pos = layoutId.indexOf("@");
            if (pos != -1) {
                layoutId = layoutId.substring(0, pos);
            }
            StringBuilder sb = new StringBuilder();
            if (layoutLink.endsWith("@public")) {
                sb.append(PortalUtil.getPathFriendlyURLPublic());
            } else if (layoutLink.endsWith("@private-group")) {
                sb.append(PortalUtil.getPathFriendlyURLPrivateGroup());
            } else if (layoutLink.endsWith("@private-user")) {
                sb.append(PortalUtil.getPathFriendlyURLPrivateUser());
            } else {
                sb.append("@friendly_url_current@");
            }
            sb.append("/");
            sb.append("@group_id@");
            sb.append("/");
            sb.append(layoutId);
            return sb.toString();
        }
        return "";
    }
}

