/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import java.util.Locale;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XSLErrorListener
implements ErrorListener {
    private Locale _locale;
    private String _location;
    private String _message;
    private int _lineNumber;
    private int _columnNumber;

    public XSLErrorListener(Locale locale) {
        this._locale = locale;
    }

    public void error(TransformerException exception) throws TransformerException {
        this.setLocation(exception);
        throw exception;
    }

    public void fatalError(TransformerException exception) throws TransformerException {
        this.setLocation(exception);
        throw exception;
    }

    public void warning(TransformerException exception) throws TransformerException {
        this.setLocation(exception);
        throw exception;
    }

    public void setLocation(Throwable exception) {
        Object locator = null;
        Throwable cause = exception;
        Throwable rootCause = null;
        while (cause != null) {
            SourceLocator causeLocator;
            if (cause instanceof SAXParseException) {
                locator = new SAXSourceLocator((SAXParseException)cause);
                rootCause = cause;
            } else if (cause instanceof TransformerException && (causeLocator = ((TransformerException)cause).getLocator()) != null) {
                locator = causeLocator;
                rootCause = cause;
            }
            if (cause instanceof TransformerException) {
                cause = ((TransformerException)cause).getCause();
                continue;
            }
            if (cause instanceof WrappedRuntimeException) {
                cause = ((WrappedRuntimeException)cause).getException();
                continue;
            }
            if (cause instanceof SAXException) {
                cause = ((SAXException)cause).getException();
                continue;
            }
            cause = null;
        }
        this._message = rootCause.getMessage();
        if (locator != null) {
            this._lineNumber = locator.getLineNumber();
            this._columnNumber = locator.getColumnNumber();
            StringBuilder sb = new StringBuilder();
            sb.append(LanguageUtil.get((Locale)this._locale, (String)"line"));
            sb.append(" #");
            sb.append(locator.getLineNumber());
            sb.append("; ");
            sb.append(LanguageUtil.get((Locale)this._locale, (String)"column"));
            sb.append(" #");
            sb.append(locator.getColumnNumber());
            sb.append("; ");
            this._location = sb.toString();
        } else {
            this._location = "";
        }
    }

    public String getLocation() {
        return this._location;
    }

    public String getMessage() {
        return this._message;
    }

    public String getMessageAndLocation() {
        return this._message + " " + this._location;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public int getColumnNumber() {
        return this._columnNumber;
    }
}

