/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.webdav;

import com.liferay.portal.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.webdav.BaseResourceImpl;
import com.liferay.portal.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.webdav.Resource;
import com.liferay.portal.webdav.WebDAVException;
import com.liferay.portal.webdav.WebDAVRequest;
import com.liferay.portlet.journal.NoSuchStructureException;
import com.liferay.portlet.journal.NoSuchTemplateException;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalStructureServiceUtil;
import com.liferay.portlet.journal.service.JournalTemplateLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalTemplateServiceUtil;
import com.liferay.portlet.journal.webdav.JournalStructureResourceImpl;
import com.liferay.portlet.journal.webdav.JournalTemplateResourceImpl;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    private static final String _TYPE_STRUCTURES = "Structures";
    private static final String _TYPE_TEMPLATES = "Templates";

    public int deleteResource(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            Resource resource = this.getResource(webDavRequest);
            if (resource == null) {
                return 404;
            }
            Object model = resource.getModel();
            if (model instanceof JournalStructure) {
                JournalStructure structure = (JournalStructure)model;
                JournalStructureServiceUtil.deleteStructure((long)structure.getGroupId(), (String)structure.getStructureId());
                return 204;
            }
            if (model instanceof JournalTemplate) {
                JournalTemplate template = (JournalTemplate)model;
                JournalTemplateServiceUtil.deleteTemplate((long)template.getGroupId(), (String)template.getTemplateId());
                return 204;
            }
            return 403;
        }
        catch (PortalException pe) {
            return 403;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public Resource getResource(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            String[] pathArray = webDavRequest.getPathArray();
            if (pathArray.length == 3) {
                String path = this.getRootPath() + webDavRequest.getPath();
                return new BaseResourceImpl(path, "", this.getToken());
            }
            if (pathArray.length == 4) {
                String type = pathArray[3];
                return this.toResource(webDavRequest, type, false);
            }
            if (pathArray.length == 5) {
                String type = pathArray[3];
                String journalTypeId = pathArray[4];
                if (type.equals(_TYPE_STRUCTURES)) {
                    try {
                        JournalStructure journalStructure = JournalStructureLocalServiceUtil.getStructure((long)webDavRequest.getGroupId(), (String)journalTypeId);
                        return this.toResource(webDavRequest, journalStructure, false);
                    }
                    catch (NoSuchStructureException nsse) {
                        return null;
                    }
                }
                if (type.equals(_TYPE_TEMPLATES)) {
                    try {
                        JournalTemplate journalTemplate = JournalTemplateLocalServiceUtil.getTemplate((long)webDavRequest.getGroupId(), (String)journalTypeId);
                        return this.toResource(webDavRequest, journalTemplate, false);
                    }
                    catch (NoSuchTemplateException nste) {
                        return null;
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public List<Resource> getResources(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            String[] pathArray = webDavRequest.getPathArray();
            if (pathArray.length == 3) {
                return this.getFolders(webDavRequest);
            }
            if (pathArray.length == 4) {
                String type = pathArray[3];
                if (type.equals(_TYPE_STRUCTURES)) {
                    return this.getStructures(webDavRequest);
                }
                if (type.equals(_TYPE_TEMPLATES)) {
                    return this.getTemplates(webDavRequest);
                }
            }
            return new ArrayList<Resource>();
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int putResource(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            Resource resource = this.getResource(webDavRequest);
            if (resource == null) {
                return 404;
            }
            ServiceContext serviceContext = new ServiceContext();
            Object model = resource.getModel();
            if (model instanceof JournalStructure) {
                JournalStructure structure = (JournalStructure)model;
                HttpServletRequest request = webDavRequest.getHttpServletRequest();
                String xsd = StringUtil.read((InputStream)request.getInputStream());
                JournalStructureServiceUtil.updateStructure((long)structure.getGroupId(), (String)structure.getStructureId(), (String)structure.getParentStructureId(), (String)structure.getName(), (String)structure.getDescription(), (String)xsd, (ServiceContext)serviceContext);
                return 201;
            }
            if (model instanceof JournalTemplate) {
                JournalTemplate template = (JournalTemplate)model;
                HttpServletRequest request = webDavRequest.getHttpServletRequest();
                String xsl = StringUtil.read((InputStream)request.getInputStream());
                boolean formatXsl = true;
                File smallFile = null;
                JournalTemplateServiceUtil.updateTemplate((long)template.getGroupId(), (String)template.getTemplateId(), (String)template.getStructureId(), (String)template.getName(), (String)template.getDescription(), (String)xsl, (boolean)formatXsl, (String)template.getLangType(), (boolean)template.isCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), smallFile, (ServiceContext)serviceContext);
                return 201;
            }
            return 403;
        }
        catch (PortalException pe) {
            return 403;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    protected List<Resource> getFolders(WebDAVRequest webDavRequest) throws Exception {
        ArrayList<Resource> folders = new ArrayList<Resource>();
        folders.add(this.toResource(webDavRequest, _TYPE_STRUCTURES, true));
        folders.add(this.toResource(webDavRequest, _TYPE_TEMPLATES, true));
        return folders;
    }

    protected List<Resource> getStructures(WebDAVRequest webDavRequest) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        long groupId = webDavRequest.getGroupId();
        List structures = JournalStructureLocalServiceUtil.getStructures((long)groupId);
        for (JournalStructure structure : structures) {
            Resource resource = this.toResource(webDavRequest, structure, true);
            resources.add(resource);
        }
        return resources;
    }

    protected List<Resource> getTemplates(WebDAVRequest webDavRequest) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        long groupId = webDavRequest.getGroupId();
        List templates = JournalTemplateLocalServiceUtil.getTemplates((long)groupId);
        for (JournalTemplate template : templates) {
            Resource resource = this.toResource(webDavRequest, template, true);
            resources.add(resource);
        }
        return resources;
    }

    protected Resource toResource(WebDAVRequest webDavRequest, String type, boolean appendPath) {
        String parentPath = this.getRootPath() + webDavRequest.getPath();
        String name = "";
        if (appendPath) {
            name = type;
        }
        BaseResourceImpl resource = new BaseResourceImpl(parentPath, name, type);
        resource.setModel((Object)type);
        return resource;
    }

    protected Resource toResource(WebDAVRequest webDavRequest, JournalStructure structure, boolean appendPath) {
        String parentPath = this.getRootPath() + webDavRequest.getPath();
        String name = "";
        if (appendPath) {
            name = structure.getStructureId();
        }
        return new JournalStructureResourceImpl(structure, parentPath, name);
    }

    protected Resource toResource(WebDAVRequest webDavRequest, JournalTemplate template, boolean appendPath) {
        String parentPath = this.getRootPath() + webDavRequest.getPath();
        String name = "";
        if (appendPath) {
            name = template.getTemplateId();
        }
        return new JournalTemplateResourceImpl(template, parentPath, name);
    }
}

