/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journalcontent;

import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalContentFriendlyURLMapper
implements FriendlyURLMapper {
    private static final boolean _CHECK_MAPPING_WITH_PREFIX = true;
    private static final String _MAPPING = "journal_content";
    private static final String _PORTLET_DEFAULT_INSTANCE = "56_INSTANCE_0000";
    private static final String _PORTLET_ID = "56";

    public String buildPath(LiferayPortletURL portletURL) {
        String friendlyURLPath = null;
        String strutsAction = GetterUtil.getString((String)portletURL.getParameter("struts_action"));
        WindowState windowState = portletURL.getWindowState();
        if (strutsAction.equals("/journal_content/view") && (windowState == null || !windowState.equals((Object)LiferayWindowState.EXCLUSIVE) && !windowState.equals((Object)LiferayWindowState.POP_UP))) {
            String portletId = portletURL.getPortletId();
            String groupId = portletURL.getParameter("groupId");
            String articleId = portletURL.getParameter("articleId");
            String templateId = portletURL.getParameter("templateId");
            if (Validator.isNotNull((String)portletId) && Validator.isNotNull((String)groupId) && Validator.isNotNull((String)articleId)) {
                if (portletId.equals(_PORTLET_DEFAULT_INSTANCE)) {
                    portletId = _PORTLET_ID;
                }
                friendlyURLPath = "/journal_content/" + portletId + "/" + groupId + "/" + articleId;
                portletURL.addParameterIncludedInPath("groupId");
                portletURL.addParameterIncludedInPath("articleId");
                if (Validator.isNotNull((String)templateId)) {
                    friendlyURLPath = friendlyURLPath + "/" + templateId;
                    portletURL.addParameterIncludedInPath("templateId");
                }
            }
        }
        if (Validator.isNotNull(friendlyURLPath)) {
            portletURL.addParameterIncludedInPath("p_p_id");
            portletURL.addParameterIncludedInPath("struts_action");
        }
        return friendlyURLPath;
    }

    public String getMapping() {
        return _MAPPING;
    }

    public boolean isCheckMappingWithPrefix() {
        return true;
    }

    public void populateParams(String friendlyURLPath, Map<String, String[]> params) {
        int w = friendlyURLPath.indexOf("/", 1);
        int x = friendlyURLPath.indexOf("/", w + 1);
        int y = friendlyURLPath.indexOf("/", x + 1);
        int z = friendlyURLPath.indexOf("/", y + 1);
        if (x == -1) {
            return;
        }
        String portletId = friendlyURLPath.substring(w + 1, x);
        String namespace = "_" + portletId + "_";
        if (Validator.equals((Object)portletId, (Object)_PORTLET_ID)) {
            portletId = _PORTLET_DEFAULT_INSTANCE;
            namespace = "_" + portletId + "_";
            params.put("p_p_id", new String[]{portletId});
            params.put("p_p_state", new String[]{WindowState.MAXIMIZED.toString()});
        } else {
            params.put("p_p_id", new String[]{portletId});
            params.put("p_p_state", new String[]{WindowState.NORMAL.toString()});
        }
        params.put("p_p_lifecycle", new String[]{"0"});
        params.put("p_p_mode", new String[]{PortletMode.VIEW.toString()});
        String groupId = friendlyURLPath.substring(x + 1, y);
        params.put(namespace + "groupId", new String[]{groupId});
        String articleId = null;
        if (z == -1) {
            articleId = friendlyURLPath.substring(y + 1, friendlyURLPath.length());
            params.put(namespace + "articleId", new String[]{articleId});
        } else {
            articleId = friendlyURLPath.substring(y + 1, z);
            params.put(namespace + "articleId", new String[]{articleId});
            String templateId = friendlyURLPath.substring(z + 1, friendlyURLPath.length());
            params.put(namespace + "templateId", new String[]{templateId});
        }
        params.put(namespace + "struts_action", new String[]{"/journal_content/view"});
    }
}

