/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journalcontent;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletLayoutListenerException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.journal.NoSuchContentSearchException;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import javax.portlet.PortletPreferences;

public class JournalContentPortletLayoutListener
implements PortletLayoutListener {
    private static Log _log = LogFactoryUtil.getLog(JournalContentPortletLayoutListener.class);

    public void onAddToLayout(String portletId, long plid) throws PortletLayoutListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Add " + portletId + " to layout " + plid));
        }
    }

    public void onMoveInLayout(String portletId, long plid) throws PortletLayoutListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Move " + portletId + " from in " + plid));
        }
    }

    public void onRemoveFromLayout(String portletId, long plid) throws PortletLayoutListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Remove " + portletId + " from layout " + plid));
        }
        try {
            this.deleteContentSearch(portletId, plid);
        }
        catch (Exception e) {
            throw new PortletLayoutListenerException((Throwable)e);
        }
    }

    protected void deleteContentSearch(String portletId, long plid) throws Exception {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletId, (String)"");
        String articleId = preferences.getValue("article-id", null);
        if (Validator.isNull((String)articleId)) {
            return;
        }
        try {
            JournalContentSearchLocalServiceUtil.deleteArticleContentSearch((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletId, (String)articleId);
        }
        catch (NoSuchContentSearchException nscse) {
            // empty catch block
        }
    }
}

