/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journalcontentsearch.util;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

public class ContentHits {
    private boolean _showListed = true;

    public void recordHits(Hits hits, long groupId, boolean privateLayout, int start, int end) throws Exception {
        List<Document> docs = new ArrayList();
        ArrayList<Float> scores = new ArrayList<Float>();
        for (int i = 0; i < hits.getLength(); ++i) {
            Document doc = hits.doc(i);
            String articleId = doc.get("entryClassPK");
            long articleGroupId = GetterUtil.getLong((String)doc.get("groupId"));
            if (JournalContentSearchLocalServiceUtil.getLayoutIdsCount((long)groupId, (boolean)privateLayout, (String)articleId) > 0) {
                docs.add(hits.doc(i));
                scores.add(Float.valueOf(hits.score(i)));
                continue;
            }
            if (this.isShowListed() || articleGroupId != groupId) continue;
            docs.add(hits.doc(i));
            scores.add(Float.valueOf(hits.score(i)));
        }
        int length = docs.size();
        hits.setLength(length);
        if (end > length) {
            end = length;
        }
        docs = docs.subList(start, end);
        hits.setDocs(docs.toArray(new Document[docs.size()]));
        hits.setScores(scores.toArray(new Float[docs.size()]));
        hits.setSearchTime((float)(System.currentTimeMillis() - hits.getStart()) / 1000.0f);
    }

    public boolean isShowListed() {
        return this._showListed;
    }

    public void setShowListed(boolean showListed) {
        this._showListed = showListed;
    }
}

