/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutconfiguration.util.velocity;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.PortletRenderWeightComparator;
import com.liferay.portlet.layoutconfiguration.util.RuntimePortletUtil;
import com.liferay.portlet.layoutconfiguration.util.velocity.RuntimeLogic;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletColumnLogic
extends RuntimeLogic {
    private static Log _log = LogFactoryUtil.getLog(PortletColumnLogic.class);
    private ServletContext _servletContext;
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private ThemeDisplay _themeDisplay;
    private Map<Portlet, Object[]> _portletsMap;
    private boolean _parallelRenderEnable;

    public PortletColumnLogic(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this._servletContext = servletContext;
        this._request = request;
        this._response = response;
        this._themeDisplay = (ThemeDisplay)this._request.getAttribute("THEME_DISPLAY");
        this._portletsMap = new TreeMap<Portlet, Object[]>((Comparator<Portlet>)new PortletRenderWeightComparator());
        this._parallelRenderEnable = PropsValues.LAYOUT_PARALLEL_RENDER_ENABLE;
        if (this._parallelRenderEnable && PropsValues.SESSION_DISABLED && _log.isWarnEnabled()) {
            _log.warn((Object)"Parallel rendering should be disabled if sessions are disabled");
        }
        if (this._parallelRenderEnable) {
            Boolean portletParallelRender = (Boolean)request.getAttribute("PORTLET_PARALLEL_RENDER");
            if (portletParallelRender != null && !portletParallelRender.booleanValue()) {
                this._parallelRenderEnable = false;
            }
        } else {
            request.removeAttribute("PORTLET_PARALLEL_RENDER");
        }
    }

    @Override
    public void processContent(StringBuilder sb, Map<String, String> attributes) throws Exception {
        LayoutTypePortlet layoutTypePortlet = this._themeDisplay.getLayoutTypePortlet();
        String columnId = attributes.get("id");
        List portlets = layoutTypePortlet.getAllPortlets(columnId);
        String columnCssClass = "lfr-portlet-column";
        if (portlets.size() == 0) {
            columnCssClass = columnCssClass + " empty";
        }
        sb.append("<div class=\"");
        sb.append(columnCssClass);
        sb.append("\" id=\"layout-column_");
        sb.append(columnId);
        sb.append("\">");
        for (int i = 0; i < portlets.size(); ++i) {
            Portlet portlet = (Portlet)portlets.get(i);
            String queryString = null;
            Integer columnPos = new Integer(i);
            Integer columnCount = new Integer(portlets.size());
            String path = null;
            if (this._parallelRenderEnable) {
                path = "/html/portal/load_render_portlet.jsp";
                if (portlet.getRenderWeight() >= 1) {
                    this._portletsMap.put(portlet, new Object[]{queryString, columnId, columnPos, columnCount});
                }
            }
            RuntimePortletUtil.processPortlet(sb, this._servletContext, this._request, this._response, portlet, queryString, columnId, columnPos, columnCount, path);
        }
        sb.append("</div>");
    }

    public Map<Portlet, Object[]> getPortletsMap() {
        return this._portletsMap;
    }
}

