/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutconfiguration.util.velocity;

import com.liferay.portal.model.Portlet;
import com.liferay.portal.util.comparator.PortletRenderWeightComparator;
import com.liferay.portlet.layoutconfiguration.util.velocity.PortletColumnLogic;
import com.liferay.portlet.layoutconfiguration.util.velocity.PortletLogic;
import com.liferay.portlet.layoutconfiguration.util.velocity.RuntimeLogic;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateProcessor {
    private ServletContext _servletContext;
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private String _portletId;
    private Map<String, String> _columnsMap;
    private Map<Portlet, Object[]> _portletsMap;

    public TemplateProcessor(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String portletId) {
        this._servletContext = servletContext;
        this._request = request;
        this._response = response;
        this._portletId = portletId;
        this._columnsMap = new HashMap<String, String>();
        this._portletsMap = new TreeMap<Portlet, Object[]>((Comparator<Portlet>)new PortletRenderWeightComparator());
    }

    public String processColumn(String columnId) throws Exception {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("id", columnId);
        PortletColumnLogic logic = new PortletColumnLogic(this._servletContext, this._request, this._response);
        StringBuilder sb = new StringBuilder();
        logic.processContent(sb, attributes);
        this._portletsMap.putAll(logic.getPortletsMap());
        String columnIdPlaceHolder = "[$TEMPLATE_COLUMN_" + columnId + "$]";
        this._columnsMap.put(columnIdPlaceHolder, sb.toString());
        return columnIdPlaceHolder;
    }

    public String processMax() throws Exception {
        PortletLogic logic = new PortletLogic(this._servletContext, this._request, this._response, this._portletId);
        StringBuilder sb = new StringBuilder();
        ((RuntimeLogic)logic).processContent(sb, new HashMap<String, String>());
        return sb.toString();
    }

    public String processPortlet(String portletId) throws Exception {
        PortletLogic logic = new PortletLogic(this._servletContext, this._request, this._response, portletId);
        StringBuilder sb = new StringBuilder();
        ((RuntimeLogic)logic).processContent(sb, new HashMap<String, String>());
        return sb.toString();
    }

    public Map<String, String> getColumnsMap() {
        return this._columnsMap;
    }

    public Map<Portlet, Object[]> getPortletsMap() {
        return this._portletsMap;
    }
}

