/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.login.action;

import com.liferay.portal.ContactFirstNameException;
import com.liferay.portal.ContactFullNameException;
import com.liferay.portal.ContactLastNameException;
import com.liferay.portal.DuplicateUserEmailAddressException;
import com.liferay.portal.DuplicateUserScreenNameException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.NoSuchOrganizationException;
import com.liferay.portal.OrganizationParentException;
import com.liferay.portal.RequiredUserException;
import com.liferay.portal.ReservedUserEmailAddressException;
import com.liferay.portal.ReservedUserScreenNameException;
import com.liferay.portal.UserEmailAddressException;
import com.liferay.portal.UserIdException;
import com.liferay.portal.UserPasswordException;
import com.liferay.portal.UserScreenNameException;
import com.liferay.portal.UserSmsException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.captcha.CaptchaUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.login.util.LoginUtil;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CreateAccountAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add")) {
                this.addUser(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (e instanceof CaptchaTextException || e instanceof ContactFirstNameException || e instanceof ContactFullNameException || e instanceof ContactLastNameException || e instanceof DuplicateUserEmailAddressException || e instanceof DuplicateUserScreenNameException || e instanceof NoSuchOrganizationException || e instanceof OrganizationParentException || e instanceof RequiredUserException || e instanceof ReservedUserEmailAddressException || e instanceof ReservedUserScreenNameException || e instanceof UserEmailAddressException || e instanceof UserIdException || e instanceof UserPasswordException || e instanceof UserScreenNameException || e instanceof UserSmsException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
            }
            throw e;
        }
        if (Validator.isNull((String)PropsValues.COMPANY_SECURITY_STRANGERS_URL)) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        try {
            Layout layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)themeDisplay.getScopeGroupId(), (boolean)false, (String)PropsValues.COMPANY_SECURITY_STRANGERS_URL);
            String redirect = PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay);
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (NoSuchLayoutException nsle) {
            // empty catch block
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Company company = PortalUtil.getCompany((PortletRequest)renderRequest);
        if (!company.isStrangers()) {
            throw new PrincipalException();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        renderResponse.setTitle(themeDisplay.translate("create-account"));
        return mapping.findForward("portlet.login.create_account");
    }

    protected void addUser(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        boolean autoPassword = true;
        String password1 = null;
        String password2 = null;
        boolean autoScreenName = false;
        String screenName = ParamUtil.getString((PortletRequest)actionRequest, (String)"screenName");
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        String openId = ParamUtil.getString((PortletRequest)actionRequest, (String)"openId");
        String firstName = ParamUtil.getString((PortletRequest)actionRequest, (String)"firstName");
        String middleName = ParamUtil.getString((PortletRequest)actionRequest, (String)"middleName");
        String lastName = ParamUtil.getString((PortletRequest)actionRequest, (String)"lastName");
        int prefixId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"prefixId");
        int suffixId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"suffixId");
        boolean male = ParamUtil.get((PortletRequest)actionRequest, (String)"male", (boolean)true);
        int birthdayMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayMonth");
        int birthdayDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayDay");
        int birthdayYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayYear");
        String jobTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"jobTitle");
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = true;
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
        if (PropsValues.LOGIN_CREATE_ACCOUNT_ALLOW_CUSTOM_PASSWORD) {
            autoPassword = false;
            password1 = ParamUtil.getString((PortletRequest)actionRequest, (String)"password1");
            password2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"password2");
        }
        boolean openIdPending = false;
        Boolean openIdLoginPending = (Boolean)session.getAttribute("OPEN_ID_LOGIN_PENDING");
        if (openIdLoginPending != null && openIdLoginPending.booleanValue() && Validator.isNotNull((String)openId)) {
            sendEmail = false;
            openIdPending = true;
        }
        if (PropsValues.CAPTCHA_CHECK_PORTAL_CREATE_ACCOUNT) {
            CaptchaUtil.check((PortletRequest)actionRequest);
        }
        User user = UserServiceUtil.addUser((long)company.getCompanyId(), (boolean)autoPassword, (String)password1, (String)password2, (boolean)autoScreenName, (String)screenName, (String)emailAddress, (String)openId, (Locale)themeDisplay.getLocale(), (String)firstName, (String)middleName, (String)lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)jobTitle, groupIds, organizationIds, roleIds, userGroupIds, (boolean)sendEmail, (ServiceContext)serviceContext);
        if (openIdPending) {
            session.setAttribute("OPEN_ID_LOGIN", (Object)new Long(user.getUserId()));
            session.removeAttribute("OPEN_ID_LOGIN_PENDING");
        } else {
            SessionMessages.add((HttpServletRequest)request, (String)"user_added", (Object)user.getEmailAddress());
            SessionMessages.add((HttpServletRequest)request, (String)"user_added_password", (Object)user.getPasswordUnencrypted());
        }
        String login = null;
        login = company.getAuthType().equals("userId") ? String.valueOf(user.getUserId()) : (company.getAuthType().equals("screenName") ? user.getScreenName() : user.getEmailAddress());
        PortletURL loginURL = LoginUtil.getLoginURL(request, themeDisplay.getPlid());
        loginURL.setParameter("login", login);
        String redirect = loginURL.toString();
        actionResponse.sendRedirect(redirect);
    }

    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }
}

