/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.login.action;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.SendPasswordException;
import com.liferay.portal.UserEmailAddressException;
import com.liferay.portal.UserReminderQueryException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.captcha.CaptchaUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.login.util.LoginUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ForgotPasswordAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            User user = this.getUser(actionRequest);
            if (PropsValues.USERS_REMINDER_QUERIES_ENABLED && (PropsValues.CAPTCHA_CHECK_PORTAL_SEND_PASSWORD || Validator.isNotNull((String)user.getReminderQueryQuestion()) && Validator.isNotNull((String)user.getReminderQueryAnswer()))) {
                actionRequest.setAttribute(ForgotPasswordAction.class.getName(), (Object)user);
                int step = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"step");
                if (step == 2) {
                    if (PropsValues.CAPTCHA_CHECK_PORTAL_SEND_PASSWORD) {
                        CaptchaUtil.check((PortletRequest)actionRequest);
                    }
                    this.sendPassword(actionRequest, actionResponse);
                }
            } else {
                if (PropsValues.CAPTCHA_CHECK_PORTAL_SEND_PASSWORD) {
                    CaptchaUtil.check((PortletRequest)actionRequest);
                }
                this.sendPassword(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (e instanceof CaptchaTextException || e instanceof NoSuchUserException || e instanceof SendPasswordException || e instanceof UserEmailAddressException || e instanceof UserReminderQueryException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            PortalUtil.sendError((Exception)e, (ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        renderResponse.setTitle(themeDisplay.translate("forgot-password"));
        return mapping.findForward("portlet.login.forgot_password");
    }

    protected User getUser(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long userId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userId");
        String screenName = ParamUtil.getString((PortletRequest)actionRequest, (String)"screenName");
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        User user = null;
        if (Validator.isNotNull((String)emailAddress)) {
            user = UserLocalServiceUtil.getUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)emailAddress);
        } else if (Validator.isNotNull((String)screenName)) {
            user = UserLocalServiceUtil.getUserByScreenName((long)themeDisplay.getCompanyId(), (String)screenName);
        } else if (userId > 0L) {
            user = UserLocalServiceUtil.getUserById((long)userId);
        } else {
            throw new NoSuchUserException();
        }
        return user;
    }

    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected void sendPassword(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        User user = this.getUser(actionRequest);
        if (PropsValues.USERS_REMINDER_QUERIES_ENABLED) {
            String answer = ParamUtil.getString((PortletRequest)actionRequest, (String)"answer");
            if (!user.getReminderQueryAnswer().equals(answer)) {
                throw new UserReminderQueryException();
            }
        }
        PortletPreferences preferences = actionRequest.getPreferences();
        String languageId = LanguageUtil.getLanguageId((PortletRequest)actionRequest);
        String emailFromName = preferences.getValue("emailFromName", null);
        String emailFromAddress = preferences.getValue("emailFromAddress", null);
        String emailToAddress = user.getEmailAddress();
        String subject = preferences.getValue("emailPasswordSentSubject_" + languageId, null);
        String body = preferences.getValue("emailPasswordSentBody_" + languageId, null);
        LoginUtil.sendPassword(actionRequest, emailFromName, emailFromAddress, emailToAddress, subject, body);
        this.sendRedirect(actionRequest, actionResponse);
    }
}

