/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.login.action;

import com.liferay.portal.DuplicateUserEmailAddressException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.OpenIdUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.util.PwdGenerator;
import java.util.List;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.message.sreg.SRegRequest;
import org.openid4java.message.sreg.SRegResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenIdAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;
    private static Log _log = LogFactoryUtil.getLog(OpenIdAction.class);

    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        if (actionRequest.getRemoteUser() != null) {
            actionResponse.sendRedirect(themeDisplay.getPathMain());
            return;
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("read")) {
                String redirect = this.readOpenIdResponse(themeDisplay, actionRequest, actionResponse);
                if (Validator.isNull((String)redirect)) {
                    redirect = PortalUtil.getPortalURL((PortletRequest)actionRequest) + themeDisplay.getURLSignIn();
                }
                this.sendRedirect(actionRequest, actionResponse, redirect);
            } else {
                this.sendOpenIdRequest(themeDisplay, actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (e instanceof DuplicateUserEmailAddressException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            if (e instanceof OpenIDException) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Error communicating with OpenID provider: " + e.getMessage()));
                }
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            _log.error((Object)"Error processing the OpenID login", (Throwable)e);
            PortalUtil.sendError((Exception)e, (ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        renderResponse.setTitle(themeDisplay.translate("open-id"));
        return mapping.findForward("portlet.login.open_id");
    }

    protected String getFirstValue(List<String> values) {
        if (values == null || values.size() < 1) {
            return null;
        }
        return values.get(0);
    }

    @Override
    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected String readOpenIdResponse(ThemeDisplay themeDisplay, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        MessageExtension ext;
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        HttpSession session = request.getSession();
        ActionResponseImpl actionResponseImpl = (ActionResponseImpl)actionResponse;
        ConsumerManager manager = OpenIdUtil.getConsumerManager();
        ParameterList params = new ParameterList(actionRequest.getParameterMap());
        DiscoveryInformation discovered = (DiscoveryInformation)session.getAttribute("openid-disco");
        if (discovered == null) {
            return null;
        }
        PortletURL portletURL = actionResponseImpl.createActionURL();
        portletURL.setParameter("struts_action", "/login/open_id");
        portletURL.setParameter("cmd", "read");
        portletURL.setParameter("saveLastPath", "0");
        VerificationResult verification = manager.verify(portletURL.toString(), params, discovered);
        Identifier verified = verification.getVerifiedId();
        if (verified == null) {
            return null;
        }
        AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
        String firstName = null;
        String lastName = null;
        String emailAddress = null;
        if (authSuccess.hasExtension("http://openid.net/sreg/1.0") && (ext = authSuccess.getExtension("http://openid.net/sreg/1.0")) instanceof SRegResponse) {
            SRegResponse sregResp = (SRegResponse)ext;
            String fullName = GetterUtil.getString((String)sregResp.getAttributeValue("fullname"));
            int pos = fullName.indexOf(" ");
            if (pos != -1 && pos + 1 < fullName.length()) {
                firstName = fullName.substring(0, pos);
                lastName = fullName.substring(pos + 1);
            }
            emailAddress = sregResp.getAttributeValue("email");
        }
        if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0-draft4") && (ext = authSuccess.getExtension("http://openid.net/srv/ax/1.0-draft4")) instanceof FetchResponse) {
            FetchResponse fetchResp = (FetchResponse)ext;
            if (Validator.isNull(firstName)) {
                firstName = this.getFirstValue(fetchResp.getAttributeValues("firstName"));
            }
            if (Validator.isNull(lastName)) {
                lastName = this.getFirstValue(fetchResp.getAttributeValues("lastName"));
            }
            if (Validator.isNull(emailAddress)) {
                emailAddress = this.getFirstValue(fetchResp.getAttributeValues("email"));
            }
        }
        String openId = OpenIdUtil.normalize(authSuccess.getIdentity());
        User user = null;
        try {
            user = UserLocalServiceUtil.getUserByOpenId((String)openId);
        }
        catch (NoSuchUserException nsue) {
            String password1;
            if (Validator.isNull(firstName) || Validator.isNull(lastName) || Validator.isNull(emailAddress)) {
                SessionMessages.add((HttpServletRequest)request, (String)"missingOpenIdUserInformation");
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"The OpenID provider did not send the required attributes to create an account");
                }
                PortletURL createAccountURL = themeDisplay.getURLCreateAccount();
                createAccountURL.setParameter("openId", openId);
                session.setAttribute("OPEN_ID_LOGIN_PENDING", (Object)Boolean.TRUE);
                return createAccountURL.toString();
            }
            long creatorUserId = 0L;
            long companyId = themeDisplay.getCompanyId();
            boolean autoPassword = false;
            String password2 = password1 = PwdGenerator.getPassword();
            boolean autoScreenName = true;
            String screenName = "";
            Locale locale = themeDisplay.getLocale();
            String middleName = "";
            int prefixId = 0;
            int suffixId = 0;
            boolean male = true;
            int birthdayMonth = 0;
            int birthdayDay = 1;
            int birthdayYear = 1970;
            String jobTitle = "";
            long[] groupIds = null;
            long[] organizationIds = null;
            long[] roleIds = null;
            long[] userGroupIds = null;
            boolean sendEmail = false;
            ServiceContext serviceContext = new ServiceContext();
            user = UserLocalServiceUtil.addUser((long)creatorUserId, (long)companyId, (boolean)autoPassword, (String)password1, (String)password2, (boolean)autoScreenName, (String)screenName, (String)emailAddress, (String)openId, (Locale)locale, (String)firstName, (String)middleName, (String)lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)jobTitle, groupIds, organizationIds, roleIds, userGroupIds, (boolean)sendEmail, (ServiceContext)serviceContext);
        }
        session.setAttribute("OPEN_ID_LOGIN", (Object)new Long(user.getUserId()));
        return null;
    }

    protected void sendOpenIdRequest(ThemeDisplay themeDisplay, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        if (!OpenIdUtil.isEnabled(themeDisplay.getCompanyId())) {
            return;
        }
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        HttpSession session = request.getSession();
        ActionResponseImpl actionResponseImpl = (ActionResponseImpl)actionResponse;
        String openId = ParamUtil.getString((PortletRequest)actionRequest, (String)"openId");
        PortletURL portletURL = actionResponseImpl.createActionURL();
        portletURL.setParameter("struts_action", "/login/open_id");
        portletURL.setParameter("cmd", "read");
        portletURL.setParameter("saveLastPath", "0");
        ConsumerManager manager = OpenIdUtil.getConsumerManager();
        List discoveries = manager.discover(openId);
        DiscoveryInformation discovered = manager.associate(discoveries);
        session.setAttribute("openid-disco", (Object)discovered);
        AuthRequest authRequest = manager.authenticate(discovered, portletURL.toString(), themeDisplay.getPortalURL());
        try {
            UserLocalServiceUtil.getUserByOpenId((String)openId);
        }
        catch (NoSuchUserException nsue) {
            String screenName = OpenIdUtil.getScreenName(openId);
            try {
                User user = UserLocalServiceUtil.getUserByScreenName((long)themeDisplay.getCompanyId(), (String)screenName);
                UserLocalServiceUtil.updateOpenId((long)user.getUserId(), (String)openId);
            }
            catch (NoSuchUserException nsue2) {
                FetchRequest fetch = FetchRequest.createFetchRequest();
                fetch.addAttribute("email", "http://schema.openid.net/contact/email", true);
                fetch.addAttribute("firstName", "http://schema.openid.net/namePerson/first", true);
                fetch.addAttribute("lastName", "http://schema.openid.net/namePerson/last", true);
                authRequest.addExtension((MessageExtension)fetch);
                SRegRequest sregRequest = SRegRequest.createFetchRequest();
                sregRequest.addAttribute("fullname", true);
                sregRequest.addAttribute("email", true);
                authRequest.addExtension((MessageExtension)sregRequest);
            }
        }
        response.sendRedirect(authRequest.getDestinationUrl(true));
    }
}

