/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.BaseFriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBFriendlyURLMapper
extends BaseFriendlyURLMapper {
    private static final String _MAPPING = "message_boards";
    private static final String _PORTLET_ID = "19";
    private static Log _log = LogFactoryUtil.getLog(MBFriendlyURLMapper.class);

    public String buildPath(LiferayPortletURL portletURL) {
        String friendlyURLPath = null;
        String tabs1 = GetterUtil.getString((String)portletURL.getParameter("tabs1"));
        String tabs2 = GetterUtil.getString((String)portletURL.getParameter("tabs2"));
        if (Validator.isNotNull((String)tabs2)) {
            return null;
        }
        String strutsAction = GetterUtil.getString((String)portletURL.getParameter("struts_action"));
        if (strutsAction.equals("/message_boards/search")) {
            friendlyURLPath = "/message_boards/search";
        } else if (strutsAction.equals("/message_boards/view")) {
            String categoryId = GetterUtil.getString((String)portletURL.getParameter("categoryId"));
            if (Validator.isNotNull((String)categoryId) && !categoryId.equals("0")) {
                friendlyURLPath = "/message_boards/category/" + categoryId;
                portletURL.addParameterIncludedInPath("categoryId");
            } else {
                friendlyURLPath = "/message_boards";
                if (Validator.isNotNull((String)tabs1) && !tabs1.equals("categories")) {
                    friendlyURLPath = friendlyURLPath + "/" + tabs1;
                }
                portletURL.addParameterIncludedInPath("tabs1");
                if (categoryId.equals("0")) {
                    portletURL.addParameterIncludedInPath("categoryId");
                }
            }
        } else if (strutsAction.equals("/message_boards/view_message")) {
            String messageId = portletURL.getParameter("messageId");
            if (Validator.isNotNull((String)messageId)) {
                friendlyURLPath = "/message_boards/message/" + messageId;
                portletURL.addParameterIncludedInPath("messageId");
            }
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Struts action " + strutsAction + " does not have a friendly URL path "));
        }
        if (Validator.isNotNull((String)friendlyURLPath)) {
            WindowState windowState = portletURL.getWindowState();
            if (!windowState.equals((Object)WindowState.NORMAL)) {
                friendlyURLPath = friendlyURLPath + "/" + windowState;
            }
            portletURL.addParameterIncludedInPath("p_p_id");
            portletURL.addParameterIncludedInPath("struts_action");
        }
        return friendlyURLPath;
    }

    public String getMapping() {
        return _MAPPING;
    }

    public String getPortletId() {
        return _PORTLET_ID;
    }

    public void populateParams(String friendlyURLPath, Map<String, String[]> params) {
        String type;
        int z;
        this.addParam(params, "p_p_id", _PORTLET_ID);
        this.addParam(params, "p_p_lifecycle", "0");
        this.addParam(params, "p_p_mode", PortletMode.VIEW);
        int x = friendlyURLPath.indexOf("/", 1);
        if (x + 1 == friendlyURLPath.length()) {
            this.addParam(params, "struts_action", "/message_boards/view");
            this.addParam(params, "categoryId", MBCategoryImpl.DEFAULT_PARENT_CATEGORY_ID);
            return;
        }
        int y = friendlyURLPath.indexOf("/", x + 1);
        if (y == -1) {
            y = friendlyURLPath.length();
        }
        if ((z = friendlyURLPath.indexOf("/", y + 1)) == -1) {
            z = friendlyURLPath.length();
        }
        if ((type = friendlyURLPath.substring(x + 1, y)).equals("category")) {
            String categoryId = friendlyURLPath.substring(y + 1, z);
            this.addParam(params, "struts_action", "/message_boards/view");
            this.addParam(params, "categoryId", categoryId);
        } else if (type.equals("message")) {
            String messageId = friendlyURLPath.substring(y + 1, z);
            this.addParam(params, "struts_action", "/message_boards/view_message");
            this.addParam(params, "messageId", messageId);
        } else if (type.equals("my_posts") || type.equals("my_subscriptions") || type.equals("recent_posts") || type.equals("statistics") || type.equals("banned_users")) {
            this.addParam(params, "struts_action", "/message_boards/view");
            this.addParam(params, "tabs1", type);
        } else if (type.equals("search")) {
            this.addParam(params, "struts_action", "/message_boards/search");
            this.addParam(params, "tabs1", "categories");
        }
        if (friendlyURLPath.indexOf("maximized", x) != -1) {
            this.addParam(params, "p_p_state", WindowState.MAXIMIZED);
        }
    }
}

