/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.BaseConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.util.LocalizationUtil;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class ConfigurationActionImpl
extends BaseConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (!cmd.equals("update")) {
            return;
        }
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portletResource);
        String tabs2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs2");
        if (tabs2.equals("email-from")) {
            this.updateEmailFrom(actionRequest, preferences);
        } else if (tabs2.equals("general")) {
            this.updateGeneral(actionRequest, preferences);
        } else if (tabs2.equals("message-added-email")) {
            this.updateEmailMessageAdded(actionRequest, preferences);
        } else if (tabs2.equals("message-updated-email")) {
            this.updateEmailMessageUpdated(actionRequest, preferences);
        } else if (tabs2.equals("rss")) {
            this.updateRSS(actionRequest, preferences);
        } else if (tabs2.equals("thread-priorities")) {
            this.updateThreadPriorities(actionRequest, preferences);
        } else if (tabs2.equals("user-ranks")) {
            this.updateUserRanks(actionRequest, preferences);
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            preferences.store();
            SessionMessages.add((PortletRequest)actionRequest, (String)(portletConfig.getPortletName() + ".doConfigure"));
        }
    }

    public String render(PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return "/html/portlet/message_boards/configuration.jsp";
    }

    protected void updateEmailFrom(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String emailFromName = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailFromName");
        String emailFromAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailFromAddress");
        boolean emailHtmlFormat = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"emailHtmlFormat");
        if (Validator.isNull((String)emailFromName)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFromName");
        } else if (!Validator.isEmailAddress((String)emailFromAddress) && !Validator.isVariableTerm((String)emailFromAddress)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailFromAddress");
        } else {
            preferences.setValue("email-from-name", emailFromName);
            preferences.setValue("email-from-address", emailFromAddress);
            preferences.setValue("email-html-format", String.valueOf(emailHtmlFormat));
        }
    }

    protected void updateEmailMessageAdded(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean emailMessageAddedEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"emailMessageAddedEnabled");
        String emailMessageAddedSubjectPrefix = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailMessageAddedSubjectPrefix");
        String emailMessageAddedBody = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailMessageAddedBody");
        String emailMessageAddedSignature = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailMessageAddedSignature");
        if (Validator.isNull((String)emailMessageAddedSubjectPrefix)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailMessageAddedSubjectPrefix");
        } else if (Validator.isNull((String)emailMessageAddedBody)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailMessageAddedBody");
        } else {
            preferences.setValue("email-message-added-enabled", String.valueOf(emailMessageAddedEnabled));
            preferences.setValue("email-message-added-subject-prefix", emailMessageAddedSubjectPrefix);
            preferences.setValue("email-message-added-body", emailMessageAddedBody);
            preferences.setValue("email-message-added-signature", emailMessageAddedSignature);
        }
    }

    protected void updateEmailMessageUpdated(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean emailMessageUpdatedEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"emailMessageUpdatedEnabled");
        String emailMessageUpdatedSubjectPrefix = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailMessageUpdatedSubjectPrefix");
        String emailMessageUpdatedBody = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailMessageUpdatedBody");
        String emailMessageUpdatedSignature = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailMessageUpdatedSignature");
        if (Validator.isNull((String)emailMessageUpdatedSubjectPrefix)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailMessageUpdatedSubjectPrefix");
        } else if (Validator.isNull((String)emailMessageUpdatedBody)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"emailMessageUpdatedBody");
        } else {
            preferences.setValue("email-message-updated-enabled", String.valueOf(emailMessageUpdatedEnabled));
            preferences.setValue("email-message-updated-subject-prefix", emailMessageUpdatedSubjectPrefix);
            preferences.setValue("email-message-updated-body", emailMessageUpdatedBody);
            preferences.setValue("email-message-updated-signature", emailMessageUpdatedSignature);
        }
    }

    protected void updateGeneral(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String allowAnonymousPosting = ParamUtil.getString((PortletRequest)actionRequest, (String)"allowAnonymousPosting");
        String enableFlags = ParamUtil.getString((PortletRequest)actionRequest, (String)"enableFlags");
        boolean enableRatings = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enableRatings");
        preferences.setValue("allow-anonymous-posting", allowAnonymousPosting);
        preferences.setValue("enable-flags", enableFlags);
        preferences.setValue("enable-message-ratings", String.valueOf(enableRatings));
    }

    protected void updateRSS(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        int rssDelta = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"rssDelta");
        String rssDisplayStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"rssDisplayStyle");
        String rssFormat = ParamUtil.getString((PortletRequest)actionRequest, (String)"rssFormat");
        preferences.setValue("rss-delta", String.valueOf(rssDelta));
        preferences.setValue("rss-display-style", rssDisplayStyle);
        preferences.setValue("rss-format", rssFormat);
    }

    protected void updateThreadPriorities(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        Locale[] locales = LanguageUtil.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            String languageId = LocaleUtil.toLanguageId((Locale)locales[i]);
            ArrayList<String> priorities = new ArrayList<String>();
            for (int j = 0; j < 10; ++j) {
                String name = ParamUtil.getString((PortletRequest)actionRequest, (String)("priorityName" + j + "_" + languageId));
                String image = ParamUtil.getString((PortletRequest)actionRequest, (String)("priorityImage" + j + "_" + languageId));
                double value = ParamUtil.getDouble((PortletRequest)actionRequest, (String)("priorityValue" + j + "_" + languageId));
                if (!Validator.isNotNull((String)name) && !Validator.isNotNull((String)image) && value == 0.0) continue;
                priorities.add(name + "," + image + "," + value);
            }
            LocalizationUtil.setPreferencesValues((PortletPreferences)preferences, (String)"priorities", (String)languageId, (String[])priorities.toArray(new String[priorities.size()]));
        }
    }

    protected void updateUserRanks(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        Locale[] locales = LanguageUtil.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            String kvpValue;
            String languageId = LocaleUtil.toLanguageId((Locale)locales[i]);
            String[] ranks = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)("ranks_" + languageId)), (String)"\n");
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (int j = 0; j < ranks.length; ++j) {
                String[] kvp = StringUtil.split((String)ranks[j], (String)"=");
                String kvpName = kvp[0];
                kvpValue = kvp[1];
                map.put(kvpValue, kvpName);
            }
            ranks = new String[map.size()];
            int count = 0;
            for (Map.Entry entry : map.entrySet()) {
                kvpValue = (String)entry.getKey();
                String kvpName = (String)entry.getValue();
                ranks[count++] = kvpName + "=" + kvpValue;
            }
            LocalizationUtil.setPreferencesValues((PortletPreferences)preferences, (String)"ranks", (String)languageId, (String[])ranks);
        }
    }
}

