/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.lar;

import com.liferay.documentlibrary.service.DLServiceUtil;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.BasePortletDataHandler;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataException;
import com.liferay.portal.lar.PortletDataHandlerBoolean;
import com.liferay.portal.lar.PortletDataHandlerControl;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.UserUtil;
import com.liferay.portlet.messageboards.NoSuchCategoryException;
import com.liferay.portlet.messageboards.NoSuchMessageException;
import com.liferay.portlet.messageboards.NoSuchThreadException;
import com.liferay.portlet.messageboards.model.MBBan;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageFlag;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.service.MBBanLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageFlagLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.persistence.MBBanUtil;
import com.liferay.portlet.messageboards.service.persistence.MBCategoryUtil;
import com.liferay.portlet.messageboards.service.persistence.MBMessageFlagUtil;
import com.liferay.portlet.messageboards.service.persistence.MBMessageUtil;
import com.liferay.portlet.messageboards.service.persistence.MBThreadUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "message_board";
    private static final PortletDataHandlerBoolean _categoriesAndMessages = new PortletDataHandlerBoolean("message_board", "categories-and-messages", true, true);
    private static final PortletDataHandlerBoolean _attachments = new PortletDataHandlerBoolean("message_board", "attachments");
    private static final PortletDataHandlerBoolean _userBans = new PortletDataHandlerBoolean("message_board", "user-bans");
    private static final PortletDataHandlerBoolean _flags = new PortletDataHandlerBoolean("message_board", "flags");
    private static final PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("message_board", "ratings");
    private static final PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("message_board", "tags");
    private static Log _log = LogFactoryUtil.getLog(MBPortletDataHandlerImpl.class);

    public PortletPreferences deleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            if (!context.addPrimaryKey(MBPortletDataHandlerImpl.class, "deleteData")) {
                MBCategoryLocalServiceUtil.deleteCategories((long)context.getGroupId());
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public String exportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("message-boards-data");
            root.addAttribute("group-id", String.valueOf(context.getGroupId()));
            Element categoriesEl = root.addElement("categories");
            Element messagesEl = root.addElement("messages");
            Element messageFlagsEl = root.addElement("message-flags");
            Element userBansEl = root.addElement("user-bans");
            List categories = MBCategoryUtil.findByGroupId((long)context.getGroupId());
            for (MBCategory category : categories) {
                this.exportCategory(context, categoriesEl, messagesEl, messageFlagsEl, category);
            }
            if (context.getBooleanParameter(_NAMESPACE, "user-bans")) {
                List bans = MBBanUtil.findByGroupId((long)context.getGroupId());
                for (MBBan ban : bans) {
                    this.exportUserBan(context, userBansEl, ban);
                }
            }
            return doc.formattedString();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_categoriesAndMessages, _attachments, _userBans, _flags, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_categoriesAndMessages, _attachments, _userBans, _flags, _ratings, _tags};
    }

    public PortletPreferences importData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws PortletDataException {
        try {
            String path;
            Document doc = SAXReaderUtil.read((String)data);
            Element root = doc.getRootElement();
            List categoryEls = root.element("categories").elements("category");
            Map categoryPKs = context.getNewPrimaryKeysMap(MBCategory.class);
            for (Element categoryEl : categoryEls) {
                String path2 = categoryEl.attributeValue("path");
                if (!context.isPathNotProcessed(path2)) continue;
                MBCategory category = (MBCategory)context.getZipEntryAsObject(path2);
                this.importCategory(context, categoryPKs, category);
            }
            List messageEls = root.element("messages").elements("message");
            Map threadPKs = context.getNewPrimaryKeysMap(MBThread.class);
            Map messagePKs = context.getNewPrimaryKeysMap(MBMessage.class);
            for (Element messageEl : messageEls) {
                String path3 = messageEl.attributeValue("path");
                if (!context.isPathNotProcessed(path3)) continue;
                MBMessage message = (MBMessage)context.getZipEntryAsObject(path3);
                this.importMessage(context, categoryPKs, threadPKs, messagePKs, messageEl, message);
            }
            if (context.getBooleanParameter(_NAMESPACE, "flags")) {
                List flagEls = root.element("message-flags").elements("flag");
                for (Element flagEl : flagEls) {
                    path = flagEl.attributeValue("path");
                    if (!context.isPathNotProcessed(path)) continue;
                    MBMessageFlag flag = (MBMessageFlag)context.getZipEntryAsObject(path);
                    this.importFlag(context, messagePKs, flag);
                }
            }
            if (context.getBooleanParameter(_NAMESPACE, "user-bans")) {
                List banEls = root.element("user-bans").elements("user-ban");
                for (Element banEl : banEls) {
                    path = banEl.attributeValue("path");
                    if (!context.isPathNotProcessed(path)) continue;
                    MBBan ban = (MBBan)context.getZipEntryAsObject(path);
                    this.importBan(context, ban);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    protected void exportCategory(PortletDataContext context, Element categoriesEl, Element messagesEl, Element messageFlagsEl, MBCategory category) throws PortalException, SystemException {
        if (context.isWithinDateRange(category.getModifiedDate())) {
            this.exportParentCategory(context, categoriesEl, category.getParentCategoryId());
            String path = this.getCategoryPath(context, category);
            if (context.isPathNotProcessed(path)) {
                Element categoryEl = categoriesEl.addElement("category");
                categoryEl.addAttribute("path", path);
                category.setUserUuid(category.getUserUuid());
                context.addZipEntry(path, (Object)category);
            }
        }
        List messages = MBMessageUtil.findByCategoryId((long)category.getCategoryId());
        for (MBMessage message : messages) {
            this.exportMessage(context, categoriesEl, messagesEl, messageFlagsEl, message);
        }
    }

    protected void exportMessage(PortletDataContext context, Element categoriesEl, Element messagesEl, Element messageFlagsEl, MBMessage message) throws PortalException, SystemException {
        if (!context.isWithinDateRange(message.getModifiedDate())) {
            return;
        }
        this.exportParentCategory(context, categoriesEl, message.getCategoryId());
        String path = this.getMessagePath(context, message);
        if (context.isPathNotProcessed(path)) {
            Element messageEl = messagesEl.addElement("message");
            messageEl.addAttribute("path", path);
            message.setUserUuid(message.getUserUuid());
            message.setPriority(message.getPriority());
            if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
                context.addRatingsEntries(MBMessage.class, message.getMessageId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "tags")) {
                context.addTagsEntries(MBMessage.class, message.getMessageId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "attachments") && message.isAttachments()) {
                for (String attachment : message.getAttachmentsFiles()) {
                    int pos = attachment.lastIndexOf("/");
                    String name = attachment.substring(pos + 1);
                    String binPath = this.getMessageAttachementBinPath(context, message, name);
                    Element attachmentEl = messageEl.addElement("attachment");
                    attachmentEl.addAttribute("name", name);
                    attachmentEl.addAttribute("bin-path", binPath);
                    byte[] bytes = DLServiceUtil.getFile((long)context.getCompanyId(), (long)0L, (String)attachment);
                    context.addZipEntry(binPath, bytes);
                }
                message.setAttachmentsDir(message.getAttachmentsDir());
            }
            if (context.getBooleanParameter(_NAMESPACE, "flags")) {
                List messageFlags = MBMessageFlagUtil.findByMessageId((long)message.getMessageId());
                for (MBMessageFlag messageFlag : messageFlags) {
                    this.exportMessageFlag(context, messageFlagsEl, messageFlag);
                }
            }
            context.addZipEntry(path, (Object)message);
        }
    }

    protected void exportMessageFlag(PortletDataContext context, Element messageFlagsEl, MBMessageFlag messageFlag) throws SystemException {
        String path = this.getMessageFlagPath(context, messageFlag);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element messageFlagEl = messageFlagsEl.addElement("message-flag");
        messageFlagEl.addAttribute("path", path);
        messageFlag.setUserUuid(messageFlag.getUserUuid());
        context.addZipEntry(path, (Object)messageFlag);
    }

    protected void exportParentCategory(PortletDataContext context, Element categoriesEl, long categoryId) throws PortalException, SystemException {
        if (!context.hasDateRange() || categoryId == MBCategoryImpl.DEFAULT_PARENT_CATEGORY_ID) {
            return;
        }
        MBCategory category = MBCategoryUtil.findByPrimaryKey((long)categoryId);
        this.exportParentCategory(context, categoriesEl, category.getParentCategoryId());
        String path = this.getCategoryPath(context, category);
        if (context.isPathNotProcessed(path)) {
            Element categoryEl = categoriesEl.addElement("category");
            categoryEl.addAttribute("path", path);
            category.setUserUuid(category.getUserUuid());
            context.addZipEntry(path, (Object)category);
        }
    }

    protected void exportUserBan(PortletDataContext context, Element userBansEl, MBBan ban) throws SystemException {
        if (!context.isWithinDateRange(ban.getModifiedDate())) {
            return;
        }
        String path = this.getUserBanPath(context, ban);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element userBanEl = userBansEl.addElement("user-ban");
        userBanEl.addAttribute("path", path);
        ban.setBanUserUuid(ban.getBanUserUuid());
        ban.setUserUuid(ban.getUserUuid());
        context.addZipEntry(path, (Object)ban);
    }

    protected void importBan(PortletDataContext context, MBBan ban) throws Exception {
        long userId = context.getUserId(ban.getUserUuid());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(context.getGroupId());
        List users = UserUtil.findByUuid((String)ban.getBanUserUuid());
        Iterator itr = users.iterator();
        if (itr.hasNext()) {
            User user = (User)itr.next();
            MBBanLocalServiceUtil.addBan((long)userId, (long)user.getUserId(), (ServiceContext)serviceContext);
        } else {
            _log.error((Object)("Could not find banned user with uuid " + ban.getBanUserUuid()));
        }
    }

    protected void importCategory(PortletDataContext context, Map<Long, Long> categoryPKs, MBCategory category) throws Exception {
        long userId = context.getUserId(category.getUserUuid());
        long parentCategoryId = MapUtil.getLong(categoryPKs, (long)category.getParentCategoryId(), (long)category.getParentCategoryId());
        String emailAddress = null;
        String inProtocol = null;
        String inServerName = null;
        int inServerPort = 0;
        boolean inUseSSL = false;
        String inUserName = null;
        String inPassword = null;
        int inReadInterval = 0;
        String outEmailAddress = null;
        boolean outCustom = false;
        String outServerName = null;
        int outServerPort = 0;
        boolean outUseSSL = false;
        String outUserName = null;
        String outPassword = null;
        boolean mailingListActive = false;
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(context.getGroupId());
        if (parentCategoryId != MBCategoryImpl.DEFAULT_PARENT_CATEGORY_ID && parentCategoryId == category.getParentCategoryId()) {
            String path = this.getImportCategoryPath(context, parentCategoryId);
            MBCategory parentCategory = (MBCategory)context.getZipEntryAsObject(path);
            this.importCategory(context, categoryPKs, parentCategory);
            parentCategoryId = MapUtil.getLong(categoryPKs, (long)category.getParentCategoryId(), (long)category.getParentCategoryId());
        }
        MBCategory existingCategory = null;
        try {
            if (parentCategoryId != MBCategoryImpl.DEFAULT_PARENT_CATEGORY_ID) {
                MBCategoryUtil.findByPrimaryKey((long)parentCategoryId);
            }
            existingCategory = context.getDataStrategy().equals("DATA_STRATEGY_MIRROR") ? ((existingCategory = MBCategoryUtil.fetchByUUID_G((String)category.getUuid(), (long)context.getGroupId())) == null ? MBCategoryLocalServiceUtil.addCategory((String)category.getUuid(), (long)userId, (long)parentCategoryId, (String)category.getName(), (String)category.getDescription(), emailAddress, inProtocol, inServerName, (int)inServerPort, (boolean)inUseSSL, inUserName, inPassword, (int)inReadInterval, outEmailAddress, (boolean)outCustom, outServerName, (int)outServerPort, (boolean)outUseSSL, outUserName, outPassword, (boolean)mailingListActive, (ServiceContext)serviceContext) : MBCategoryLocalServiceUtil.updateCategory((long)existingCategory.getCategoryId(), (long)parentCategoryId, (String)category.getName(), (String)category.getDescription(), emailAddress, inProtocol, inServerName, (int)inServerPort, (boolean)inUseSSL, inUserName, inPassword, (int)inReadInterval, outEmailAddress, (boolean)outCustom, outServerName, (int)outServerPort, (boolean)outUseSSL, outUserName, outPassword, (boolean)mailingListActive, (boolean)false)) : MBCategoryLocalServiceUtil.addCategory((long)userId, (long)parentCategoryId, (String)category.getName(), (String)category.getDescription(), emailAddress, inProtocol, inServerName, (int)inServerPort, (boolean)inUseSSL, inUserName, inPassword, (int)inReadInterval, outEmailAddress, (boolean)outCustom, outServerName, (int)outServerPort, (boolean)outUseSSL, outUserName, outPassword, (boolean)mailingListActive, (ServiceContext)serviceContext);
            categoryPKs.put(category.getCategoryId(), existingCategory.getCategoryId());
        }
        catch (NoSuchCategoryException nsce) {
            _log.error((Object)("Could not find the parent category for category " + category.getCategoryId()));
        }
    }

    protected void importFlag(PortletDataContext context, Map<Long, Long> messagePKs, MBMessageFlag flag) throws Exception {
        long userId = context.getUserId(flag.getUserUuid());
        long messageId = MapUtil.getLong(messagePKs, (long)flag.getMessageId(), (long)flag.getMessageId());
        try {
            MBMessage message = MBMessageUtil.findByPrimaryKey((long)messageId);
            MBThread thread = message.getThread();
            MBMessageFlagLocalServiceUtil.addReadFlags((long)userId, (MBThread)thread);
        }
        catch (NoSuchMessageException nsme) {
            _log.error((Object)("Could not find the message for flag " + flag.getMessageFlagId()));
        }
    }

    protected void importMessage(PortletDataContext context, Map<Long, Long> categoryPKs, Map<Long, Long> threadPKs, Map<Long, Long> messagePKs, Element messageEl, MBMessage message) throws Exception {
        long userId = context.getUserId(message.getUserUuid());
        String userName = message.getUserName();
        long categoryId = MapUtil.getLong(categoryPKs, (long)message.getCategoryId(), (long)message.getCategoryId());
        long threadId = MapUtil.getLong(threadPKs, (long)message.getThreadId(), (long)message.getThreadId());
        long parentMessageId = MapUtil.getLong(messagePKs, (long)message.getParentMessageId(), (long)message.getParentMessageId());
        ArrayList<ObjectValuePair> files = new ArrayList<ObjectValuePair>();
        ArrayList existingFiles = new ArrayList();
        if (context.getBooleanParameter(_NAMESPACE, "attachments") && message.isAttachments()) {
            List attachmentEls = messageEl.elements("attachment");
            for (Element attachmentEl : attachmentEls) {
                String name = attachmentEl.attributeValue("name");
                String binPath = attachmentEl.attributeValue("bin-path");
                byte[] bytes = context.getZipEntryAsByteArray(binPath);
                files.add(new ObjectValuePair((Object)name, (Object)bytes));
            }
            if (files.size() <= 0) {
                _log.error((Object)("Could not find attachments for message " + message.getMessageId()));
            }
        }
        String[] tagsEntries = null;
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            tagsEntries = context.getTagsEntries(MBMessage.class, message.getMessageId());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(context.getGroupId());
        serviceContext.setTagsEntries(tagsEntries);
        if (categoryId != MBCategoryImpl.DEFAULT_PARENT_CATEGORY_ID && categoryId == message.getCategoryId()) {
            String path = this.getImportCategoryPath(context, categoryId);
            MBCategory category = (MBCategory)context.getZipEntryAsObject(path);
            this.importCategory(context, categoryPKs, category);
            categoryId = MapUtil.getLong(categoryPKs, (long)message.getCategoryId(), (long)message.getCategoryId());
        }
        MBMessage existingMessage = null;
        try {
            MBCategoryUtil.findByPrimaryKey((long)categoryId);
            if (parentMessageId != 0L) {
                MBMessageUtil.findByPrimaryKey((long)parentMessageId);
                MBThreadUtil.findByPrimaryKey((long)threadId);
            }
            if (context.getDataStrategy().equals("DATA_STRATEGY_MIRROR")) {
                try {
                    existingMessage = MBMessageUtil.findByUUID_G((String)message.getUuid(), (long)context.getGroupId());
                    MBMessageLocalServiceUtil.updateMessage((long)userId, (long)existingMessage.getMessageId(), (String)message.getSubject(), (String)message.getBody(), files, existingFiles, (double)message.getPriority(), (ServiceContext)serviceContext);
                }
                catch (NoSuchMessageException nsme) {
                    existingMessage = MBMessageLocalServiceUtil.addMessage((String)message.getUuid(), (long)userId, (String)userName, (long)categoryId, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), files, (boolean)message.getAnonymous(), (double)message.getPriority(), (ServiceContext)serviceContext);
                }
            } else {
                existingMessage = MBMessageLocalServiceUtil.addMessage((long)userId, (String)userName, (long)categoryId, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), files, (boolean)message.getAnonymous(), (double)message.getPriority(), (ServiceContext)serviceContext);
            }
            threadPKs.put(message.getThreadId(), existingMessage.getThreadId());
            messagePKs.put(message.getMessageId(), existingMessage.getMessageId());
            if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
                context.importRatingsEntries(MBMessage.class, message.getMessageId(), existingMessage.getMessageId());
            }
        }
        catch (NoSuchCategoryException nsce) {
            _log.error((Object)("Could not find the parent category for message " + message.getMessageId()));
        }
        catch (NoSuchMessageException nsme) {
            _log.error((Object)("Could not find the parent message for message " + message.getMessageId()));
        }
        catch (NoSuchThreadException nste) {
            _log.error((Object)("Could not find the thread for message " + message.getMessageId()));
        }
    }

    protected String getCategoryPath(PortletDataContext context, MBCategory category) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("19"));
        sb.append("/categories/");
        sb.append(category.getCategoryId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getImportCategoryPath(PortletDataContext context, long categoryId) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getSourcePortletPath("19"));
        sb.append("/categories/");
        sb.append(categoryId);
        sb.append(".xml");
        return sb.toString();
    }

    protected String getMessageAttachementBinPath(PortletDataContext context, MBMessage message, String attachment) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("19"));
        sb.append("/bin/");
        sb.append(message.getMessageId());
        sb.append("/");
        sb.append(attachment);
        return sb.toString();
    }

    protected String getMessageFlagPath(PortletDataContext context, MBMessageFlag messageFlag) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("19"));
        sb.append("/message-flags/");
        sb.append(messageFlag.getMessageFlagId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getMessagePath(PortletDataContext context, MBMessage message) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("19"));
        sb.append("/messages/");
        sb.append(message.getMessageId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getUserBanPath(PortletDataContext context, MBBan ban) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("19"));
        sb.append("/user-bans/");
        sb.append(ban.getBanId());
        sb.append(".xml");
        return sb.toString();
    }
}

