/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.messaging;

import com.liferay.mail.service.MailServiceUtil;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.Account;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.mail.SMTPAccount;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Subscription;
import com.liferay.portal.model.User;
import com.liferay.portal.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.messageboards.NoSuchMailingListException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMailingList;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBMailingListLocalServiceUtil;
import com.liferay.portlet.messageboards.util.BBCodeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBMessageListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(MBMessageListener.class);

    public void receive(Message message) {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to process message " + message), (Throwable)e);
        }
    }

    protected void doReceive(Message message) throws Exception {
        long[] categoryIdsArray;
        long companyId = message.getLong("companyId");
        long userId = message.getLong("userId");
        String categoryIds = message.getString("categoryIds");
        String threadId = message.getString("threadId");
        String fromName = message.getString("fromName");
        String fromAddress = message.getString("fromAddress");
        String subject = message.getString("subject");
        String body = message.getString("body");
        String replyToAddress = message.getString("replyToAddress");
        String mailId = message.getString("mailId");
        String inReplyTo = message.getString("inReplyTo");
        boolean htmlFormat = message.getBoolean("htmlFormat");
        boolean sourceMailingList = message.getBoolean("sourceMailingList");
        if (sourceMailingList) {
            subject = this.getMailingListSubject(subject, mailId);
        }
        HashSet<Long> sent = new HashSet<Long>();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Sending notifications for {mailId=" + mailId + ", threadId=" + threadId + ", categoryIds=" + categoryIds + "}"));
        }
        List subscriptions = SubscriptionLocalServiceUtil.getSubscriptions((long)companyId, (String)MBThread.class.getName(), (long)GetterUtil.getLong((String)threadId));
        this.sendEmail(userId, fromName, fromAddress, subject, body, subscriptions, sent, replyToAddress, mailId, inReplyTo, htmlFormat);
        for (long categoryId : categoryIdsArray = StringUtil.split((String)categoryIds, (long)0L)) {
            subscriptions = SubscriptionLocalServiceUtil.getSubscriptions((long)companyId, (String)MBCategory.class.getName(), (long)categoryId);
            this.sendEmail(userId, fromName, fromAddress, subject, body, subscriptions, sent, replyToAddress, mailId, inReplyTo, htmlFormat);
        }
        if (!sourceMailingList) {
            for (long categoryId : categoryIdsArray) {
                try {
                    this.notifyMailingList(subject, body, replyToAddress, mailId, inReplyTo, htmlFormat, categoryId);
                }
                catch (NoSuchMailingListException nsmle) {
                    // empty catch block
                }
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Finished sending notifications");
        }
    }

    protected String getMailingListSubject(String subject, String mailId) {
        return subject + " " + mailId;
    }

    protected void notifyMailingList(String subject, String body, String replyToAddress, String mailId, String inReplyTo, boolean htmlFormat, long categoryId) throws Exception {
        MBMailingList mailingList = MBMailingListLocalServiceUtil.getCategoryMailingList((long)categoryId);
        if (!mailingList.isActive()) {
            return;
        }
        subject = this.getMailingListSubject(subject, mailId);
        String fromAddress = mailingList.getOutEmailAddress();
        InternetAddress[] bulkAddresses = new InternetAddress[]{new InternetAddress(mailingList.getEmailAddress())};
        SMTPAccount account = null;
        if (mailingList.isOutCustom()) {
            String protocol = "smtp";
            if (mailingList.isOutUseSSL()) {
                protocol = "smtps";
            }
            account = (SMTPAccount)Account.getInstance((String)protocol, (int)mailingList.getOutServerPort());
            account.setHost(mailingList.getOutServerName());
            account.setUser(mailingList.getOutUserName());
            account.setPassword(mailingList.getOutPassword());
        }
        this.sendMail(fromAddress, null, bulkAddresses, subject, body, replyToAddress, mailId, inReplyTo, htmlFormat, account);
    }

    protected void sendEmail(long userId, String fromName, String fromAddress, String subject, String body, List<Subscription> subscriptions, Set<Long> sent, String replyToAddress, String mailId, String inReplyTo, boolean htmlFormat) throws Exception {
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
        for (Subscription subscription : subscriptions) {
            long subscribedUserId = subscription.getUserId();
            if (sent.contains(subscribedUserId)) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Do not send a duplicate email to user " + subscribedUserId));
                continue;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Add user " + subscribedUserId + " to the list of users who have received an email"));
            }
            sent.add(subscribedUserId);
            User user = null;
            try {
                user = UserLocalServiceUtil.getUserById((long)subscription.getUserId());
            }
            catch (NoSuchUserException nsue) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Subscription " + subscription.getSubscriptionId() + " is stale and will be deleted"));
                }
                SubscriptionLocalServiceUtil.deleteSubscription((long)subscription.getSubscriptionId());
                continue;
            }
            if (!user.isActive()) continue;
            InternetAddress userAddress = new InternetAddress(user.getEmailAddress(), user.getFullName());
            addresses.add(userAddress);
        }
        InternetAddress[] bulkAddresses = addresses.toArray(new InternetAddress[addresses.size()]);
        this.sendMail(fromAddress, fromName, bulkAddresses, subject, body, replyToAddress, mailId, inReplyTo, htmlFormat, null);
    }

    protected void sendMail(String fromAddress, String fromName, InternetAddress[] bulkAddresses, String subject, String body, String replyToAddress, String mailId, String inReplyTo, boolean htmlFormat, SMTPAccount account) {
        try {
            if (bulkAddresses.length == 0) {
                return;
            }
            InternetAddress from = new InternetAddress(fromAddress, fromName);
            InternetAddress to = new InternetAddress(replyToAddress, replyToAddress);
            String curSubject = StringUtil.replace((String)subject, (String[])new String[]{"[$TO_ADDRESS$]", "[$TO_NAME$]"}, (String[])new String[]{replyToAddress, replyToAddress});
            String curBody = StringUtil.replace((String)body, (String[])new String[]{"[$TO_ADDRESS$]", "[$TO_NAME$]"}, (String[])new String[]{replyToAddress, replyToAddress});
            InternetAddress replyTo = new InternetAddress(replyToAddress, replyToAddress);
            if (htmlFormat) {
                try {
                    curBody = BBCodeUtil.getHTML(curBody);
                }
                catch (Exception e) {
                    _log.error((Object)("Could not parse message " + mailId + " " + e.getMessage()));
                }
            }
            MailMessage message = new MailMessage(from, to, curSubject, curBody, htmlFormat);
            message.setBulkAddresses(bulkAddresses);
            message.setMessageId(mailId);
            message.setInReplyTo(inReplyTo);
            message.setReplyTo(new InternetAddress[]{replyTo});
            message.setSMTPAccount(account);
            MailServiceUtil.sendEmail((MailMessage)message);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }
}

