/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.messaging;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.Account;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionCheckerUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.messageboards.NoSuchMessageException;
import com.liferay.portlet.messageboards.messaging.MailingListRequest;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import com.liferay.portlet.messageboards.util.MBMailMessage;
import com.liferay.portlet.messageboards.util.MBUtil;
import com.liferay.portlet.messageboards.util.MailingListThreadLocal;
import com.liferay.util.mail.MailEngine;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;

public class MailingListMessageListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(MailingListMessageListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message message) {
        MailingListRequest mailingListRequest = (MailingListRequest)JSONFactoryUtil.deserialize((String)((String)message.getPayload()));
        Folder folder = null;
        javax.mail.Message[] messages = null;
        try {
            folder = this.getFolder(mailingListRequest);
            messages = folder.getMessages();
            this.processMessages(mailingListRequest, messages);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        finally {
            if (folder != null && folder.isOpen()) {
                try {
                    folder.setFlags(messages, new Flags(Flags.Flag.DELETED), true);
                }
                catch (Exception e) {}
                try {
                    folder.close(true);
                }
                catch (Exception e) {}
            }
        }
    }

    protected Folder getFolder(MailingListRequest mailingListRequest) throws Exception {
        String protocol = mailingListRequest.getInProtocol();
        String host = mailingListRequest.getInServerName();
        int port = mailingListRequest.getInServerPort();
        String user = mailingListRequest.getInUserName();
        String password = mailingListRequest.getInPassword();
        Account account = Account.getInstance((String)protocol, (int)port);
        account.setHost(host);
        account.setPort(port);
        account.setUser(user);
        account.setPassword(password);
        Session session = MailEngine.getSession((Account)account);
        URLName urlName = new URLName(protocol, host, port, "", user, password);
        Store store = session.getStore(urlName);
        store.connect();
        Folder defaultFolder = store.getDefaultFolder();
        Folder[] folders = defaultFolder.list();
        if (folders != null && folders.length == 0) {
            throw new MessagingException("Inbox not found");
        }
        Folder folder = folders[0];
        folder.open(2);
        return folder;
    }

    protected void processMessage(MailingListRequest mailingListRequest, javax.mail.Message mailMessage) throws Exception {
        if (MBUtil.hasMailIdHeader(mailMessage)) {
            return;
        }
        String from = null;
        Address[] addresses = mailMessage.getFrom();
        if (addresses != null && addresses.length > 0) {
            Address address = addresses[0];
            from = address instanceof InternetAddress ? ((InternetAddress)address).getAddress() : address.toString();
        }
        long companyId = mailingListRequest.getCompanyId();
        long groupId = mailingListRequest.getGroupId();
        long categoryId = mailingListRequest.getCategoryId();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Category id " + categoryId));
        }
        boolean anonymous = false;
        User user = UserLocalServiceUtil.getUserById((long)companyId, (long)mailingListRequest.getUserId());
        try {
            user = UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)from);
        }
        catch (NoSuchUserException nsue) {
            anonymous = true;
        }
        long parentMessageId = MBUtil.getParentMessageId(mailMessage);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Parent message id " + parentMessageId));
        }
        MBMessage parentMessage = null;
        try {
            if (parentMessageId > 0L) {
                parentMessage = MBMessageLocalServiceUtil.getMessage((long)parentMessageId);
            }
        }
        catch (NoSuchMessageException nsme) {
            // empty catch block
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Parent message " + parentMessage));
        }
        MBMailMessage collector = new MBMailMessage();
        MBUtil.collectPartContent((Part)mailMessage, collector);
        PermissionCheckerUtil.setThreadValues(user);
        MailingListThreadLocal.setSourceMailingList(true);
        String subject = MBUtil.getSubjectWithoutMessageId(mailMessage);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setLayoutFullURL(PortalUtil.getLayoutFullURL((long)groupId, (String)"19"));
        serviceContext.setScopeGroupId(groupId);
        if (parentMessage == null) {
            MBMessageServiceUtil.addMessage((long)categoryId, (String)subject, (String)collector.getBody(), collector.getFiles(), (boolean)anonymous, (double)0.0, (ServiceContext)serviceContext);
        } else {
            MBMessageServiceUtil.addMessage((long)categoryId, (long)parentMessage.getThreadId(), (long)parentMessage.getMessageId(), (String)subject, (String)collector.getBody(), collector.getFiles(), (boolean)anonymous, (double)0.0, (ServiceContext)serviceContext);
        }
    }

    protected void processMessages(MailingListRequest mailingListRequest, javax.mail.Message[] messages) throws Exception {
        for (javax.mail.Message message : messages) {
            this.processMessage(mailingListRequest, message);
        }
    }
}

