/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.model.impl;

import com.liferay.documentlibrary.NoSuchDirectoryException;
import com.liferay.documentlibrary.service.DLServiceUtil;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.model.impl.MBMessageModelImpl;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.util.BBCodeUtil;
import com.liferay.portlet.tags.service.TagsEntryLocalServiceUtil;

public class MBMessageImpl
extends MBMessageModelImpl
implements MBMessage {
    public static final long DEFAULT_PARENT_MESSAGE_ID = 0L;
    private static Log _log = LogFactoryUtil.getLog(MBMessageImpl.class);
    private String _attachmentDirs;

    public String getAttachmentsDir() {
        if (this._attachmentDirs == null) {
            this._attachmentDirs = this.getThreadAttachmentsDir() + "/" + this.getMessageId();
        }
        return this._attachmentDirs;
    }

    public String[] getAttachmentsFiles() throws PortalException, SystemException {
        String[] fileNames = new String[]{};
        try {
            fileNames = DLServiceUtil.getFileNames((long)this.getCompanyId(), (long)0L, (String)this.getAttachmentsDir());
        }
        catch (NoSuchDirectoryException noSuchDirectoryException) {
            // empty catch block
        }
        return fileNames;
    }

    public String getBody(boolean translate) {
        String body = null;
        body = translate ? BBCodeUtil.getHTML(this) : this.getBody();
        return body;
    }

    public MBCategory getCategory() {
        MBCategoryImpl category = null;
        try {
            category = this.getCategoryId() == 0L ? MBCategoryLocalServiceUtil.getSystemCategory() : MBCategoryLocalServiceUtil.getCategory((long)this.getCategoryId());
        }
        catch (Exception e) {
            category = new MBCategoryImpl();
            _log.error((Throwable)e);
        }
        return category;
    }

    public String[] getTagsEntries() throws SystemException {
        return TagsEntryLocalServiceUtil.getEntryNames((String)MBMessage.class.getName(), (long)this.getMessageId());
    }

    public MBThread getThread() throws PortalException, SystemException {
        return MBThreadLocalServiceUtil.getThread((long)this.getThreadId());
    }

    public String getThreadAttachmentsDir() {
        return "messageboards/" + this.getThreadId();
    }

    public boolean isDiscussion() {
        return this.getCategoryId() == 0L;
    }

    public boolean isReply() {
        return !this.isRoot();
    }

    public boolean isRoot() {
        return this.getParentMessageId() == 0L;
    }

    public void setAttachmentsDir(String attachmentsDir) {
        this._attachmentDirs = attachmentsDir;
    }
}

