/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermQueryFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.CategoryNameException;
import com.liferay.portlet.messageboards.NoSuchMailingListException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMailingList;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.service.base.MBCategoryLocalServiceBaseImpl;
import com.liferay.portlet.messageboards.util.Indexer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBCategoryLocalServiceImpl
extends MBCategoryLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(MBCategoryLocalServiceImpl.class);

    public MBCategory addCategory(long userId, long parentCategoryId, String name, String description, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean mailingListActive, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addCategory(null, userId, parentCategoryId, name, description, emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, mailingListActive, serviceContext);
    }

    public MBCategory addCategory(String uuid, long userId, long parentCategoryId, String name, String description, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean mailingListActive, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        parentCategoryId = this.getParentCategoryId(groupId, parentCategoryId);
        Date now = new Date();
        this.validate(name);
        long categoryId = this.counterLocalService.increment();
        MBCategory category = this.mbCategoryPersistence.create(categoryId);
        category.setUuid(uuid);
        category.setGroupId(groupId);
        category.setCompanyId(user.getCompanyId());
        category.setUserId(user.getUserId());
        category.setUserName(user.getFullName());
        category.setCreateDate(now);
        category.setModifiedDate(now);
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setDescription(description);
        this.mbCategoryPersistence.update((BaseModel)category, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addCategoryResources(category, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addCategoryResources(category, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        this.mbMailingListLocalService.addMailingList(null, userId, category.getCategoryId(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, mailingListActive);
        return category;
    }

    public void addCategoryResources(long categoryId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        this.addCategoryResources(category, addCommunityPermissions, addGuestPermissions);
    }

    public void addCategoryResources(long categoryId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        this.addCategoryResources(category, communityPermissions, guestPermissions);
    }

    public void addCategoryResources(MBCategory category, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), MBCategory.class.getName(), category.getCategoryId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addCategoryResources(MBCategory category, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), MBCategory.class.getName(), category.getCategoryId(), communityPermissions, guestPermissions);
    }

    public void deleteCategories(long groupId) throws PortalException, SystemException {
        List categories = this.mbCategoryPersistence.findByG_P(groupId, MBCategoryImpl.DEFAULT_PARENT_CATEGORY_ID);
        for (MBCategory category : categories) {
            this.deleteCategory(category);
        }
    }

    public void deleteCategory(long categoryId) throws PortalException, SystemException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        this.deleteCategory(category);
    }

    public void deleteCategory(MBCategory category) throws PortalException, SystemException {
        List categories = this.mbCategoryPersistence.findByG_P(category.getGroupId(), category.getCategoryId());
        for (MBCategory curCategory : categories) {
            this.deleteCategory(curCategory);
        }
        try {
            Indexer.deleteMessages(category.getCompanyId(), category.getCategoryId());
        }
        catch (SearchException se) {
            _log.error((Object)("Deleting index " + category.getCategoryId()), (Throwable)se);
        }
        this.mbThreadLocalService.deleteThreads(category.getCategoryId());
        try {
            this.mbMailingListLocalService.deleteCategoryMailingList(category.getCategoryId());
        }
        catch (NoSuchMailingListException noSuchMailingListException) {
            // empty catch block
        }
        this.resourceLocalService.deleteResource(category.getCompanyId(), MBCategory.class.getName(), 4, category.getCategoryId());
        this.mbCategoryPersistence.remove((BaseModel)category);
    }

    public List<MBCategory> getCategories(long groupId) throws SystemException {
        return this.mbCategoryPersistence.findByGroupId(groupId);
    }

    public List<MBCategory> getCategories(long groupId, long parentCategoryId) throws SystemException {
        return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryId);
    }

    public List<MBCategory> getCategories(long groupId, long parentCategoryId, int start, int end) throws SystemException {
        return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryId, start, end);
    }

    public int getCategoriesCount(long groupId) throws SystemException {
        return this.mbCategoryPersistence.countByGroupId(groupId);
    }

    public int getCategoriesCount(long groupId, long parentCategoryId) throws SystemException {
        return this.mbCategoryPersistence.countByG_P(groupId, parentCategoryId);
    }

    public MBCategory getCategory(long categoryId) throws PortalException, SystemException {
        return this.mbCategoryPersistence.findByPrimaryKey(categoryId);
    }

    public void getSubcategoryIds(List<Long> categoryIds, long groupId, long categoryId) throws SystemException {
        List categories = this.mbCategoryPersistence.findByG_P(groupId, categoryId);
        for (MBCategory category : categories) {
            categoryIds.add(category.getCategoryId());
            this.getSubcategoryIds(categoryIds, category.getGroupId(), category.getCategoryId());
        }
    }

    public List<MBCategory> getSubscribedCategories(long groupId, long userId, int start, int end) throws SystemException {
        return this.mbCategoryFinder.findByS_G_U(groupId, userId, start, end);
    }

    public int getSubscribedCategoriesCount(long groupId, long userId) throws SystemException {
        return this.mbCategoryFinder.countByS_G_U(groupId, userId);
    }

    public MBCategory getSystemCategory() throws SystemException {
        long categoryId = 0L;
        MBCategory category = this.mbCategoryPersistence.fetchByPrimaryKey(categoryId);
        if (category == null) {
            category = this.mbCategoryPersistence.create(categoryId);
            category.setCompanyId(0L);
            category.setUserId(0L);
            this.mbCategoryPersistence.update((BaseModel)category, false);
        }
        return category;
    }

    public void reIndex(String[] ids) throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        long companyId = GetterUtil.getLong((String)ids[0]);
        try {
            this.reIndexCategories(companyId);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Hits search(long companyId, long groupId, long userId, long[] categoryIds, long threadId, String keywords, int start, int end) throws SystemException {
        try {
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create();
            contextQuery.addRequiredTerm("portletId", "19");
            if (groupId > 0L) {
                Group group = this.groupLocalService.getGroup(groupId);
                if (group.isLayout()) {
                    contextQuery.addRequiredTerm("scopeGroupId", groupId);
                    groupId = group.getParentGroupId();
                }
                contextQuery.addRequiredTerm("groupId", groupId);
            }
            if (categoryIds != null && categoryIds.length > 0) {
                BooleanQuery categoryIdsQuery = BooleanQueryFactoryUtil.create();
                for (long categoryId : categoryIds) {
                    TermQuery termQuery = TermQueryFactoryUtil.create((String)"categoryId", (long)categoryId);
                    categoryIdsQuery.add((Query)termQuery, BooleanClauseOccur.SHOULD);
                }
                contextQuery.add((Query)categoryIdsQuery, BooleanClauseOccur.MUST);
            }
            if (threadId > 0L) {
                contextQuery.addTerm("threadId", threadId);
            }
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            if (Validator.isNotNull((String)keywords)) {
                searchQuery.addTerm("userName", keywords);
                searchQuery.addTerm("title", keywords);
                searchQuery.addTerm("content", keywords);
                searchQuery.addTerm("tagsEntries", keywords, true);
            }
            BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
            fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
            if (searchQuery.clauses().size() > 0) {
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            return SearchEngineUtil.search((long)companyId, (long)groupId, (long)userId, (String)MBMessage.class.getName(), (Query)fullQuery, (int)start, (int)end);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void subscribeCategory(long userId, long categoryId) throws PortalException, SystemException {
        this.subscriptionLocalService.addSubscription(userId, MBCategory.class.getName(), categoryId);
    }

    public void unsubscribeCategory(long userId, long categoryId) throws PortalException, SystemException {
        this.subscriptionLocalService.deleteSubscription(userId, MBCategory.class.getName(), categoryId);
    }

    public MBCategory updateCategory(long categoryId, long parentCategoryId, String name, String description, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean mailingListActive, boolean mergeWithParentCategory) throws PortalException, SystemException {
        MBMailingList mailingList;
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        parentCategoryId = this.getParentCategoryId(category, parentCategoryId);
        this.validate(name);
        category.setModifiedDate(new Date());
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setDescription(description);
        this.mbCategoryPersistence.update((BaseModel)category, false);
        if (mergeWithParentCategory && categoryId != parentCategoryId && parentCategoryId != MBCategoryImpl.DEFAULT_PARENT_CATEGORY_ID) {
            this.mergeCategories(category, parentCategoryId);
        }
        if ((mailingList = this.mbMailingListPersistence.fetchByCategoryId(category.getCategoryId())) != null) {
            this.mbMailingListLocalService.updateMailingList(mailingList.getMailingListId(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, mailingListActive);
        } else {
            this.mbMailingListLocalService.addMailingList(null, category.getUserId(), category.getCategoryId(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, mailingListActive);
        }
        return category;
    }

    protected long getParentCategoryId(long groupId, long parentCategoryId) throws SystemException {
        MBCategory parentCategory;
        if (parentCategoryId != MBCategoryImpl.DEFAULT_PARENT_CATEGORY_ID && ((parentCategory = this.mbCategoryPersistence.fetchByPrimaryKey(parentCategoryId)) == null || groupId != parentCategory.getGroupId())) {
            parentCategoryId = MBCategoryImpl.DEFAULT_PARENT_CATEGORY_ID;
        }
        return parentCategoryId;
    }

    protected long getParentCategoryId(MBCategory category, long parentCategoryId) throws SystemException {
        if (parentCategoryId == MBCategoryImpl.DEFAULT_PARENT_CATEGORY_ID) {
            return parentCategoryId;
        }
        if (category.getCategoryId() == parentCategoryId) {
            return category.getParentCategoryId();
        }
        MBCategory parentCategory = this.mbCategoryPersistence.fetchByPrimaryKey(parentCategoryId);
        if (parentCategory == null || category.getGroupId() != parentCategory.getGroupId()) {
            return category.getParentCategoryId();
        }
        ArrayList<Long> subcategoryIds = new ArrayList<Long>();
        this.getSubcategoryIds(subcategoryIds, category.getGroupId(), category.getCategoryId());
        if (subcategoryIds.contains(parentCategoryId)) {
            return category.getParentCategoryId();
        }
        return parentCategoryId;
    }

    protected void mergeCategories(MBCategory fromCategory, long toCategoryId) throws PortalException, SystemException {
        List categories = this.mbCategoryPersistence.findByG_P(fromCategory.getGroupId(), fromCategory.getCategoryId());
        for (MBCategory category : categories) {
            this.mergeCategories(category, toCategoryId);
        }
        List threads = this.mbThreadPersistence.findByCategoryId(fromCategory.getCategoryId());
        for (MBThread thread : threads) {
            thread.setCategoryId(toCategoryId);
            this.mbThreadPersistence.update((BaseModel)thread, false);
            List messages = this.mbMessagePersistence.findByThreadId(thread.getThreadId());
            for (MBMessage message : messages) {
                message.setCategoryId(toCategoryId);
                this.mbMessagePersistence.update((BaseModel)message, false);
                this.mbMessageLocalService.reIndex(message);
            }
        }
        this.deleteCategory(fromCategory);
    }

    protected void reIndexCategories(long companyId) throws SystemException {
        int categoryCount = this.mbCategoryPersistence.countByCompanyId(companyId);
        int categoryPages = categoryCount / 1000;
        for (int i = 0; i <= categoryPages; ++i) {
            int categoryStart = i * 1000;
            int categoryEnd = categoryStart + 1000;
            this.reIndexCategories(companyId, categoryStart, categoryEnd);
        }
    }

    protected void reIndexCategories(long companyId, int categoryStart, int categoryEnd) throws SystemException {
        List categories = this.mbCategoryPersistence.findByCompanyId(companyId, categoryStart, categoryEnd);
        for (MBCategory category : categories) {
            long categoryId = category.getCategoryId();
            int messageCount = this.mbMessagePersistence.countByCategoryId(categoryId);
            int messagePages = messageCount / 1000;
            for (int i = 0; i <= messagePages; ++i) {
                int messageStart = i * 1000;
                int messageEnd = messageStart + 1000;
                this.reIndexMessages(categoryId, messageStart, messageEnd);
            }
        }
    }

    protected void reIndexMessages(long categoryId, int messageStart, int messageEnd) throws SystemException {
        List messages = this.mbMessagePersistence.findByCategoryId(categoryId, messageStart, messageEnd);
        for (MBMessage message : messages) {
            this.mbMessageLocalService.reIndex(message);
        }
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CategoryNameException();
        }
    }
}

