/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.service.base.MBCategoryServiceBaseImpl;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBCategoryServiceImpl
extends MBCategoryServiceBaseImpl {
    public MBCategory addCategory(long parentCategoryId, String name, String description, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean mailingListActive, ServiceContext serviceContext) throws PortalException, SystemException {
        MBCategoryPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentCategoryId, "ADD_CATEGORY");
        return this.mbCategoryLocalService.addCategory(this.getUserId(), parentCategoryId, name, description, emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, mailingListActive, serviceContext);
    }

    public void deleteCategory(long categoryId) throws PortalException, SystemException {
        MBCategoryPermission.check(this.getPermissionChecker(), categoryId, "DELETE");
        this.mbCategoryLocalService.deleteCategory(categoryId);
    }

    public List<MBCategory> getCategories(long groupId, long parentCategoryId, int start, int end) throws PortalException, SystemException {
        List categories = this.mbCategoryLocalService.getCategories(groupId, parentCategoryId, start, end);
        categories = ListUtil.copy((List)categories);
        Iterator itr = categories.iterator();
        while (itr.hasNext()) {
            MBCategory category = (MBCategory)itr.next();
            if (MBCategoryPermission.contains(this.getPermissionChecker(), category, "VIEW")) continue;
            itr.remove();
        }
        return categories;
    }

    public int getCategoriesCount(long groupId, long parentCategoryId) throws SystemException {
        return this.mbCategoryLocalService.getCategoriesCount(groupId, parentCategoryId);
    }

    public MBCategory getCategory(long categoryId) throws PortalException, SystemException {
        MBCategoryPermission.check(this.getPermissionChecker(), categoryId, "VIEW");
        return this.mbCategoryLocalService.getCategory(categoryId);
    }

    public void subscribeCategory(long categoryId) throws PortalException, SystemException {
        MBCategoryPermission.check(this.getPermissionChecker(), categoryId, "SUBSCRIBE");
        this.mbCategoryLocalService.subscribeCategory(this.getUserId(), categoryId);
    }

    public void unsubscribeCategory(long categoryId) throws PortalException, SystemException {
        MBCategoryPermission.check(this.getPermissionChecker(), categoryId, "SUBSCRIBE");
        this.mbCategoryLocalService.unsubscribeCategory(this.getUserId(), categoryId);
    }

    public MBCategory updateCategory(long categoryId, long parentCategoryId, String name, String description, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean mailingListActive, boolean mergeWithParentCategory) throws PortalException, SystemException {
        MBCategoryPermission.check(this.getPermissionChecker(), categoryId, "UPDATE");
        return this.mbCategoryLocalService.updateCategory(categoryId, parentCategoryId, name, description, emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, mailingListActive, mergeWithParentCategory);
    }
}

