/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineUtil;
import com.liferay.portal.kernel.scheduler.TriggerExpression;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerRequest;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portlet.messageboards.MailingListEmailAddressException;
import com.liferay.portlet.messageboards.MailingListInServerNameException;
import com.liferay.portlet.messageboards.MailingListInUserNameException;
import com.liferay.portlet.messageboards.MailingListOutEmailAddressException;
import com.liferay.portlet.messageboards.MailingListOutServerNameException;
import com.liferay.portlet.messageboards.MailingListOutUserNameException;
import com.liferay.portlet.messageboards.messaging.MailingListRequest;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMailingList;
import com.liferay.portlet.messageboards.service.base.MBMailingListLocalServiceBaseImpl;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class MBMailingListLocalServiceImpl
extends MBMailingListLocalServiceBaseImpl {
    public MBMailingList addMailingList(String uuid, long userId, long categoryId, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean active) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        Date now = new Date();
        this.validate(emailAddress, inServerName, inUserName, outEmailAddress, outCustom, outServerName, outUserName, active);
        long mailingListId = this.counterLocalService.increment();
        MBMailingList mailingList = this.mbMailingListPersistence.create(mailingListId);
        mailingList.setUuid(uuid);
        mailingList.setGroupId(category.getGroupId());
        mailingList.setCompanyId(user.getCompanyId());
        mailingList.setUserId(user.getUserId());
        mailingList.setUserName(user.getFullName());
        mailingList.setCreateDate(now);
        mailingList.setModifiedDate(now);
        mailingList.setCategoryId(categoryId);
        mailingList.setEmailAddress(emailAddress);
        mailingList.setInProtocol(inUseSSL ? inProtocol + "s" : inProtocol);
        mailingList.setInServerName(inServerName);
        mailingList.setInServerPort(inServerPort);
        mailingList.setInUseSSL(inUseSSL);
        mailingList.setInUserName(inUserName);
        mailingList.setInPassword(inPassword);
        mailingList.setInReadInterval(inReadInterval);
        mailingList.setOutEmailAddress(outEmailAddress);
        mailingList.setOutCustom(outCustom);
        mailingList.setOutServerName(outServerName);
        mailingList.setOutServerPort(outServerPort);
        mailingList.setOutUseSSL(outUseSSL);
        mailingList.setOutUserName(outUserName);
        mailingList.setOutPassword(outPassword);
        mailingList.setActive(active);
        this.mbMailingListPersistence.update((BaseModel)mailingList, false);
        if (active) {
            this.scheduleMailingList(mailingList);
        }
        return mailingList;
    }

    public void deleteCategoryMailingList(long categoryId) throws PortalException, SystemException {
        MBMailingList mailingList = this.mbMailingListPersistence.findByCategoryId(categoryId);
        this.deleteMailingList(mailingList);
    }

    public void deleteMailingList(long mailingListId) throws PortalException, SystemException {
        MBMailingList mailingList = this.mbMailingListPersistence.findByPrimaryKey(mailingListId);
        this.deleteMailingList(mailingList);
    }

    public void deleteMailingList(MBMailingList mailingList) throws PortalException, SystemException {
        this.unscheduleMailingList(mailingList);
        this.mbMailingListPersistence.remove((BaseModel)mailingList);
    }

    public MBMailingList getCategoryMailingList(long categoryId) throws PortalException, SystemException {
        return this.mbMailingListPersistence.findByCategoryId(categoryId);
    }

    public MBMailingList updateMailingList(long mailingListId, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean active) throws PortalException, SystemException {
        this.validate(emailAddress, inServerName, inUserName, outEmailAddress, outCustom, outServerName, outUserName, active);
        MBMailingList mailingList = this.mbMailingListPersistence.findByPrimaryKey(mailingListId);
        boolean oldActive = mailingList.isActive();
        mailingList.setModifiedDate(new Date());
        mailingList.setEmailAddress(emailAddress);
        mailingList.setInProtocol(inUseSSL ? inProtocol + "s" : inProtocol);
        mailingList.setInServerName(inServerName);
        mailingList.setInServerPort(inServerPort);
        mailingList.setInUseSSL(inUseSSL);
        mailingList.setInUserName(inUserName);
        mailingList.setInPassword(inPassword);
        mailingList.setInReadInterval(inReadInterval);
        mailingList.setOutEmailAddress(outEmailAddress);
        mailingList.setOutCustom(outCustom);
        mailingList.setOutServerName(outServerName);
        mailingList.setOutServerPort(outServerPort);
        mailingList.setOutUseSSL(outUseSSL);
        mailingList.setOutUserName(outUserName);
        mailingList.setOutPassword(outPassword);
        mailingList.setActive(active);
        this.mbMailingListPersistence.update((BaseModel)mailingList, false);
        if (oldActive) {
            this.unscheduleMailingList(mailingList);
        }
        if (active) {
            this.scheduleMailingList(mailingList);
        }
        return mailingList;
    }

    protected String getSchedulerGroupName(MBMailingList mailingList) {
        StringBuilder sb = new StringBuilder();
        sb.append("liferay/message_boards_mailing_list");
        sb.append("/");
        sb.append(mailingList.getMailingListId());
        return sb.toString();
    }

    protected void scheduleMailingList(MBMailingList mailingList) throws PortalException {
        this.unscheduleMailingList(mailingList);
        String groupName = this.getSchedulerGroupName(mailingList);
        Calendar startDate = CalendarFactoryUtil.getCalendar();
        TriggerExpression triggerExpression = new TriggerExpression(startDate, 2, mailingList.getInReadInterval());
        String cronText = triggerExpression.toCronText();
        MailingListRequest mailingListRequest = new MailingListRequest();
        mailingListRequest.setCompanyId(mailingList.getCompanyId());
        mailingListRequest.setUserId(mailingList.getUserId());
        mailingListRequest.setGroupId(mailingList.getGroupId());
        mailingListRequest.setCategoryId(mailingList.getCategoryId());
        mailingListRequest.setInProtocol(mailingList.getInProtocol());
        mailingListRequest.setInServerName(mailingList.getInServerName());
        mailingListRequest.setInServerPort(mailingList.getInServerPort());
        mailingListRequest.setInUseSSL(mailingList.getInUseSSL());
        mailingListRequest.setInUserName(mailingList.getInUserName());
        mailingListRequest.setInPassword(mailingList.getInPassword());
        SchedulerEngineUtil.schedule((String)groupName, (String)cronText, (Date)startDate.getTime(), null, null, (String)"liferay/message_boards_mailing_list", (String)JSONFactoryUtil.serialize((Object)mailingListRequest));
    }

    protected void unscheduleMailingList(MBMailingList mailingList) throws PortalException {
        String groupName = this.getSchedulerGroupName(mailingList);
        List schedulerRequests = SchedulerEngineUtil.getScheduledJobs((String)groupName);
        for (SchedulerRequest schedulerRequest : schedulerRequests) {
            SchedulerEngineUtil.unschedule((String)schedulerRequest.getJobName(), (String)schedulerRequest.getGroupName());
        }
    }

    protected void validate(String emailAddress, String inServerName, String inUserName, String outEmailAddress, boolean outCustom, String outServerName, String outUserName, boolean active) throws PortalException {
        if (!active) {
            return;
        }
        if (!Validator.isEmailAddress((String)emailAddress)) {
            throw new MailingListEmailAddressException();
        }
        if (Validator.isNull((String)inServerName)) {
            throw new MailingListInServerNameException();
        }
        if (Validator.isNull((String)inUserName)) {
            throw new MailingListInUserNameException();
        }
        if (Validator.isNull((String)outEmailAddress)) {
            throw new MailingListOutEmailAddressException();
        }
        if (outCustom) {
            if (Validator.isNull((String)outServerName)) {
                throw new MailingListOutServerNameException();
            }
            if (Validator.isNull((String)outUserName)) {
                throw new MailingListOutUserNameException();
            }
        }
    }
}

