/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.documentlibrary.DuplicateDirectoryException;
import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.documentlibrary.NoSuchDirectoryException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.CompanyConstants;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.messageboards.MessageBodyException;
import com.liferay.portlet.messageboards.MessageSubjectException;
import com.liferay.portlet.messageboards.NoSuchDiscussionException;
import com.liferay.portlet.messageboards.RequiredMessageException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageDisplay;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBMessageDisplayImpl;
import com.liferay.portlet.messageboards.service.base.MBMessageLocalServiceBaseImpl;
import com.liferay.portlet.messageboards.util.Indexer;
import com.liferay.portlet.messageboards.util.MBUtil;
import com.liferay.portlet.messageboards.util.MailingListThreadLocal;
import com.liferay.portlet.messageboards.util.comparator.MessageThreadComparator;
import com.liferay.portlet.messageboards.util.comparator.ThreadLastPostDateComparator;
import com.liferay.portlet.social.model.SocialActivity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.mail.internet.InternetAddress;
import javax.portlet.PortletPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBMessageLocalServiceImpl
extends MBMessageLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(MBMessageLocalServiceImpl.class);

    public MBMessage addDiscussionMessage(long userId, String userName, String className, long classPK) throws PortalException, SystemException {
        String subject;
        long threadId = 0L;
        long parentMessageId = 0L;
        String body = subject = String.valueOf(classPK);
        ServiceContext serviceContext = new ServiceContext();
        return this.addDiscussionMessage(userId, userName, className, classPK, threadId, parentMessageId, subject, body, serviceContext);
    }

    public MBMessage addDiscussionMessage(long userId, String userName, String className, long classPK, long threadId, long parentMessageId, String subject, String body, ServiceContext serviceContext) throws PortalException, SystemException {
        MBDiscussion discussion;
        long classNameId = PortalUtil.getClassNameId((String)className);
        long categoryId = 0L;
        if (Validator.isNull((String)subject)) {
            subject = "N/A";
        }
        ArrayList<ObjectValuePair<String, byte[]>> files = new ArrayList<ObjectValuePair<String, byte[]>>();
        boolean anonymous = false;
        double priority = 0.0;
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        this.mbCategoryLocalService.getSystemCategory();
        MBMessage message = this.addMessage(userId, userName, categoryId, threadId, parentMessageId, subject, body, files, anonymous, priority, serviceContext);
        message.setClassNameId(classNameId);
        message.setClassPK(classPK);
        this.mbMessagePersistence.update((BaseModel)message, false);
        if (className.equals(BlogsEntry.class.getName()) && parentMessageId != 0L) {
            BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(classPK);
            JSONObject extraData = JSONFactoryUtil.createJSONObject();
            extraData.put("messageId", message.getMessageId());
            this.socialActivityLocalService.addActivity(userId, entry.getGroupId(), BlogsEntry.class.getName(), classPK, 1, extraData.toString(), entry.getUserId());
            try {
                this.sendBlogsCommentsEmail(userId, entry, message, serviceContext);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (parentMessageId == 0L && (discussion = this.mbDiscussionPersistence.fetchByC_C(classNameId, classPK)) == null) {
            discussion = this.mbDiscussionLocalService.addDiscussion(classNameId, classPK, message.getThreadId());
        }
        return message;
    }

    public MBMessage addMessage(long userId, String userName, long categoryId, long threadId, long parentMessageId, String subject, String body, List<ObjectValuePair<String, byte[]>> files, boolean anonymous, double priority, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addMessage(null, userId, userName, categoryId, threadId, parentMessageId, subject, body, files, anonymous, priority, serviceContext);
    }

    public MBMessage addMessage(long userId, String userName, long categoryId, String subject, String body, List<ObjectValuePair<String, byte[]>> files, boolean anonymous, double priority, ServiceContext serviceContext) throws PortalException, SystemException {
        long threadId = 0L;
        long parentMessageId = 0L;
        return this.addMessage(null, userId, userName, categoryId, threadId, parentMessageId, subject, body, files, anonymous, priority, serviceContext);
    }

    public MBMessage addMessage(String uuid, long userId, String userName, long categoryId, long threadId, long parentMessageId, String subject, String body, List<ObjectValuePair<String, byte[]>> files, boolean anonymous, double priority, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        userName = user.isDefaultUser() ? userName : user.getFullName();
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        subject = ModelHintsUtil.trimString((String)MBMessage.class.getName(), (String)"subject", (String)subject);
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences != null && !MBUtil.isAllowAnonymousPosting(preferences) && (anonymous || user.isDefaultUser())) {
            throw new PrincipalException();
        }
        if (user.isDefaultUser()) {
            anonymous = true;
        }
        Date now = new Date();
        this.validate(subject, body);
        long messageId = this.counterLocalService.increment();
        MBMessage message = this.mbMessagePersistence.create(messageId);
        message.setUuid(uuid);
        message.setGroupId(category.getGroupId());
        message.setCompanyId(user.getCompanyId());
        message.setUserId(user.getUserId());
        message.setUserName(userName);
        message.setCreateDate(now);
        message.setModifiedDate(now);
        MBMessage parentMessage = this.mbMessagePersistence.fetchByPrimaryKey(parentMessageId);
        if (parentMessage == null) {
            parentMessageId = 0L;
        }
        MBThread thread = null;
        if (threadId > 0L) {
            thread = this.mbThreadPersistence.fetchByPrimaryKey(threadId);
        }
        if (thread == null || parentMessageId == 0L) {
            threadId = this.counterLocalService.increment();
            thread = this.mbThreadPersistence.create(threadId);
            thread.setGroupId(category.getGroupId());
            thread.setCategoryId(categoryId);
            thread.setRootMessageId(messageId);
            if (!category.isDiscussion()) {
                category.setThreadCount(category.getThreadCount() + 1);
            }
        }
        thread.setMessageCount(thread.getMessageCount() + 1);
        if (anonymous) {
            thread.setLastPostByUserId(0L);
        } else {
            thread.setLastPostByUserId(userId);
        }
        thread.setLastPostDate(now);
        if (priority != -1.0 && thread.getPriority() != priority) {
            thread.setPriority(priority);
            this.updatePriorities(thread.getThreadId(), priority);
        }
        message.setCategoryId(categoryId);
        message.setThreadId(threadId);
        message.setParentMessageId(parentMessageId);
        message.setSubject(subject);
        message.setBody(body);
        message.setAttachments(!files.isEmpty());
        message.setAnonymous(anonymous);
        if (priority != -1.0) {
            message.setPriority(priority);
        }
        if (files.size() > 0) {
            String dirName;
            long repositoryId;
            long groupId;
            String portletId;
            long companyId;
            block23: {
                companyId = message.getCompanyId();
                portletId = CompanyConstants.SYSTEM_STRING;
                groupId = 0L;
                repositoryId = 0L;
                dirName = message.getAttachmentsDir();
                try {
                    this.dlService.deleteDirectory(companyId, portletId, repositoryId, dirName);
                }
                catch (NoSuchDirectoryException nsde) {
                    if (!_log.isDebugEnabled()) break block23;
                    _log.debug((Object)nsde.getMessage());
                }
            }
            this.dlService.addDirectory(companyId, repositoryId, dirName);
            for (int i = 0; i < files.size(); ++i) {
                ObjectValuePair<String, byte[]> ovp = files.get(i);
                String fileName = (String)ovp.getKey();
                byte[] bytes = (byte[])ovp.getValue();
                try {
                    this.dlService.addFile(companyId, portletId, groupId, repositoryId, dirName + "/" + fileName, 0L, "", message.getModifiedDate(), new String[0], new String[0], bytes);
                    continue;
                }
                catch (DuplicateFileException dfe) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)dfe.getMessage());
                }
            }
        }
        this.mbThreadPersistence.update((BaseModel)thread, false);
        this.mbMessagePersistence.update((BaseModel)message, false);
        if (!category.isDiscussion()) {
            if (user.isDefaultUser()) {
                this.addMessageResources(message, true, true);
            }
            if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
                this.addMessageResources(message, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
            } else {
                this.addMessageResources(message, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
            }
        }
        if (!message.isDiscussion()) {
            this.mbStatsUserLocalService.updateStatsUser(message.getGroupId(), userId, now);
            category.setMessageCount(category.getMessageCount() + 1);
            category.setLastPostDate(now);
            this.mbCategoryPersistence.update((BaseModel)category, false);
        }
        this.notifySubscribers(category, message, serviceContext, false);
        if (!(message.isDiscussion() || message.isAnonymous() || user.isDefaultUser())) {
            int activityType = 1;
            long receiverUserId = 0L;
            if (parentMessage != null) {
                activityType = 2;
                receiverUserId = parentMessage.getUserId();
            }
            this.socialActivityLocalService.addActivity(userId, message.getGroupId(), MBMessage.class.getName(), messageId, activityType, "", receiverUserId);
        }
        this.updateTagsAsset(userId, message, serviceContext.getTagsEntries());
        this.reIndex(message);
        return message;
    }

    public void addMessageResources(long messageId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.addMessageResources(message, addCommunityPermissions, addGuestPermissions);
    }

    public void addMessageResources(long messageId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.addMessageResources(message, communityPermissions, guestPermissions);
    }

    public void addMessageResources(MBMessage message, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(message.getCompanyId(), message.getGroupId(), message.getUserId(), MBMessage.class.getName(), message.getMessageId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addMessageResources(MBMessage message, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(message.getCompanyId(), message.getGroupId(), message.getUserId(), MBMessage.class.getName(), message.getMessageId(), communityPermissions, guestPermissions);
    }

    public void deleteDiscussionMessage(long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        messages.add(message);
        this.deleteDiscussionSocialActivities(BlogsEntry.class.getName(), messages);
        this.deleteMessage(message);
    }

    public void deleteDiscussionMessages(String className, long classPK) throws PortalException, SystemException {
        block3: {
            try {
                long classNameId = PortalUtil.getClassNameId((String)className);
                MBDiscussion discussion = this.mbDiscussionPersistence.findByC_C(classNameId, classPK);
                List messages = this.mbMessagePersistence.findByT_P(discussion.getThreadId(), 0L, 0, 1);
                this.deleteDiscussionSocialActivities(BlogsEntry.class.getName(), messages);
                if (messages.size() > 0) {
                    MBMessage message = (MBMessage)messages.get(0);
                    this.mbThreadLocalService.deleteThread(message.getThreadId());
                }
                this.mbDiscussionPersistence.remove((BaseModel)discussion);
            }
            catch (NoSuchDiscussionException nsde) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)nsde.getMessage());
            }
        }
    }

    public void deleteMessage(long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.deleteMessage(message);
    }

    public void deleteMessage(MBMessage message) throws PortalException, SystemException {
        block21: {
            try {
                Indexer.deleteMessage(message.getCompanyId(), message.getMessageId());
            }
            catch (SearchException se) {
                _log.error((Object)("Deleting index " + message.getMessageId()), (Throwable)se);
            }
            if (message.isAttachments()) {
                long companyId = message.getCompanyId();
                String portletId = CompanyConstants.SYSTEM_STRING;
                long repositoryId = 0L;
                String dirName = message.getAttachmentsDir();
                try {
                    this.dlService.deleteDirectory(companyId, portletId, repositoryId, dirName);
                }
                catch (NoSuchDirectoryException nsde) {
                    if (!_log.isDebugEnabled()) break block21;
                    _log.debug((Object)nsde.getMessage());
                }
            }
        }
        int count = this.mbMessagePersistence.countByThreadId(message.getThreadId());
        if (message.isRoot()) {
            this.mbMessageFlagLocalService.deleteQuestionAndAnswerFlags(message.getThreadId());
        }
        if (count == 1) {
            block22: {
                long companyId = message.getCompanyId();
                String portletId = CompanyConstants.SYSTEM_STRING;
                long repositoryId = 0L;
                String dirName = message.getThreadAttachmentsDir();
                try {
                    this.dlService.deleteDirectory(companyId, portletId, repositoryId, dirName);
                }
                catch (NoSuchDirectoryException nsde) {
                    if (!_log.isDebugEnabled()) break block22;
                    _log.debug((Object)nsde.getMessage());
                }
            }
            this.subscriptionLocalService.deleteSubscriptions(message.getCompanyId(), MBThread.class.getName(), message.getThreadId());
            this.mbThreadPersistence.remove(message.getThreadId());
            if (!message.isDiscussion()) {
                MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(message.getCategoryId());
                category.setThreadCount(category.getThreadCount() - 1);
                category.setMessageCount(category.getMessageCount() - 1);
                this.mbCategoryPersistence.update((BaseModel)category, false);
            }
        } else if (count > 1) {
            List childrenMessages;
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
            if (thread.getRootMessageId() == message.getMessageId()) {
                childrenMessages = this.mbMessagePersistence.findByT_P(message.getThreadId(), message.getMessageId());
                if (childrenMessages.size() > 1) {
                    throw new RequiredMessageException(String.valueOf(message.getMessageId()));
                }
                if (childrenMessages.size() == 1) {
                    MBMessage childMessage = (MBMessage)childrenMessages.get(0);
                    childMessage.setParentMessageId(0L);
                    this.mbMessagePersistence.update((BaseModel)childMessage, false);
                    thread.setRootMessageId(childMessage.getMessageId());
                    this.mbThreadPersistence.update((BaseModel)thread, false);
                }
            } else {
                childrenMessages = this.mbMessagePersistence.findByT_P(message.getThreadId(), message.getMessageId());
                if (childrenMessages.size() > 0) {
                    for (MBMessage childMessage : childrenMessages) {
                        childMessage.setParentMessageId(message.getParentMessageId());
                        this.mbMessagePersistence.update((BaseModel)childMessage, false);
                    }
                }
            }
            thread.setMessageCount(count - 1);
            this.mbThreadPersistence.update((BaseModel)thread, false);
            if (!message.isDiscussion()) {
                MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(message.getCategoryId());
                category.setMessageCount(count - 1);
                this.mbCategoryPersistence.update((BaseModel)category, false);
            }
        }
        this.tagsAssetLocalService.deleteAsset(MBMessage.class.getName(), message.getMessageId());
        this.socialActivityLocalService.deleteActivities(MBMessage.class.getName(), message.getMessageId());
        this.ratingsStatsLocalService.deleteStats(MBMessage.class.getName(), message.getMessageId());
        if (!message.isDiscussion()) {
            this.mbStatsUserLocalService.updateStatsUser(message.getGroupId(), message.getUserId());
        }
        this.mbMessageFlagPersistence.removeByMessageId(message.getMessageId());
        if (!message.isDiscussion()) {
            this.resourceLocalService.deleteResource(message.getCompanyId(), MBMessage.class.getName(), 4, message.getMessageId());
        }
        this.mbMessagePersistence.remove((BaseModel)message);
    }

    public List<MBMessage> getCategoryMessages(long categoryId, int start, int end) throws SystemException {
        return this.mbMessagePersistence.findByCategoryId(categoryId, start, end);
    }

    public List<MBMessage> getCategoryMessages(long categoryId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.mbMessagePersistence.findByCategoryId(categoryId, start, end, obc);
    }

    public int getCategoryMessagesCount(long categoryId) throws SystemException {
        return this.mbMessagePersistence.countByCategoryId(categoryId);
    }

    public List<MBMessage> getCompanyMessages(long companyId, int start, int end) throws SystemException {
        return this.mbMessagePersistence.findByCompanyId(companyId, start, end);
    }

    public List<MBMessage> getCompanyMessages(long companyId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.mbMessagePersistence.findByCompanyId(companyId, start, end, obc);
    }

    public int getCompanyMessagesCount(long companyId) throws SystemException {
        return this.mbMessagePersistence.countByCompanyId(companyId);
    }

    public MBMessageDisplay getDiscussionMessageDisplay(long userId, String className, long classPK) throws PortalException, SystemException {
        return this.getDiscussionMessageDisplay(userId, className, classPK, "combination");
    }

    public MBMessageDisplay getDiscussionMessageDisplay(long userId, String className, long classPK, String threadView) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        MBMessage message = null;
        MBDiscussion discussion = this.mbDiscussionPersistence.fetchByC_C(classNameId, classPK);
        if (discussion != null) {
            List messages = this.mbMessagePersistence.findByT_P(discussion.getThreadId(), 0L);
            message = (MBMessage)messages.get(0);
        } else {
            String subject = String.valueOf(classPK);
            try {
                message = this.addDiscussionMessage(userId, null, className, classPK, 0L, 0L, subject, subject, new ServiceContext());
            }
            catch (SystemException se) {
                List messages;
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Add failed, fetch {threadId=0, parentMessageId=0}");
                }
                if ((messages = this.mbMessagePersistence.findByT_P(0L, 0L)).isEmpty()) {
                    throw se;
                }
                message = (MBMessage)messages.get(0);
            }
        }
        return this.getMessageDisplay(message, threadView);
    }

    public int getDiscussionMessagesCount(long classNameId, long classPK) throws SystemException {
        MBDiscussion discussion = this.mbDiscussionPersistence.fetchByC_C(classNameId, classPK);
        if (discussion == null) {
            return 0;
        }
        int count = this.mbMessagePersistence.countByThreadId(discussion.getThreadId());
        if (count >= 1) {
            return count - 1;
        }
        return 0;
    }

    public List<MBDiscussion> getDiscussions(String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.mbDiscussionPersistence.findByClassNameId(classNameId);
    }

    public List<MBMessage> getGroupMessages(long groupId, int start, int end) throws SystemException {
        return this.mbMessagePersistence.findByGroupId(groupId, start, end);
    }

    public List<MBMessage> getGroupMessages(long groupId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.mbMessagePersistence.findByGroupId(groupId, start, end, obc);
    }

    public List<MBMessage> getGroupMessages(long groupId, long userId, int start, int end) throws SystemException {
        return this.mbMessagePersistence.findByG_U(groupId, userId, start, end);
    }

    public List<MBMessage> getGroupMessages(long groupId, long userId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.mbMessagePersistence.findByG_U(groupId, userId, start, end, obc);
    }

    public int getGroupMessagesCount(long groupId) throws SystemException {
        return this.mbMessagePersistence.countByGroupId(groupId);
    }

    public int getGroupMessagesCount(long groupId, long userId) throws SystemException {
        return this.mbMessagePersistence.countByG_U(groupId, userId);
    }

    public MBMessage getMessage(long messageId) throws PortalException, SystemException {
        return this.mbMessagePersistence.findByPrimaryKey(messageId);
    }

    public MBMessageDisplay getMessageDisplay(long messageId, String threadView) throws PortalException, SystemException {
        MBMessage message = this.getMessage(messageId);
        return this.getMessageDisplay(message, threadView);
    }

    public MBMessageDisplay getMessageDisplay(MBMessage message, String threadView) throws PortalException, SystemException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(message.getCategoryId());
        MBMessage parentMessage = null;
        if (message.isReply()) {
            parentMessage = this.mbMessagePersistence.findByPrimaryKey(message.getParentMessageId());
        }
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
        if (!message.isDiscussion()) {
            this.mbThreadLocalService.updateThread(thread.getThreadId(), thread.getViewCount() + 1);
        }
        ThreadLastPostDateComparator comparator = new ThreadLastPostDateComparator(false);
        MBThread[] prevAndNextThreads = this.mbThreadPersistence.findByCategoryId_PrevAndNext(message.getThreadId(), message.getCategoryId(), (OrderByComparator)comparator);
        MBThread previousThread = prevAndNextThreads[0];
        MBThread nextThread = prevAndNextThreads[2];
        return new MBMessageDisplayImpl(message, parentMessage, category, thread, previousThread, nextThread, threadView);
    }

    public List<MBMessage> getMessages(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.mbMessagePersistence.findByC_C(classNameId, classPK);
    }

    public List<MBMessage> getNoAssetMessages() throws SystemException {
        return this.mbMessageFinder.findByNoAssets();
    }

    public int getPositionInThread(long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        return this.mbMessageFinder.countByC_T(message.getCreateDate(), message.getThreadId());
    }

    public List<MBMessage> getThreadMessages(long threadId) throws SystemException {
        return this.getThreadMessages(threadId, (Comparator<MBMessage>)new MessageThreadComparator());
    }

    public List<MBMessage> getThreadMessages(long threadId, Comparator<MBMessage> comparator) throws SystemException {
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        return ListUtil.sort((List)messages, comparator);
    }

    public List<MBMessage> getThreadMessages(long threadId, int start, int end) throws SystemException {
        return this.mbMessagePersistence.findByThreadId(threadId, start, end);
    }

    public int getThreadMessagesCount(long threadId) throws SystemException {
        return this.mbMessagePersistence.countByThreadId(threadId);
    }

    public List<MBMessage> getThreadRepliesMessages(long threadId, int start, int end) throws SystemException {
        return this.mbMessagePersistence.findByThreadReplies(threadId, start, end);
    }

    public void reIndex(long messageId) throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        MBMessage message = this.mbMessagePersistence.fetchByPrimaryKey(messageId);
        if (message == null) {
            return;
        }
        if (message.isRoot()) {
            List messages = this.mbMessagePersistence.findByThreadId(message.getThreadId());
            for (MBMessage curMessage : messages) {
                this.reIndex(curMessage);
            }
        } else {
            this.reIndex(message);
        }
    }

    public void reIndex(MBMessage message) throws SystemException {
        if (message.isDiscussion()) {
            return;
        }
        long companyId = message.getCompanyId();
        long groupId = message.getGroupId();
        long userId = message.getUserId();
        String userName = message.getUserName();
        long categoryId = message.getCategoryId();
        long threadId = message.getThreadId();
        long messageId = message.getMessageId();
        String title = message.getSubject();
        String content = message.getBody();
        boolean anonymous = message.isAnonymous();
        Date modifiedDate = message.getModifiedDate();
        String[] tagsEntries = this.tagsEntryLocalService.getEntryNames(MBMessage.class.getName(), messageId);
        ExpandoBridge expandoBridge = message.getExpandoBridge();
        try {
            Indexer.updateMessage(companyId, groupId, userId, userName, categoryId, threadId, messageId, title, content, anonymous, modifiedDate, tagsEntries, expandoBridge);
        }
        catch (SearchException se) {
            _log.error((Object)("Reindexing " + messageId), (Throwable)se);
        }
    }

    public void subscribeMessage(long userId, long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.subscriptionLocalService.addSubscription(userId, MBThread.class.getName(), message.getThreadId());
    }

    public void unsubscribeMessage(long userId, long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.subscriptionLocalService.deleteSubscription(userId, MBThread.class.getName(), message.getThreadId());
    }

    public MBMessage updateDiscussionMessage(long userId, long messageId, String subject, String body) throws PortalException, SystemException {
        if (Validator.isNull((String)subject)) {
            subject = "N/A";
        }
        ArrayList<ObjectValuePair<String, byte[]>> files = new ArrayList<ObjectValuePair<String, byte[]>>();
        ArrayList<String> existingFiles = new ArrayList<String>();
        double priority = 0.0;
        ServiceContext serviceContext = new ServiceContext();
        return this.updateMessage(userId, messageId, subject, body, files, existingFiles, priority, serviceContext);
    }

    public MBMessage updateMessage(long messageId, Date createDate, Date modifiedDate) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        message.setCreateDate(createDate);
        message.setModifiedDate(modifiedDate);
        this.mbMessagePersistence.update((BaseModel)message, false);
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
        if (message.isAnonymous()) {
            thread.setLastPostByUserId(0L);
        } else {
            thread.setLastPostByUserId(message.getUserId());
        }
        thread.setLastPostDate(modifiedDate);
        this.mbThreadPersistence.update((BaseModel)thread, false);
        if (!message.isDiscussion()) {
            MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(message.getCategoryId());
            category.setLastPostDate(modifiedDate);
            this.mbCategoryPersistence.update((BaseModel)category, false);
            this.mbStatsUserLocalService.updateStatsUser(message.getGroupId(), message.getUserId(), modifiedDate);
        }
        return message;
    }

    public MBMessage updateMessage(long userId, long messageId, String subject, String body, List<ObjectValuePair<String, byte[]>> files, List<String> existingFiles, double priority, ServiceContext serviceContext) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        MBCategory category = message.getCategory();
        subject = ModelHintsUtil.trimString((String)MBMessage.class.getName(), (String)"subject", (String)subject);
        Date now = new Date();
        this.validate(subject, body);
        message.setModifiedDate(now);
        message.setSubject(subject);
        message.setBody(body);
        message.setAttachments(!files.isEmpty() || !existingFiles.isEmpty());
        if (priority != -1.0) {
            message.setPriority(priority);
        }
        long companyId = message.getCompanyId();
        String portletId = CompanyConstants.SYSTEM_STRING;
        long groupId = 0L;
        long repositoryId = 0L;
        String dirName = message.getAttachmentsDir();
        if (!files.isEmpty() || !existingFiles.isEmpty()) {
            String[] fileNames;
            try {
                this.dlService.addDirectory(companyId, repositoryId, dirName);
            }
            catch (DuplicateDirectoryException dde) {
                // empty catch block
            }
            for (String fileName : fileNames = this.dlService.getFileNames(companyId, repositoryId, dirName)) {
                if (existingFiles.contains(fileName)) continue;
                this.dlService.deleteFile(companyId, portletId, repositoryId, fileName);
            }
            for (int i = 0; i < files.size(); ++i) {
                ObjectValuePair<String, byte[]> ovp = files.get(i);
                String fileName = (String)ovp.getKey();
                byte[] bytes = (byte[])ovp.getValue();
                try {
                    this.dlService.addFile(companyId, portletId, groupId, repositoryId, dirName + "/" + fileName, 0L, "", message.getModifiedDate(), new String[0], new String[0], bytes);
                    continue;
                }
                catch (DuplicateFileException dfe) {
                    // empty catch block
                }
            }
        } else {
            try {
                this.dlService.deleteDirectory(companyId, portletId, repositoryId, dirName);
            }
            catch (NoSuchDirectoryException nsde) {
                // empty catch block
            }
        }
        this.mbMessagePersistence.update((BaseModel)message, false);
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
        if (priority != -1.0 && thread.getPriority() != priority) {
            thread.setPriority(priority);
            this.mbThreadPersistence.update((BaseModel)thread, false);
            this.updatePriorities(thread.getThreadId(), priority);
        }
        if (!message.isDiscussion()) {
            category.setLastPostDate(now);
            this.mbCategoryPersistence.update((BaseModel)category, false);
        }
        this.notifySubscribers(category, message, serviceContext, true);
        this.updateTagsAsset(userId, message, serviceContext.getTagsEntries());
        this.reIndex(message);
        return message;
    }

    public MBMessage updateMessage(long messageId, String body) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        message.setBody(body);
        this.mbMessagePersistence.update((BaseModel)message, false);
        return message;
    }

    public void updateTagsAsset(long userId, MBMessage message, String[] tagsEntries) throws PortalException, SystemException {
        if (message.isDiscussion()) {
            return;
        }
        this.tagsAssetLocalService.updateAsset(userId, message.getGroupId(), MBMessage.class.getName(), message.getMessageId(), null, tagsEntries, true, null, null, null, null, "text/html", message.getSubject(), null, null, null, 0, 0, null, false);
    }

    protected void deleteDiscussionSocialActivities(String className, List<MBMessage> messages) throws PortalException, SystemException {
        if (messages.size() == 0) {
            return;
        }
        MBMessage message = messages.get(0);
        MBDiscussion discussion = this.mbDiscussionPersistence.findByThreadId(message.getThreadId());
        long classNameId = PortalUtil.getClassNameId((String)className);
        long classPK = discussion.getClassPK();
        if (discussion.getClassNameId() != classNameId) {
            return;
        }
        HashSet<Long> messageIds = new HashSet<Long>();
        for (MBMessage curMessage : messages) {
            messageIds.add(curMessage.getMessageId());
        }
        List socialActivities = this.socialActivityLocalService.getActivities(0L, className, classPK, -1, -1);
        for (SocialActivity socialActivity : socialActivities) {
            JSONObject extraData;
            long extraDataMessageId;
            if (Validator.isNull((String)socialActivity.getExtraData()) || !messageIds.contains(extraDataMessageId = (extraData = JSONFactoryUtil.createJSONObject((String)socialActivity.getExtraData())).getLong("messageId"))) continue;
            this.socialActivityLocalService.deleteActivity(socialActivity.getActivityId());
        }
    }

    protected void notifySubscribers(MBCategory category, MBMessage message, ServiceContext serviceContext, boolean update) throws PortalException, SystemException {
        String layoutFullURL = serviceContext.getLayoutFullURL();
        if (Validator.isNull((String)layoutFullURL) || category.isDiscussion()) {
            return;
        }
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences == null) {
            long ownerId = category.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "19";
            String defaultPreferences = null;
            preferences = this.portletPreferencesLocalService.getPreferences(category.getCompanyId(), ownerId, ownerType, plid, portletId, defaultPreferences);
        }
        if (!(!update && MBUtil.getEmailMessageAddedEnabled(preferences) || update && MBUtil.getEmailMessageUpdatedEnabled(preferences))) {
            return;
        }
        Company company = this.companyPersistence.findByPrimaryKey(message.getCompanyId());
        Group group = this.groupPersistence.findByPrimaryKey(category.getGroupId());
        String emailAddress = "";
        String fullName = message.getUserName();
        try {
            User user = this.userPersistence.findByPrimaryKey(message.getUserId());
            emailAddress = user.getEmailAddress();
            fullName = user.getFullName();
        }
        catch (NoSuchUserException nsue) {
            // empty catch block
        }
        if (message.isAnonymous()) {
            emailAddress = "";
            fullName = LanguageUtil.get((Locale)ServiceContextUtil.getLocale((ServiceContext)serviceContext), (String)"anonymous");
        }
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        categoryIds.add(category.getCategoryId());
        categoryIds.addAll(category.getAncestorCategoryIds());
        String messageURL = layoutFullURL + "/-/" + "message_boards/message/" + message.getMessageId();
        String portletName = PortalUtil.getPortletTitle((String)"19", (Locale)LocaleUtil.getDefault());
        String fromName = MBUtil.getEmailFromName(preferences);
        String fromAddress = MBUtil.getEmailFromAddress(preferences);
        String mailingListAddress = "";
        if (PropsValues.POP_SERVER_NOTIFICATIONS_ENABLED) {
            mailingListAddress = MBUtil.getMailingListAddress(message.getCategoryId(), message.getMessageId(), company.getMx(), fromAddress);
        }
        String replyToAddress = mailingListAddress;
        String mailId = MBUtil.getMailId(company.getMx(), message.getCategoryId(), message.getMessageId());
        fromName = StringUtil.replace((String)fromName, (String[])new String[]{"[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$MAILING_LIST_ADDRESS$]", "[$MESSAGE_USER_ADDRESS$]", "[$MESSAGE_USER_NAME$]", "[$PORTLET_NAME$]"}, (String[])new String[]{String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), mailingListAddress, emailAddress, fullName, portletName});
        fromAddress = StringUtil.replace((String)fromAddress, (String[])new String[]{"[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$MAILING_LIST_ADDRESS$]", "[$MESSAGE_USER_ADDRESS$]", "[$MESSAGE_USER_NAME$]", "[$PORTLET_NAME$]"}, (String[])new String[]{String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), mailingListAddress, emailAddress, fullName, portletName});
        String subjectPrefix = null;
        String body = null;
        String signature = null;
        boolean htmlFormat = MBUtil.getEmailHtmlFormat(preferences);
        if (update) {
            subjectPrefix = MBUtil.getEmailMessageUpdatedSubjectPrefix(preferences);
            body = MBUtil.getEmailMessageUpdatedBody(preferences);
            signature = MBUtil.getEmailMessageUpdatedSignature(preferences);
        } else {
            subjectPrefix = MBUtil.getEmailMessageAddedSubjectPrefix(preferences);
            body = MBUtil.getEmailMessageAddedBody(preferences);
            signature = MBUtil.getEmailMessageAddedSignature(preferences);
        }
        if (Validator.isNotNull((String)signature)) {
            body = body + "\n--\n" + signature;
        }
        subjectPrefix = StringUtil.replace((String)subjectPrefix, (String[])new String[]{"[$CATEGORY_NAME$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$MAILING_LIST_ADDRESS$]", "[$MESSAGE_BODY$]", "[$MESSAGE_ID$]", "[$MESSAGE_SUBJECT$]", "[$MESSAGE_USER_ADDRESS$]", "[$MESSAGE_USER_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]"}, (String[])new String[]{category.getName(), String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), fromAddress, fromName, mailingListAddress, message.getBody(), String.valueOf(message.getMessageId()), message.getSubject(), emailAddress, fullName, company.getVirtualHost(), portletName});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$CATEGORY_NAME$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$MAILING_LIST_ADDRESS$]", "[$MESSAGE_BODY$]", "[$MESSAGE_ID$]", "[$MESSAGE_SUBJECT$]", "[$MESSAGE_URL$]", "[$MESSAGE_USER_ADDRESS$]", "[$MESSAGE_USER_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]"}, (String[])new String[]{category.getName(), String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), fromAddress, fromName, mailingListAddress, message.getBody(), String.valueOf(message.getMessageId()), message.getSubject(), messageURL, emailAddress, fullName, company.getVirtualHost(), portletName});
        String subject = message.getSubject();
        if (subject.indexOf(subjectPrefix) == -1) {
            subject = subjectPrefix.trim() + " " + subject.trim();
        }
        String inReplyTo = null;
        if (message.getParentMessageId() != 0L) {
            inReplyTo = MBUtil.getMailId(company.getMx(), message.getCategoryId(), message.getParentMessageId());
        }
        Message messagingObj = new Message();
        messagingObj.put("companyId", (Object)message.getCompanyId());
        messagingObj.put("userId", (Object)message.getUserId());
        messagingObj.put("groupId", (Object)message.getGroupId());
        messagingObj.put("categoryIds", (Object)StringUtil.merge(categoryIds));
        messagingObj.put("threadId", (Object)message.getThreadId());
        messagingObj.put("fromName", (Object)fromName);
        messagingObj.put("fromAddress", (Object)fromAddress);
        messagingObj.put("subject", (Object)subject);
        messagingObj.put("body", (Object)body);
        messagingObj.put("replyToAddress", (Object)replyToAddress);
        messagingObj.put("mailId", (Object)mailId);
        messagingObj.put("inReplyTo", (Object)inReplyTo);
        messagingObj.put("htmlFormat", (Object)htmlFormat);
        messagingObj.put("sourceMailingList", (Object)MailingListThreadLocal.isSourceMailingList());
        MessageBusUtil.sendMessage((String)"liferay/message_boards", (Message)messagingObj);
    }

    protected void sendBlogsCommentsEmail(long userId, BlogsEntry entry, MBMessage message, ServiceContext serviceContext) throws IOException, PortalException, SystemException {
        long companyId = message.getCompanyId();
        if (!PrefsPropsUtil.getBoolean(companyId, "blogs.email.comments.added.enabled")) {
            return;
        }
        String layoutFullURL = serviceContext.getLayoutFullURL();
        String blogsEntryURL = layoutFullURL + "/-/" + "blogs/" + entry.getUrlTitle();
        User blogsUser = this.userPersistence.findByPrimaryKey(entry.getUserId());
        User commentsUser = this.userPersistence.findByPrimaryKey(userId);
        String fromName = PrefsPropsUtil.getString(companyId, "admin.email.from.name");
        String fromAddress = PrefsPropsUtil.getString(companyId, "admin.email.from.address");
        String toName = blogsUser.getFullName();
        String toAddress = blogsUser.getEmailAddress();
        String subject = PrefsPropsUtil.getContent(companyId, "blogs.email.comments.added.subject");
        String body = PrefsPropsUtil.getContent(companyId, "blogs.email.comments.added.body");
        subject = StringUtil.replace((String)subject, (String[])new String[]{"[$BLOGS_COMMENTS_BODY$]", "[$BLOGS_COMMENTS_USER_ADDRESS$]", "[$BLOGS_COMMENTS_USER_NAME$]", "[$BLOGS_ENTRY_URL$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$TO_ADDRESS$]", "[$TO_NAME$]"}, (String[])new String[]{message.getBody(), commentsUser.getEmailAddress(), commentsUser.getFullName(), blogsEntryURL, fromAddress, fromName, toAddress, toName});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$BLOGS_COMMENTS_BODY$]", "[$BLOGS_COMMENTS_USER_ADDRESS$]", "[$BLOGS_COMMENTS_USER_NAME$]", "[$BLOGS_ENTRY_URL$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$TO_ADDRESS$]", "[$TO_NAME$]"}, (String[])new String[]{message.getBody(), commentsUser.getEmailAddress(), commentsUser.getFullName(), blogsEntryURL, fromAddress, fromName, toAddress, toName});
        InternetAddress from = new InternetAddress(fromAddress, fromName);
        InternetAddress to = new InternetAddress(toAddress, toName);
        MailMessage mailMessage = new MailMessage(from, to, subject, body, true);
        this.mailService.sendEmail(mailMessage);
    }

    protected void updatePriorities(long threadId, double priority) throws SystemException {
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            if (message.getPriority() == priority) continue;
            message.setPriority(priority);
            this.mbMessagePersistence.update((BaseModel)message, false);
        }
    }

    protected void validate(String subject, String body) throws PortalException {
        if (Validator.isNull((String)subject)) {
            throw new MessageSubjectException();
        }
        if (Validator.isNull((String)body)) {
            throw new MessageBodyException();
        }
    }
}

