/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.documentlibrary.DuplicateDirectoryException;
import com.liferay.documentlibrary.NoSuchDirectoryException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CompanyConstants;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.SplitThreadException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.base.MBThreadLocalServiceBaseImpl;
import com.liferay.portlet.messageboards.util.Indexer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBThreadLocalServiceImpl
extends MBThreadLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(MBThreadLocalServiceImpl.class);

    public void deleteThread(long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        this.deleteThread(thread);
    }

    public void deleteThread(MBThread thread) throws PortalException, SystemException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(thread.getCategoryId());
        MBMessage rootMessage = this.mbMessagePersistence.findByPrimaryKey(thread.getRootMessageId());
        try {
            Indexer.deleteMessages(rootMessage.getCompanyId(), thread.getThreadId());
        }
        catch (SearchException se) {
            _log.error((Object)("Deleting index " + thread.getThreadId()), (Throwable)se);
        }
        long companyId = rootMessage.getCompanyId();
        String portletId = CompanyConstants.SYSTEM_STRING;
        long repositoryId = 0L;
        String dirName = thread.getAttachmentsDir();
        try {
            this.dlService.deleteDirectory(companyId, portletId, repositoryId, dirName);
        }
        catch (NoSuchDirectoryException nsde) {
            // empty catch block
        }
        List messages = this.mbMessagePersistence.findByThreadId(thread.getThreadId());
        for (MBMessage message : messages) {
            this.tagsAssetLocalService.deleteAsset(MBMessage.class.getName(), message.getMessageId());
            this.socialActivityLocalService.deleteActivities(MBMessage.class.getName(), message.getMessageId());
            this.ratingsStatsLocalService.deleteStats(MBMessage.class.getName(), message.getMessageId());
            if (!category.isDiscussion()) {
                this.mbStatsUserLocalService.updateStatsUser(message.getGroupId(), message.getUserId());
            }
            this.mbMessageFlagPersistence.removeByMessageId(message.getMessageId());
            if (!message.isDiscussion()) {
                this.resourceLocalService.deleteResource(message.getCompanyId(), MBMessage.class.getName(), 4, message.getMessageId());
            }
            this.mbMessagePersistence.remove((BaseModel)message);
        }
        category.setThreadCount(category.getThreadCount() - 1);
        category.setMessageCount(category.getMessageCount() - messages.size());
        this.mbCategoryPersistence.update((BaseModel)category, false);
        this.mbThreadPersistence.remove((BaseModel)thread);
    }

    public void deleteThreads(long categoryId) throws PortalException, SystemException {
        List threads = this.mbThreadPersistence.findByCategoryId(categoryId);
        for (MBThread thread : threads) {
            this.deleteThread(thread);
        }
    }

    public int getCategoryThreadsCount(long categoryId) throws SystemException {
        return this.mbThreadPersistence.countByCategoryId(categoryId);
    }

    public List<MBThread> getGroupThreads(long groupId, int start, int end) throws SystemException {
        return this.mbThreadPersistence.findByGroupId(groupId, start, end);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, boolean subscribed, boolean includeAnonymous, int start, int end) throws PortalException, SystemException {
        if (userId <= 0L) {
            return this.mbThreadPersistence.findByGroupId(groupId, start, end);
        }
        if (subscribed) {
            return this.mbThreadFinder.findByS_G_U(groupId, userId, start, end);
        }
        List threadIds = null;
        threadIds = includeAnonymous ? this.mbMessageFinder.findByG_U(groupId, userId, start, end) : this.mbMessageFinder.findByG_U_A(groupId, userId, false, start, end);
        ArrayList<MBThread> threads = new ArrayList<MBThread>(threadIds.size());
        Iterator i$ = threadIds.iterator();
        while (i$.hasNext()) {
            long threadId = (Long)i$.next();
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
            threads.add(thread);
        }
        return threads;
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, boolean subscribed, int start, int end) throws PortalException, SystemException {
        return this.getGroupThreads(groupId, userId, subscribed, true, start, end);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int start, int end) throws PortalException, SystemException {
        return this.getGroupThreads(groupId, userId, false, start, end);
    }

    public int getGroupThreadsCount(long groupId) throws SystemException {
        return this.mbThreadPersistence.countByGroupId(groupId);
    }

    public int getGroupThreadsCount(long groupId, long userId) throws SystemException {
        return this.getGroupThreadsCount(groupId, userId, false);
    }

    public int getGroupThreadsCount(long groupId, long userId, boolean subscribed) throws SystemException {
        return this.getGroupThreadsCount(groupId, userId, subscribed, true);
    }

    public int getGroupThreadsCount(long groupId, long userId, boolean subscribed, boolean includeAnonymous) throws SystemException {
        if (userId <= 0L) {
            return this.mbThreadPersistence.countByGroupId(groupId);
        }
        if (subscribed) {
            return this.mbThreadFinder.countByS_G_U(groupId, userId);
        }
        if (includeAnonymous) {
            return this.mbMessageFinder.countByG_U(groupId, userId);
        }
        return this.mbMessageFinder.countByG_U_A(groupId, userId, false);
    }

    public MBThread getThread(long threadId) throws PortalException, SystemException {
        return this.mbThreadPersistence.findByPrimaryKey(threadId);
    }

    public List<MBThread> getThreads(long categoryId, int start, int end) throws SystemException {
        return this.mbThreadPersistence.findByCategoryId(categoryId, start, end);
    }

    public int getThreadsCount(long categoryId) throws SystemException {
        return this.mbThreadPersistence.countByCategoryId(categoryId);
    }

    public MBThread moveThread(long categoryId, long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        long oldCategoryId = thread.getCategoryId();
        MBCategory oldCategory = this.mbCategoryPersistence.findByPrimaryKey(oldCategoryId);
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        List messages = this.mbMessagePersistence.findByC_T(oldCategoryId, thread.getThreadId());
        for (MBMessage message : messages) {
            message.setCategoryId(category.getCategoryId());
            this.mbMessagePersistence.update((BaseModel)message, false);
            try {
                if (category.isDiscussion()) continue;
                Indexer.updateMessage(message.getCompanyId(), message.getGroupId(), message.getUserId(), message.getUserName(), category.getCategoryId(), message.getThreadId(), message.getMessageId(), message.getSubject(), message.getBody(), message.isAnonymous(), message.getModifiedDate(), message.getTagsEntries(), message.getExpandoBridge());
            }
            catch (SearchException se) {
                _log.error((Object)("Indexing " + message.getMessageId()), (Throwable)se);
            }
        }
        thread.setCategoryId(category.getCategoryId());
        this.mbThreadPersistence.update((BaseModel)thread, false);
        oldCategory.setThreadCount(oldCategory.getThreadCount() - 1);
        oldCategory.setMessageCount(oldCategory.getMessageCount() - messages.size());
        this.mbCategoryPersistence.update((BaseModel)oldCategory, false);
        category.setThreadCount(category.getThreadCount() + 1);
        category.setMessageCount(category.getMessageCount() + messages.size());
        this.mbCategoryPersistence.update((BaseModel)category, false);
        return thread;
    }

    public MBThread splitThread(long messageId, ServiceContext serviceContext) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        if (message.isRoot()) {
            throw new SplitThreadException();
        }
        MBCategory category = message.getCategory();
        long oldThreadId = message.getThreadId();
        String oldAttachmentsDir = message.getAttachmentsDir();
        this.mbMessageFlagLocalService.deleteThreadFlags(oldThreadId);
        MBThread thread = this.addThread(message.getCategoryId(), message);
        message.setThreadId(thread.getThreadId());
        message.setParentMessageId(0L);
        message.setAttachmentsDir(null);
        this.mbMessagePersistence.update((BaseModel)message, false);
        this.moveAttachmentsFromOldThread(message, oldAttachmentsDir);
        try {
            if (!category.isDiscussion()) {
                Indexer.updateMessage(message.getCompanyId(), message.getGroupId(), message.getUserId(), message.getUserName(), category.getCategoryId(), message.getThreadId(), message.getMessageId(), message.getSubject(), message.getBody(), message.isAnonymous(), message.getModifiedDate(), message.getTagsEntries(), message.getExpandoBridge());
            }
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + message.getMessageId()), (Throwable)se);
        }
        int messagesMoved = 1;
        thread.setMessageCount(messagesMoved += this.moveChildrenMessages(message, category, oldThreadId));
        this.mbThreadPersistence.update((BaseModel)thread, false);
        MBThread oldThread = this.mbThreadPersistence.findByPrimaryKey(oldThreadId);
        oldThread.setMessageCount(oldThread.getMessageCount() - messagesMoved);
        this.mbThreadPersistence.update((BaseModel)oldThread, false);
        category.setThreadCount(category.getThreadCount() + 1);
        this.mbCategoryPersistence.update((BaseModel)category, false);
        return thread;
    }

    public MBThread updateThread(long threadId, int viewCount) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        thread.setViewCount(viewCount);
        this.mbThreadPersistence.update((BaseModel)thread, false);
        return thread;
    }

    protected MBThread addThread(long categoryId, MBMessage message) throws SystemException {
        long threadId = this.counterLocalService.increment();
        MBThread thread = this.mbThreadPersistence.create(threadId);
        thread.setGroupId(message.getGroupId());
        thread.setCategoryId(categoryId);
        thread.setRootMessageId(message.getMessageId());
        thread.setMessageCount(thread.getMessageCount() + 1);
        if (message.isAnonymous()) {
            thread.setLastPostByUserId(0L);
        } else {
            thread.setLastPostByUserId(message.getUserId());
        }
        thread.setLastPostDate(message.getCreateDate());
        if (message.getPriority() != -1.0) {
            thread.setPriority(message.getPriority());
        }
        this.mbThreadPersistence.update((BaseModel)thread, false);
        return thread;
    }

    protected void moveAttachmentsFromOldThread(MBMessage message, String oldAttachmentsDir) throws PortalException, SystemException {
        String[] fileNames;
        if (!message.getAttachments()) {
            return;
        }
        long companyId = message.getCompanyId();
        String portletId = CompanyConstants.SYSTEM_STRING;
        long groupId = 0L;
        long repositoryId = 0L;
        String newAttachmentsDir = message.getAttachmentsDir();
        try {
            this.dlService.addDirectory(companyId, repositoryId, newAttachmentsDir);
        }
        catch (DuplicateDirectoryException dde) {
            // empty catch block
        }
        for (String fileName : fileNames = this.dlService.getFileNames(companyId, repositoryId, oldAttachmentsDir)) {
            String name = StringUtil.extractLast((String)fileName, (String)"/");
            byte[] fileBytes = this.dlService.getFile(companyId, repositoryId, fileName);
            this.dlService.addFile(companyId, portletId, groupId, repositoryId, newAttachmentsDir + "/" + name, 0L, "", message.getModifiedDate(), new String[0], new String[0], fileBytes);
            this.dlService.deleteFile(companyId, portletId, repositoryId, fileName);
        }
        try {
            this.dlService.deleteDirectory(companyId, portletId, repositoryId, oldAttachmentsDir);
        }
        catch (NoSuchDirectoryException nsde) {
            // empty catch block
        }
    }

    protected int moveChildrenMessages(MBMessage parentMessage, MBCategory category, long oldThreadId) throws SystemException, PortalException {
        int messagesMoved = 0;
        List messages = this.mbMessagePersistence.findByT_P(oldThreadId, parentMessage.getMessageId());
        for (MBMessage message : messages) {
            String oldAttachmentsDir = message.getAttachmentsDir();
            message.setCategoryId(parentMessage.getCategoryId());
            message.setThreadId(parentMessage.getThreadId());
            message.setAttachmentsDir(null);
            this.mbMessagePersistence.update((BaseModel)message, false);
            this.moveAttachmentsFromOldThread(message, oldAttachmentsDir);
            try {
                if (!category.isDiscussion()) {
                    Indexer.updateMessage(message.getCompanyId(), message.getGroupId(), message.getUserId(), message.getUserName(), category.getCategoryId(), message.getThreadId(), message.getMessageId(), message.getSubject(), message.getBody(), message.isAnonymous(), message.getModifiedDate(), message.getTagsEntries(), message.getExpandoBridge());
                }
            }
            catch (SearchException se) {
                _log.error((Object)("Indexing " + message.getMessageId()), (Throwable)se);
            }
            ++messagesMoved;
            messagesMoved += this.moveChildrenMessages(message, category, oldThreadId);
        }
        return messagesMoved;
    }
}

