/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.LockedThreadException;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBThreadModelImpl;
import com.liferay.portlet.messageboards.service.base.MBThreadServiceBaseImpl;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import java.util.List;

public class MBThreadServiceImpl
extends MBThreadServiceBaseImpl {
    public void deleteThread(long threadId) throws PortalException, SystemException {
        if (this.lockLocalService.isLocked(MBThread.class.getName(), threadId)) {
            throw new LockedThreadException();
        }
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            MBMessagePermission.check(this.getPermissionChecker(), message.getMessageId(), "DELETE");
        }
        this.mbThreadLocalService.deleteThread(threadId);
    }

    public Lock lockThread(long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), thread.getCategoryId(), "LOCK_THREAD");
        return this.lockLocalService.lock(this.getUserId(), MBThread.class.getName(), threadId, String.valueOf(threadId), false, MBThreadModelImpl.LOCK_EXPIRATION_TIME);
    }

    public MBThread moveThread(long categoryId, long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getCategoryId(), "MOVE_THREAD");
        MBCategoryPermission.check(this.getPermissionChecker(), categoryId, "MOVE_THREAD");
        return this.mbThreadLocalService.moveThread(categoryId, threadId);
    }

    public MBThread splitThread(long messageId, ServiceContext serviceContext) throws PortalException, SystemException {
        MBMessage message = this.mbMessageLocalService.getMessage(messageId);
        MBCategoryPermission.check(this.getPermissionChecker(), message.getCategoryId(), "MOVE_THREAD");
        return this.mbThreadLocalService.splitThread(messageId, serviceContext);
    }

    public void unlockThread(long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), thread.getCategoryId(), "LOCK_THREAD");
        this.lockLocalService.unlock(MBThread.class.getName(), threadId);
    }
}

