/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.service.MBBanLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBPermission;

public class MBCategoryPermission {
    public static void check(PermissionChecker permissionChecker, long groupId, long categoryId, String actionId) throws PortalException, SystemException {
        if (!MBCategoryPermission.contains(permissionChecker, groupId, categoryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long categoryId, String actionId) throws PortalException, SystemException {
        if (!MBCategoryPermission.contains(permissionChecker, categoryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, MBCategory category, String actionId) throws PortalException, SystemException {
        if (!MBCategoryPermission.contains(permissionChecker, category, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long categoryId, String actionId) throws PortalException, SystemException {
        if (categoryId == MBCategoryImpl.DEFAULT_PARENT_CATEGORY_ID) {
            return MBPermission.contains(permissionChecker, groupId, actionId);
        }
        return MBCategoryPermission.contains(permissionChecker, categoryId, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long categoryId, String actionId) throws PortalException, SystemException {
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
        return MBCategoryPermission.contains(permissionChecker, category, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, MBCategory category, String actionId) throws PortalException, SystemException {
        if (actionId.equals("ADD_CATEGORY")) {
            actionId = "ADD_SUBCATEGORY";
        }
        if (MBBanLocalServiceUtil.hasBan((long)category.getGroupId(), (long)permissionChecker.getUserId())) {
            return false;
        }
        long categoryId = category.getCategoryId();
        if (actionId.equals("VIEW")) {
            while (categoryId != MBCategoryImpl.DEFAULT_PARENT_CATEGORY_ID) {
                category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
                categoryId = category.getParentCategoryId();
                if (!permissionChecker.hasOwnerPermission(category.getCompanyId(), MBCategory.class.getName(), category.getCategoryId(), category.getUserId(), actionId) && !permissionChecker.hasPermission(category.getGroupId(), MBCategory.class.getName(), category.getCategoryId(), actionId)) {
                    return false;
                }
                if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) continue;
            }
            return true;
        }
        while (categoryId != MBCategoryImpl.DEFAULT_PARENT_CATEGORY_ID) {
            if (permissionChecker.hasOwnerPermission(category.getCompanyId(), MBCategory.class.getName(), category.getCategoryId(), category.getUserId(), actionId)) {
                return true;
            }
            if (permissionChecker.hasPermission(category.getGroupId(), MBCategory.class.getName(), category.getCategoryId(), actionId)) {
                return true;
            }
            if (actionId.equals("VIEW")) break;
            category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
            categoryId = category.getParentCategoryId();
        }
        return false;
    }
}

